package com.dada.response.watcher.http.convert;

import com.alibaba.fastjson.JSON;

import java.io.IOException;
import java.lang.reflect.Type;

import okhttp3.ResponseBody;
import retrofit2.Converter;

public class FastJsonResponseBodyConverter<T> implements Converter<ResponseBody, T> {
    private final Type type;

    public FastJsonResponseBodyConverter(Type type) {
        this.type = type;
    }

    /*
     * 转换方法
     */
    @Override
    public T convert(ResponseBody value) throws IOException {
        //        BufferedSource bufferedSource = Okio.buffer(value.source());
        //        String tempStr = bufferedSource.readUtf8();
        //        bufferedSource.close();
        return JSON.parseObject(value.string(), type);
    }
}
