package com.dada.response.watcher.entity;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by whh on 2019/5/31
 */

public class NetStatusCache implements Cloneable {

    public Map<String, Long> statusMap = new HashMap<>();

    @Override
    public Object clone() throws CloneNotSupportedException {
        NetStatusCache statusCache = (NetStatusCache) super.clone();

        Map<String, Long> statusCopy = new HashMap<>();
        for (Map.Entry<String, Long> status : statusMap.entrySet()) {
            statusCopy.put(status.getKey(), status.getValue());
        }
        statusCache.statusMap = statusCopy;
        return statusCache;
    }

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder();

        for (String key : statusMap.keySet()) {
            output.append("NetStatus [statusMap ").append(key).append(" = ").append(statusMap.get(key)).append("]\n");
        }

        return output.toString();
    }
}
