/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.mapping.ReflectionUtils;
import com.datastax.driver.mapping.annotations.ClusteringColumn;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.Computed;
import com.datastax.driver.mapping.annotations.Defaults;
import com.datastax.driver.mapping.annotations.Field;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Transient;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

class PropertyMapper {
    private final String propertyName;
    final String alias;
    final String columnName;
    final TypeToken<Object> javaType;
    final TypeCodec<Object> customCodec;
    final int position;
    private final java.lang.reflect.Field field;
    private final Method getter;
    private final Method setter;
    private final Map<Class<? extends Annotation>, Annotation> annotations;

    PropertyMapper(Class<?> baseClass, String propertyName, String alias, java.lang.reflect.Field field, PropertyDescriptor property) {
        this.propertyName = propertyName;
        this.alias = alias;
        this.field = field;
        this.getter = ReflectionUtils.findGetter(property);
        this.setter = ReflectionUtils.findSetter(baseClass, property);
        this.annotations = ReflectionUtils.scanPropertyAnnotations(field, property);
        if (field != null) {
            ReflectionUtils.tryMakeAccessible(field);
        }
        if (this.getter != null) {
            ReflectionUtils.tryMakeAccessible(this.getter);
        }
        if (this.setter != null) {
            ReflectionUtils.tryMakeAccessible(this.setter);
        }
        if (!this.isTransient()) {
            Preconditions.checkArgument(field != null && field.isAccessible() || this.getter != null && this.getter.isAccessible(), "Property '%s' is not readable", new Object[]{propertyName});
            Preconditions.checkArgument(field != null && field.isAccessible() || this.setter != null && this.setter.isAccessible(), "Property '%s' is not writable", new Object[]{propertyName});
        }
        this.columnName = this.inferColumnName();
        this.position = this.inferPosition();
        this.javaType = this.inferJavaType();
        this.customCodec = this.createCustomCodec();
    }

    Object getValue(Object entity) {
        try {
            if (this.getter != null && this.getter.isAccessible()) {
                return this.getter.invoke(entity, new Object[0]);
            }
            return this.field.get(entity);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to read property '" + this.propertyName + "' in " + entity.getClass(), e);
        }
    }

    void setValue(Object entity, Object value) {
        try {
            if (this.setter != null && this.setter.isAccessible()) {
                this.setter.invoke(entity, value);
            } else {
                this.field.set(entity, value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to write property '" + this.propertyName + "' in " + entity.getClass(), e);
        }
    }

    boolean hasAnnotation(Class<? extends Annotation> annotationClass) {
        return this.annotations.containsKey(annotationClass);
    }

    Collection<Annotation> getAnnotations() {
        return this.annotations.values();
    }

    <A extends Annotation> A annotation(Class<A> annotationClass) {
        return (A)this.annotations.get(annotationClass);
    }

    boolean isComputed() {
        return this.hasAnnotation(Computed.class);
    }

    boolean isTransient() {
        return this.hasAnnotation(Transient.class);
    }

    boolean isPartitionKey() {
        return this.hasAnnotation(PartitionKey.class);
    }

    boolean isClusteringColumn() {
        return this.hasAnnotation(ClusteringColumn.class);
    }

    private String inferColumnName() {
        if (this.isComputed()) {
            return this.annotation(Computed.class).value();
        }
        boolean caseSensitive = false;
        String columnName = this.propertyName;
        if (this.hasAnnotation(Column.class)) {
            Column column = this.annotation(Column.class);
            caseSensitive = column.caseSensitive();
            if (!column.name().isEmpty()) {
                columnName = column.name();
            }
        } else if (this.hasAnnotation(Field.class)) {
            Field udtField = this.annotation(Field.class);
            caseSensitive = udtField.caseSensitive();
            if (!udtField.name().isEmpty()) {
                columnName = udtField.name();
            }
        }
        return caseSensitive ? Metadata.quote(columnName) : columnName.toLowerCase();
    }

    private TypeToken<Object> inferJavaType() {
        Type type = this.getter != null ? this.getter.getGenericReturnType() : this.field.getGenericType();
        return TypeToken.of(type);
    }

    private int inferPosition() {
        if (this.isPartitionKey()) {
            return this.annotation(PartitionKey.class).value();
        }
        if (this.isClusteringColumn()) {
            return this.annotation(ClusteringColumn.class).value();
        }
        return -1;
    }

    private TypeCodec<Object> createCustomCodec() {
        Class<TypeCodec<?>> codecClass = this.getCustomCodecClass();
        if (codecClass.equals(Defaults.NoCodec.class)) {
            return null;
        }
        TypeCodec<Object> instance = ReflectionUtils.newInstance(codecClass);
        return instance;
    }

    private Class<? extends TypeCodec<?>> getCustomCodecClass() {
        Column column = this.annotation(Column.class);
        if (column != null) {
            return column.codec();
        }
        Field udtField = this.annotation(Field.class);
        if (udtField != null) {
            return udtField.codec();
        }
        return Defaults.NoCodec.class;
    }

    public String toString() {
        return this.propertyName;
    }
}

