/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.querybuilder.Assignment;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Truncate;
import com.datastax.driver.core.querybuilder.Update;
import com.datastax.driver.core.querybuilder.Using;
import com.datastax.driver.core.querybuilder.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class QueryBuilder {
    private QueryBuilder() {
    }

    public static Select.Builder select(String ... columns) {
        return new Select.Builder(Arrays.asList((Object[])columns));
    }

    public static Select.Selection select() {
        return new Select.SelectionOrAlias();
    }

    public static Insert insertInto(String table) {
        return new Insert(null, table);
    }

    public static Insert insertInto(String keyspace, String table) {
        return new Insert(keyspace, table);
    }

    public static Insert insertInto(TableMetadata table) {
        return new Insert(table);
    }

    public static Update update(String table) {
        return new Update(null, table);
    }

    public static Update update(String keyspace, String table) {
        return new Update(keyspace, table);
    }

    public static Update update(TableMetadata table) {
        return new Update(table);
    }

    public static Delete.Builder delete(String ... columns) {
        return new Delete.Builder(columns);
    }

    public static Delete.Selection delete() {
        return new Delete.Selection();
    }

    public static Batch batch(RegularStatement ... statements) {
        return new Batch(statements, true);
    }

    public static Batch unloggedBatch(RegularStatement ... statements) {
        return new Batch(statements, false);
    }

    public static Truncate truncate(String table) {
        return new Truncate(null, table);
    }

    public static Truncate truncate(String keyspace, String table) {
        return new Truncate(keyspace, table);
    }

    public static Truncate truncate(TableMetadata table) {
        return new Truncate(table);
    }

    public static String quote(String columnName) {
        return Metadata.quote(columnName);
    }

    public static String token(String columnName) {
        StringBuilder sb = new StringBuilder();
        sb.append("token(");
        Utils.appendName(columnName, sb);
        sb.append(')');
        return sb.toString();
    }

    public static String token(String ... columnNames) {
        StringBuilder sb = new StringBuilder();
        sb.append("token(");
        Utils.joinAndAppendNames(sb, null, ",", Arrays.asList((Object[])columnNames));
        sb.append(')');
        return sb.toString();
    }

    public static Clause eq(String name, Object value) {
        return new Clause.SimpleClause(name, "=", value);
    }

    public static Clause eq(List<String> names, List<?> values) {
        if (names.size() != values.size()) {
            throw new IllegalArgumentException(String.format("The number of names (%d) and values (%d) don't match", names.size(), values.size()));
        }
        return new Clause.CompoundClause(names, "=", values);
    }

    public static Clause like(String name, Object value) {
        return new Clause.SimpleClause(name, " LIKE ", value);
    }

    public static Clause in(String name, Object ... values) {
        return new Clause.InClause(name, Arrays.asList(values));
    }

    public static Clause in(String name, List<?> values) {
        return new Clause.InClause(name, values);
    }

    public static Clause in(List<String> names, List<?> values) {
        return new Clause.CompoundInClause(names, values);
    }

    public static Clause contains(String name, Object value) {
        return new Clause.ContainsClause(name, value);
    }

    public static Clause containsKey(String name, Object key) {
        return new Clause.ContainsKeyClause(name, key);
    }

    public static Clause lt(String name, Object value) {
        return new Clause.SimpleClause(name, "<", value);
    }

    public static Clause lt(List<String> names, List<?> values) {
        if (names.size() != values.size()) {
            throw new IllegalArgumentException(String.format("The number of names (%d) and values (%d) don't match", names.size(), values.size()));
        }
        return new Clause.CompoundClause(names, "<", values);
    }

    public static Clause lte(String name, Object value) {
        return new Clause.SimpleClause(name, "<=", value);
    }

    public static Clause lte(List<String> names, List<?> values) {
        if (names.size() != values.size()) {
            throw new IllegalArgumentException(String.format("The number of names (%d) and values (%d) don't match", names.size(), values.size()));
        }
        return new Clause.CompoundClause(names, "<=", values);
    }

    public static Clause gt(String name, Object value) {
        return new Clause.SimpleClause(name, ">", value);
    }

    public static Clause gt(List<String> names, List<?> values) {
        if (names.size() != values.size()) {
            throw new IllegalArgumentException(String.format("The number of names (%d) and values (%d) don't match", names.size(), values.size()));
        }
        return new Clause.CompoundClause(names, ">", values);
    }

    public static Clause gte(String name, Object value) {
        return new Clause.SimpleClause(name, ">=", value);
    }

    public static Clause gte(List<String> names, List<?> values) {
        if (names.size() != values.size()) {
            throw new IllegalArgumentException(String.format("The number of names (%d) and values (%d) don't match", names.size(), values.size()));
        }
        return new Clause.CompoundClause(names, ">=", values);
    }

    public static Ordering asc(String columnName) {
        return new Ordering(columnName, false);
    }

    public static Ordering desc(String columnName) {
        return new Ordering(columnName, true);
    }

    public static Using timestamp(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Invalid timestamp, must be positive");
        }
        return new Using.WithValue("TIMESTAMP", timestamp);
    }

    public static Using timestamp(BindMarker marker) {
        return new Using.WithMarker("TIMESTAMP", marker);
    }

    public static Using ttl(int ttl) {
        if (ttl < 0) {
            throw new IllegalArgumentException("Invalid ttl, must be positive");
        }
        return new Using.WithValue("TTL", ttl);
    }

    public static Using ttl(BindMarker marker) {
        return new Using.WithMarker("TTL", marker);
    }

    public static Assignment set(String name, Object value) {
        return new Assignment.SetAssignment(name, value);
    }

    public static Assignment incr(String name) {
        return QueryBuilder.incr(name, 1L);
    }

    public static Assignment incr(String name, long value) {
        return new Assignment.CounterAssignment(name, value, true);
    }

    public static Assignment incr(String name, BindMarker value) {
        return new Assignment.CounterAssignment(name, value, true);
    }

    public static Assignment decr(String name) {
        return QueryBuilder.decr(name, 1L);
    }

    public static Assignment decr(String name, long value) {
        return new Assignment.CounterAssignment(name, value, false);
    }

    public static Assignment decr(String name, BindMarker value) {
        return new Assignment.CounterAssignment(name, value, false);
    }

    public static Assignment prepend(String name, Object value) {
        if (value instanceof BindMarker) {
            throw new InvalidQueryException("binding a value in prepend() is not supported, use prependAll() and bind a singleton list");
        }
        return QueryBuilder.prependAll(name, Collections.singletonList(value));
    }

    public static Assignment prependAll(String name, List<?> list) {
        return new Assignment.ListPrependAssignment(name, list);
    }

    public static Assignment prependAll(String name, BindMarker list) {
        return new Assignment.ListPrependAssignment(name, list);
    }

    public static Assignment append(String name, Object value) {
        if (value instanceof BindMarker) {
            throw new InvalidQueryException("Binding a value in append() is not supported, use appendAll() and bind a singleton list");
        }
        return QueryBuilder.appendAll(name, Collections.singletonList(value));
    }

    public static Assignment appendAll(String name, List<?> list) {
        return new Assignment.CollectionAssignment(name, list, true, false);
    }

    public static Assignment appendAll(String name, BindMarker list) {
        return new Assignment.CollectionAssignment(name, list, true, false);
    }

    public static Assignment discard(String name, Object value) {
        if (value instanceof BindMarker) {
            throw new InvalidQueryException("Binding a value in discard() is not supported, use discardAll() and bind a singleton list");
        }
        return QueryBuilder.discardAll(name, Collections.singletonList(value));
    }

    public static Assignment discardAll(String name, List<?> list) {
        return new Assignment.CollectionAssignment(name, list, false);
    }

    public static Assignment discardAll(String name, BindMarker list) {
        return new Assignment.CollectionAssignment(name, list, false);
    }

    public static Assignment setIdx(String name, int idx, Object value) {
        return new Assignment.ListSetIdxAssignment(name, idx, value);
    }

    public static Assignment add(String name, Object value) {
        if (value instanceof BindMarker) {
            throw new InvalidQueryException("Binding a value in add() is not supported, use addAll() and bind a singleton list");
        }
        return QueryBuilder.addAll(name, Collections.singleton(value));
    }

    public static Assignment addAll(String name, Set<?> set) {
        return new Assignment.CollectionAssignment(name, set, true);
    }

    public static Assignment addAll(String name, BindMarker set) {
        return new Assignment.CollectionAssignment(name, set, true);
    }

    public static Assignment remove(String name, Object value) {
        if (value instanceof BindMarker) {
            throw new InvalidQueryException("Binding a value in remove() is not supported, use removeAll() and bind a singleton set");
        }
        return QueryBuilder.removeAll(name, Collections.singleton(value));
    }

    public static Assignment removeAll(String name, Set<?> set) {
        return new Assignment.CollectionAssignment(name, set, false);
    }

    public static Assignment removeAll(String name, BindMarker set) {
        return new Assignment.CollectionAssignment(name, set, false);
    }

    public static Assignment put(String name, Object key, Object value) {
        return new Assignment.MapPutAssignment(name, key, value);
    }

    public static Assignment putAll(String name, Map<?, ?> map) {
        return new Assignment.CollectionAssignment(name, map, true);
    }

    public static Assignment putAll(String name, BindMarker map) {
        return new Assignment.CollectionAssignment(name, map, true);
    }

    public static BindMarker bindMarker() {
        return BindMarker.ANONYMOUS;
    }

    public static BindMarker bindMarker(String name) {
        return new BindMarker(name);
    }

    public static Object raw(String str) {
        return new Utils.RawString(str);
    }

    public static Object fcall(String name, Object ... parameters) {
        return new Utils.FCall(name, parameters);
    }

    public static Object cast(Object column, DataType dataType) {
        return new Utils.Cast(column, dataType);
    }

    public static Object now() {
        return new Utils.FCall("now", new Object[0]);
    }

    public static Object uuid() {
        return new Utils.FCall("uuid", new Object[0]);
    }

    public static Object column(String name) {
        return new Utils.CName(name);
    }

    public static Object fromJson(Object json) {
        return QueryBuilder.fcall("fromJson", json);
    }
}

