/*
 * Decompiled with CFR 0.152.
 */
package com.d0x7.utils.redis;

import com.d0x7.utils.config.ConfigUtils;
import com.d0x7.utils.database.Database;
import com.d0x7.utils.redis.RedisConfiguration;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class Redis {
    private static JedisPool jedisPool;
    private static boolean initialized;

    public static ListenableFuture<Boolean> setup() {
        if (ConfigUtils.get(RedisConfiguration.class) == null) {
            try {
                ConfigUtils.loadConfigurationFile(new File(System.getProperty("user.home"), "redis.database.json"), RedisConfiguration.class);
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return Futures.immediateFailedFuture(e);
            }
        }
        return Redis.setup(ConfigUtils.get(RedisConfiguration.class));
    }

    public static ListenableFuture<Boolean> setup(RedisConfiguration redisConfiguration) {
        if (initialized) {
            return Futures.immediateFuture(true);
        }
        initialized = true;
        return Database.getExecutorService().submit(() -> {
            JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
            jedisPoolConfig.setJmxEnabled(false);
            jedisPoolConfig.setMaxTotal(8);
            jedisPool = redisConfiguration.getPassword() != null && !redisConfiguration.getPassword().isEmpty() ? new JedisPool(jedisPoolConfig, redisConfiguration.getHostname(), redisConfiguration.getPort(), 1800, redisConfiguration.getPassword()) : new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, redisConfiguration.getHostname(), redisConfiguration.getPort(), 1800);
            try (Jedis jedis = jedisPool.getResource();){
                Boolean bl = jedis.ping().equals("PONG");
                return bl;
            }
        });
    }

    public static Jedis get() {
        return jedisPool.getResource();
    }

    public static void shutdown() {
        jedisPool.close();
    }

    public static boolean isConnected() {
        return !jedisPool.isClosed();
    }

    public static JedisPool getJedisPool() {
        return jedisPool;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    static {
        initialized = false;
    }
}

