/*
 * Decompiled with CFR 0.152.
 */
package com.d0x7.utils.prompt;

import com.d0x7.utils.prompt.PropertyType;
import com.d0x7.utils.prompt.ValidationOption;
import com.d0x7.utils.prompt.Validator;
import java.util.ArrayList;
import java.util.List;

public class Property {
    private String name;
    private PropertyType type;
    private List<ValidationOption> validationOptions;
    private Validator<Object> validator;
    private boolean required;
    private boolean hidden;
    private Character hidePattern = Character.valueOf('*');
    private Object defaultValue;
    private int maxTry = 5;

    public static Property build() {
        return new Property();
    }

    public Property name(String name) {
        this.name = name;
        return this;
    }

    public Property type(PropertyType propertyType) {
        this.type = propertyType;
        return this;
    }

    public Property validationOption(ValidationOption validationOption) {
        if (this.validationOptions == null) {
            this.validationOptions = new ArrayList<ValidationOption>();
        }
        this.validationOptions.add(validationOption);
        return this;
    }

    public Property validator(Validator<Object> validator) {
        this.validator = validator;
        return this;
    }

    public Property required(boolean isRequired) {
        this.required = isRequired;
        return this;
    }

    public Property require() {
        this.required = true;
        return this;
    }

    public Property hidden(boolean isHidden) {
        this.hidden = isHidden;
        return this;
    }

    public Property hide() {
        this.hidden = true;
        return this;
    }

    public Property hidePattern(Character hidePattern) {
        this.hidePattern = hidePattern;
        return this;
    }

    public Property defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Property maxTry(int maxTry) {
        this.maxTry = maxTry;
        return this;
    }

    private Property() {
    }

    public String getName() {
        return this.name;
    }

    public PropertyType getType() {
        return this.type;
    }

    public List<ValidationOption> getValidationOptions() {
        return this.validationOptions;
    }

    public Validator<Object> getValidator() {
        return this.validator;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Character getHidePattern() {
        return this.hidePattern;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public int getMaxTry() {
        return this.maxTry;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(PropertyType type) {
        this.type = type;
    }

    public void setValidationOptions(List<ValidationOption> validationOptions) {
        this.validationOptions = validationOptions;
    }

    public void setValidator(Validator<Object> validator) {
        this.validator = validator;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setHidePattern(Character hidePattern) {
        this.hidePattern = hidePattern;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setMaxTry(int maxTry) {
        this.maxTry = maxTry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Property)) {
            return false;
        }
        Property other = (Property)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        PropertyType this$type = this.getType();
        PropertyType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<ValidationOption> this$validationOptions = this.getValidationOptions();
        List<ValidationOption> other$validationOptions = other.getValidationOptions();
        if (this$validationOptions == null ? other$validationOptions != null : !((Object)this$validationOptions).equals(other$validationOptions)) {
            return false;
        }
        Validator<Object> this$validator = this.getValidator();
        Validator<Object> other$validator = other.getValidator();
        if (this$validator == null ? other$validator != null : !this$validator.equals(other$validator)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        Character this$hidePattern = this.getHidePattern();
        Character other$hidePattern = other.getHidePattern();
        if (this$hidePattern == null ? other$hidePattern != null : !((Object)this$hidePattern).equals(other$hidePattern)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        return this.getMaxTry() == other.getMaxTry();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Property;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        PropertyType $type = this.getType();
        result = result * 59 + ($type == null ? 0 : ((Object)((Object)$type)).hashCode());
        List<ValidationOption> $validationOptions = this.getValidationOptions();
        result = result * 59 + ($validationOptions == null ? 0 : ((Object)$validationOptions).hashCode());
        Validator<Object> $validator = this.getValidator();
        result = result * 59 + ($validator == null ? 0 : $validator.hashCode());
        result = result * 59 + (this.isRequired() ? 79 : 97);
        result = result * 59 + (this.isHidden() ? 79 : 97);
        Character $hidePattern = this.getHidePattern();
        result = result * 59 + ($hidePattern == null ? 0 : ((Object)$hidePattern).hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 0 : $defaultValue.hashCode());
        result = result * 59 + this.getMaxTry();
        return result;
    }

    public String toString() {
        return "Property(name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", validationOptions=" + this.getValidationOptions() + ", validator=" + this.getValidator() + ", required=" + this.isRequired() + ", hidden=" + this.isHidden() + ", hidePattern=" + this.getHidePattern() + ", defaultValue=" + this.getDefaultValue() + ", maxTry=" + this.getMaxTry() + ")";
    }
}

