/*
 * Decompiled with CFR 0.152.
 */
package com.d0x7.utils.prompt;

import com.d0x7.utils.prompt.Property;
import com.d0x7.utils.prompt.ValidationException;
import com.d0x7.utils.prompt.ValidationOption;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class Prompt {
    private static Terminal terminal;
    private static LineReader lineReader;

    private static void setup() {
        if (terminal == null) {
            try {
                terminal = TerminalBuilder.builder().build();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("Failed to setup Prompt: " + e.getMessage());
            }
        }
        if (lineReader == null) {
            lineReader = LineReaderBuilder.builder().terminal(terminal).build();
        }
    }

    public static Object get(Property property) {
        if (!Prompt.validateProperty(property)) {
            return null;
        }
        Prompt.setup();
        while (true) {
            try {
                Object object;
                String line = property.isHidden() ? lineReader.readLine(String.format("Enter %s%s: ", property.getName(), property.getDefaultValue() == null ? "" : " (Default: " + property.getDefaultValue() + ")"), property.getHidePattern()) : lineReader.readLine(String.format("Enter %s%s: ", property.getName(), property.getDefaultValue() == null ? "" : " (Default: " + property.getDefaultValue() + ")"));
                if (line == null) {
                    new ValidationException("Invalid Input, try again.");
                }
                if (line.isEmpty()) {
                    if (property.getDefaultValue() != null) {
                        return property.getDefaultValue();
                    }
                    new ValidationException("Invalid Input, try again.");
                }
                if ((object = Prompt.processInput(property, line)) == null) {
                    new ValidationException("Internal Validation Error, try again.");
                }
                if (property.getValidator() != null) {
                    property.getValidator().validate(object);
                }
                return object;
            }
            catch (ValidationException e) {
                System.out.println(e.getMessage());
                property.maxTry(property.getMaxTry() - 1);
                if (property.getMaxTry() > 0 || property.isRequired()) continue;
                return null;
            }
            break;
        }
    }

    private static boolean validateProperty(Property property) {
        if (property.getName() == null || property.getName().isEmpty() || property.getType() == null) {
            return false;
        }
        return !property.isHidden() || property.getHidePattern() != null;
    }

    private static Object processInput(Property property, String input) throws ValidationException {
        switch (property.getType()) {
            case STRING: {
                return input;
            }
            case BOOLEAN: {
                if (input.toLowerCase().equalsIgnoreCase("true") || input.toLowerCase().equalsIgnoreCase("yes") || input.toLowerCase().equalsIgnoreCase("y")) {
                    return true;
                }
                if (input.toLowerCase().equalsIgnoreCase("false") || input.toLowerCase().equalsIgnoreCase("no") || input.toLowerCase().equalsIgnoreCase("n")) {
                    return false;
                }
                throw new ValidationException("Invalid Input for boolean value (try yes/no/true/false/y/n), try again.");
            }
            case FILE: {
                File file = new File(input);
                if (property.getValidationOptions() != null) {
                    if (property.getValidationOptions().contains((Object)ValidationOption.FILE_EXISTS) && !file.exists()) {
                        throw new ValidationException("File needs to exist already, try again.");
                    }
                    if (property.getValidationOptions().contains((Object)ValidationOption.FILE_IS_DIRECTORY) && !file.isDirectory()) {
                        throw new ValidationException("File needs to be an directory, try again.");
                    }
                    if (property.getValidationOptions().contains((Object)ValidationOption.FILE_IS_FILE) && !file.isFile()) {
                        throw new ValidationException("File needs to be an file, try again.");
                    }
                    if (property.getValidationOptions().contains((Object)ValidationOption.FILE_NOT_EXISTS) && file.exists()) {
                        throw new ValidationException("File must not exist already, try again.");
                    }
                }
                return file;
            }
            case FLOAT: {
                try {
                    return Float.valueOf(Float.parseFloat(input));
                }
                catch (NumberFormatException e) {
                    throw new ValidationException("Input must be a long, try again.");
                }
            }
            case INTEGER: {
                try {
                    return Integer.parseInt(input);
                }
                catch (NumberFormatException e) {
                    throw new ValidationException("Input must be a integer, try again.");
                }
            }
            case DOUBLE: {
                try {
                    return Double.parseDouble(input);
                }
                catch (NumberFormatException e) {
                    throw new ValidationException("Input must be a double, try again.");
                }
            }
            case SHORT: {
                try {
                    return Short.parseShort(input);
                }
                catch (NumberFormatException e) {
                    throw new ValidationException("Input must be a short, try again.");
                }
            }
            case BYTE: {
                try {
                    return Byte.parseByte(input);
                }
                catch (NumberFormatException e) {
                    throw new ValidationException("Input must be a byte, try again.");
                }
            }
            case LONG: {
                try {
                    return Long.parseLong(input);
                }
                catch (NumberFormatException e) {
                    throw new ValidationException("Input must be a long, try again.");
                }
            }
            case CHAR: {
                if (input.length() != 1) {
                    throw new ValidationException("Input is too long for a single character, try again.");
                }
                return Character.valueOf(input.charAt(0));
            }
            case NUMBER: {
                try {
                    return NumberFormat.getInstance().parse(input);
                }
                catch (NumberFormatException | ParseException e) {
                    throw new ValidationException("Input must be a number, try again.");
                }
            }
        }
        throw new ValidationException("PropertyType not implemented yet");
    }
}

