package com.d0x7.utils.examples.config;

import com.d0x7.utils.config.ConfigUtils;

import java.io.File;

/**
 * Copyright (c) 2015-2017 d0x7.com
 * <p>
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * <p>
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * <p>
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
public class ConfigExample {

    public static void main(String[] args) throws Exception {
        // Create and load the config
        SimpleConfig simpleConfig = ConfigUtils.loadConfigurationFile(new File("simpleconfig.json"), SimpleConfig.class);

        // Access a field from the config
        System.out.println("aValue is " + simpleConfig.getAValue());

        // If the config is a singleton config (which is true by default), you can retrieve the config at any point using
        ConfigUtils.get(SimpleConfig.class);


        // Let's get a bit advanced. We want a config which is not a singleton and which needs to execute some things after loading
        AdvancedConfig advancedConfig = ConfigUtils.loadConfigurationFile(new File("advancedconfig.json"), AdvancedConfig.class);

        // Access a field as usual
        System.out.println(advancedConfig.getAnotherValue());

        // This won't work here (or returns null) because the config isn't a singleton config (specified in the #postProcess method)
        ConfigUtils.get(AdvancedConfig.class);
    }
}
