/*
 * Decompiled with CFR 0.152.
 */
package com.d_codepages.sarathkumar.vectray;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.d_codepages.sarathkumar.vectray.Icon;

public class IconDrawable
extends Drawable {
    public static final int ANDROID_ACTIONBAR_ICON_SIZE_DP = 24;
    private Context context;
    private Icon icon;
    private TextPaint paint;
    private int size = -1;
    private int alpha = 255;

    public IconDrawable(Context context, Icon icon) {
        this.init(context, icon);
    }

    private void init(Context context, Icon icon) {
        this.context = context;
        this.icon = icon;
        this.paint = new TextPaint();
        this.paint.setTypeface(icon.getTypeface());
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setTextAlign(Paint.Align.CENTER);
        this.paint.setUnderlineText(false);
        this.paint.setColor(-16777216);
        this.paint.setAntiAlias(true);
    }

    public IconDrawable actionBarSize() {
        return this.sizeDp(24);
    }

    public IconDrawable sizeRes(int dimenRes) {
        return this.sizePx(this.context.getResources().getDimensionPixelSize(dimenRes));
    }

    public IconDrawable sizeDp(int size) {
        return this.sizePx(this.convertDpToPx(this.context, size));
    }

    public IconDrawable sizePx(int size) {
        this.size = size;
        this.setBounds(0, 0, size, size);
        this.invalidateSelf();
        return this;
    }

    public IconDrawable color(int color) {
        this.paint.setColor(color);
        this.invalidateSelf();
        return this;
    }

    public IconDrawable setShadow(float radius, float dx, float dy, int color) {
        this.paint.setShadowLayer(radius, dx, dy, color);
        this.invalidateSelf();
        return this;
    }

    public IconDrawable setShader(Shader shader) {
        this.paint.setShader(shader);
        this.invalidateSelf();
        return this;
    }

    public IconDrawable colorRes(int colorRes) {
        this.paint.setColor(this.context.getResources().getColor(colorRes));
        this.invalidateSelf();
        return this;
    }

    public IconDrawable alpha(int alpha) {
        this.setAlpha(alpha);
        this.invalidateSelf();
        return this;
    }

    public int getIntrinsicHeight() {
        return this.size;
    }

    public int getIntrinsicWidth() {
        return this.size;
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        int height = bounds.height();
        this.paint.setTextSize((float)height);
        Rect textBounds = new Rect();
        String textValue = String.valueOf(this.icon.getString());
        this.paint.getTextBounds(textValue, 0, 1, textBounds);
        int textHeight = textBounds.height();
        float textBottom = (float)bounds.top + (float)(height - textHeight) / 2.0f + (float)textHeight - (float)textBounds.bottom;
        canvas.drawText(textValue, bounds.exactCenterX(), textBottom, (Paint)this.paint);
    }

    public boolean isStateful() {
        return true;
    }

    public boolean setState(int[] stateSet) {
        int oldValue = this.paint.getAlpha();
        int newValue = this.isEnabled(stateSet) ? this.alpha : this.alpha / 2;
        this.paint.setAlpha(newValue);
        return oldValue != newValue;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.paint.setColorFilter(cf);
    }

    public void clearColorFilter() {
        this.paint.setColorFilter(null);
    }

    public int getOpacity() {
        return this.alpha;
    }

    public void setStyle(Paint.Style style) {
        this.paint.setStyle(style);
    }

    private boolean isEnabled(int[] stateSet) {
        for (int state : stateSet) {
            if (state != 16842910) continue;
            return true;
        }
        return false;
    }

    private int convertDpToPx(Context context, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

