/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.ConfigException;
import com.cybersource.ws.client.Identity;
import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.MerchantConfig;
import com.cybersource.ws.client.MessageHandlerKeyStore;
import com.cybersource.ws.client.SignEncryptException;
import com.cybersource.ws.client.SignException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.KeyGenerator;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.xml.security.Init;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.w3c.dom.Document;

public class SecurityUtil {
    private static final String KEY_FILE_TYPE = "PKCS12";
    private static final String FAILED_TO_LOAD_KEY_STORE = "Exception while loading KeyStore";
    private static final String FAILED_TO_OBTAIN_PRIVATE_KEY = "Exception while obtaining private key from KeyStore with alias";
    private static MessageHandlerKeyStore localKeyStoreHandler = null;
    private static ConcurrentHashMap<String, Identity> identities = new ConcurrentHashMap();
    private static final String SIGNATURE_ALGORITHM = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    private static final String DIGEST_ALGORITHM = "http://www.w3.org/2001/04/xmlenc#sha256";
    private static BouncyCastleProvider bcProvider = new BouncyCastleProvider();

    private static void initKeystore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(null, null);
        localKeyStoreHandler = new MessageHandlerKeyStore();
        localKeyStoreHandler.setKeyStore(keyStore);
    }

    public static void loadMerchantP12File(MerchantConfig merchantConfig, Logger logger) throws SignException, SignEncryptException, ConfigException {
        Identity identity = identities.get(merchantConfig.getKeyAlias());
        if (!merchantConfig.isCertificateCacheEnabled() || identity == null || !identity.isValid(merchantConfig.getKeyFile(), logger)) {
            try {
                if (localKeyStoreHandler == null) {
                    SecurityUtil.initKeystore();
                }
            }
            catch (Exception e) {
                logger.log("EXCEPTION", "SecurityUtil, cannot instantiate class with keystore error. " + e.getMessage());
                throw new SignException(e.getMessage(), e);
            }
            if (merchantConfig.isJdkCertEnabled()) {
                logger.log("INFO     ", " Loading the certificate from JDK Cert");
                SecurityUtil.readJdkCert(merchantConfig, logger);
            } else if (merchantConfig.isCacertEnabled()) {
                logger.log("INFO     ", " Loading the certificate from JRE security cacert file");
                SecurityUtil.loadJavaKeystore(merchantConfig, logger);
            } else {
                logger.log("INFO     ", "Loading the certificate from p12 file ");
                SecurityUtil.readAndStoreCertificateAndPrivateKey(merchantConfig, logger);
            }
        }
    }

    private static void readAndStoreCertificateAndPrivateKey(MerchantConfig merchantConfig, Logger logger) throws SignException, SignEncryptException {
        KeyStore merchantKeyStore;
        try {
            merchantKeyStore = KeyStore.getInstance(KEY_FILE_TYPE, (Provider)bcProvider);
        }
        catch (KeyStoreException e) {
            logger.log("EXCEPTION", "Exception while instantiating KeyStore");
            throw new SignException("Exception while instantiating KeyStore", e);
        }
        try {
            merchantKeyStore.load(new FileInputStream(merchantConfig.getKeyFile()), merchantConfig.getKeyPassword().toCharArray());
        }
        catch (IOException e) {
            logger.log("EXCEPTION", "Exception while loading KeyStore, '" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(FAILED_TO_LOAD_KEY_STORE, e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.log("EXCEPTION", "Exception while loading KeyStore, '" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(FAILED_TO_LOAD_KEY_STORE, e);
        }
        catch (CertificateException e) {
            logger.log("EXCEPTION", "Exception while loading KeyStore, '" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(FAILED_TO_LOAD_KEY_STORE, e);
        }
        catch (ConfigException e) {
            logger.log("EXCEPTION", "Exception while loading KeyStore, '" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(FAILED_TO_LOAD_KEY_STORE, e);
        }
        try {
            Enumeration<String> enumKeyStore = merchantKeyStore.aliases();
            while (enumKeyStore.hasMoreElements()) {
                Identity identity;
                KeyStore.PrivateKeyEntry keyEntry = null;
                String merchantKeyAlias = enumKeyStore.nextElement();
                if (merchantKeyAlias.contains(merchantConfig.getKeyAlias())) {
                    try {
                        keyEntry = (KeyStore.PrivateKeyEntry)merchantKeyStore.getEntry(merchantKeyAlias, new KeyStore.PasswordProtection(merchantConfig.getKeyPassword().toCharArray()));
                    }
                    catch (NoSuchAlgorithmException e) {
                        logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                        throw new SignException(FAILED_TO_OBTAIN_PRIVATE_KEY, e);
                    }
                    catch (UnrecoverableEntryException e) {
                        logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                        throw new SignException(FAILED_TO_OBTAIN_PRIVATE_KEY, e);
                    }
                    catch (KeyStoreException e) {
                        logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                        throw new SignException(FAILED_TO_OBTAIN_PRIVATE_KEY, e);
                    }
                    identity = new Identity(merchantConfig, (X509Certificate)keyEntry.getCertificate(), keyEntry.getPrivateKey(), logger);
                    localKeyStoreHandler.addIdentityToKeyStore(identity, logger);
                    identities.put(identity.getKeyAlias(), identity);
                    continue;
                }
                identity = new Identity(merchantConfig, (X509Certificate)merchantKeyStore.getCertificate(merchantKeyAlias));
                localKeyStoreHandler.addIdentityToKeyStore(identity, logger);
                identities.put(identity.getName(), identity);
            }
        }
        catch (KeyStoreException e) {
            logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
            throw new SignException(FAILED_TO_OBTAIN_PRIVATE_KEY, e);
        }
    }

    public static Document handleMessageCreation(Document signedDoc, String merchantId, Logger logger) throws SignEncryptException, SignException {
        Document signedEncryptedDoc;
        logger.log("INFO     ", "Encrypting Signed doc ...");
        WSSecHeader secHeader = new WSSecHeader(signedDoc);
        try {
            secHeader.insertSecurityHeader();
        }
        catch (WSSecurityException e) {
            logger.log("EXCEPTION", "Exception while adding document in soap securiy header for MLE");
            throw new SignException((Exception)((Object)e));
        }
        WSSecEncrypt encrBuilder = new WSSecEncrypt(secHeader);
        String serverAlias = SecurityUtil.getServerAlias(identities);
        encrBuilder.setUserInfo(identities.get(serverAlias).getKeyAlias());
        encrBuilder.setKeyIdentifierType(3);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        try {
            KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            signedEncryptedDoc = encrBuilder.build((Crypto)localKeyStoreHandler, keyGen.generateKey());
        }
        catch (WSSecurityException e) {
            logger.log("EXCEPTION", "Failed while encrypting signed request for , '" + merchantId + "' with " + serverAlias);
            throw new SignEncryptException("Failed while encrypting signed request for , '" + merchantId + "' with " + serverAlias, e);
        }
        encrBuilder.prependToHeader();
        return signedEncryptedDoc;
    }

    public static Document createSignedDoc(Document workingDocument, String keyAlias, String password, Logger logger) throws SignException {
        logger.log("INFO     ", "Signing request...");
        WSSecHeader secHeader = new WSSecHeader(workingDocument);
        try {
            secHeader.insertSecurityHeader();
        }
        catch (WSSecurityException e) {
            logger.log("EXCEPTION", "Exception while signing XML document");
            throw new SignException((Exception)((Object)e));
        }
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo(keyAlias, password);
        sign.setDigestAlgo(DIGEST_ALGORITHM);
        sign.setSignatureAlgorithm(SIGNATURE_ALGORITHM);
        sign.setKeyIdentifierType(1);
        sign.setUseSingleCertificate(true);
        sign.setWsDocInfo(new WSDocInfo(workingDocument));
        WSEncryptionPart msgBodyPart = new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", "");
        try {
            sign.addReferencesToSign(Collections.singletonList(msgBodyPart));
            Document document = sign.build((Crypto)localKeyStoreHandler);
            return document;
        }
        catch (WSSecurityException e) {
            logger.log("EXCEPTION", "Failed while signing request for , '" + keyAlias + "'");
            throw new SignException(e.getMessage(), e);
        }
    }

    public static void readJdkCert(MerchantConfig merchantConfig, Logger logger) throws SignEncryptException, SignException {
        KeyStore keystore;
        try {
            FileInputStream is = new FileInputStream(merchantConfig.getKeyFile());
            keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, merchantConfig.getKeyPassword().toCharArray());
        }
        catch (Exception e) {
            logger.log("EXCEPTION", "Failed to load the key , '" + merchantConfig.getKeyAlias() + "'");
            throw new SignException(e);
        }
        try {
            Enumeration<String> enumKeyStore = keystore.aliases();
            if (!enumKeyStore.hasMoreElements()) {
                throw new SignException("Empty Keystore or Missing Certificate ");
            }
            while (enumKeyStore.hasMoreElements()) {
                Identity identity;
                String merchantKeyAlias = enumKeyStore.nextElement();
                if (merchantKeyAlias.contains(merchantConfig.getKeyAlias())) {
                    KeyStore.PrivateKeyEntry keyEntry;
                    try {
                        keyEntry = (KeyStore.PrivateKeyEntry)keystore.getEntry(merchantKeyAlias, new KeyStore.PasswordProtection(merchantConfig.getKeyPassword().toCharArray()));
                    }
                    catch (NoSuchAlgorithmException e) {
                        logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                        throw new SignException(e);
                    }
                    catch (UnrecoverableEntryException e) {
                        logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                        throw new SignException(e);
                    }
                    catch (KeyStoreException e) {
                        logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                        throw new SignException(e);
                    }
                    identity = new Identity(merchantConfig, (X509Certificate)keyEntry.getCertificate(), keyEntry.getPrivateKey(), logger);
                    localKeyStoreHandler.addIdentityToKeyStore(identity, logger);
                    identities.put(identity.getKeyAlias(), identity);
                    continue;
                }
                identity = new Identity(merchantConfig, (X509Certificate)keystore.getCertificate(merchantKeyAlias));
                localKeyStoreHandler.addIdentityToKeyStore(identity, logger);
                identities.put(identity.getName(), identity);
            }
        }
        catch (KeyStoreException e) {
            logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
            throw new SignException(e);
        }
    }

    private static void loadJavaKeystore(MerchantConfig merchantConfig, Logger logger) throws SignException, SignEncryptException, ConfigException {
        FileInputStream is = null;
        try {
            Identity identity;
            PrivateKey key;
            is = new FileInputStream(merchantConfig.getKeyFile());
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, merchantConfig.getCacertPassword().toCharArray());
            Certificate[] cert = keystore.getCertificateChain(merchantConfig.getKeyAlias());
            if (cert == null) {
                throw new SignException("Empty Keystore or Missing Certificate ");
            }
            try {
                key = (PrivateKey)keystore.getKey(merchantConfig.getKeyAlias(), merchantConfig.getKeyAlias().toCharArray());
            }
            catch (UnrecoverableKeyException e) {
                logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                throw new SignException(e);
            }
            for (Certificate certificate : cert) {
                if (merchantConfig.getKeyAlias().equals(keystore.getCertificateAlias(certificate))) {
                    identity = new Identity(merchantConfig, (X509Certificate)certificate, key, logger);
                    localKeyStoreHandler.addIdentityToKeyStore(identity, logger);
                    identities.put(identity.getKeyAlias(), identity);
                    continue;
                }
                identity = new Identity(merchantConfig, (X509Certificate)certificate);
                localKeyStoreHandler.addIdentityToKeyStore(identity, logger);
                identities.put(identity.getName(), identity);
            }
            Certificate serverCert = keystore.getCertificate(SecurityUtil.getServerAlias(identities));
            if (serverCert == null) {
                throw new SignException("Missing Server Certificate ");
            }
            identity = new Identity(merchantConfig, (X509Certificate)serverCert);
            localKeyStoreHandler.addIdentityToKeyStore(identity, logger);
            identities.put(identity.getName(), identity);
        }
        catch (CertificateException e) {
            logger.log("EXCEPTION", "Unable to load the certificate," + merchantConfig.getKeyFilename() + "'");
            throw new SignException(e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.log("EXCEPTION", "Unable to find the certificate with the specified algorithm");
            throw new SignException(e);
        }
        catch (FileNotFoundException e) {
            logger.log("EXCEPTION", "File Not found ");
            throw new SignException(e);
        }
        catch (KeyStoreException e) {
            logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(e);
        }
        catch (IOException e) {
            logger.log("EXCEPTION", "Exception while loading KeyStore, '" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(e);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.log("EXCEPTION", "Exception while closing FileStream, '" + merchantConfig.getKeyFilename() + "'");
                }
            }
        }
    }

    protected static String getServerAlias(Map<String, Identity> identitiesMapper) {
        String serverAlias = "CyberSource_SJC_US";
        if (!identitiesMapper.containsKey(serverAlias)) {
            if (identitiesMapper.containsKey(serverAlias.toLowerCase())) {
                serverAlias = serverAlias.toLowerCase();
            } else if (identitiesMapper.containsKey(serverAlias.toUpperCase())) {
                serverAlias = serverAlias.toUpperCase();
            } else {
                for (String identityKey : identitiesMapper.keySet()) {
                    if (!identityKey.equalsIgnoreCase(serverAlias)) continue;
                    serverAlias = identityKey;
                    break;
                }
            }
        }
        return serverAlias;
    }

    static {
        Security.addProvider((Provider)bcProvider);
        try {
            SecurityUtil.initKeystore();
            Init.init();
        }
        catch (Exception e) {
            localKeyStoreHandler = null;
        }
    }
}

