/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.MerchantConfig;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.bouncycastle.util.encoders.Base64;

public class ConnectionHelper {
    public static boolean getDefaultUseHttpClient() {
        return false;
    }

    public static void setTimeout(HttpURLConnection con, MerchantConfig mc) {
        con.setConnectTimeout(mc.getConnectionTimeoutMs());
        con.setReadTimeout(mc.getSocketTimeoutMs());
    }

    public static HttpURLConnection openConnection(URL url, MerchantConfig mc) throws IOException {
        Proxy proxy = ConnectionHelper.createProxy(mc);
        HttpURLConnection con = (HttpURLConnection)url.openConnection(proxy);
        if (proxy != Proxy.NO_PROXY) {
            ConnectionHelper.addProxyCredentials(con, mc);
        }
        return con;
    }

    private static Proxy createProxy(MerchantConfig mc) {
        if (mc.getProxyHost() == null) {
            return Proxy.NO_PROXY;
        }
        InetSocketAddress addr = new InetSocketAddress(mc.getProxyHost(), mc.getProxyPort());
        return new Proxy(Proxy.Type.HTTP, addr);
    }

    private static void addProxyCredentials(HttpURLConnection con, MerchantConfig mc) {
        if (mc.getProxyUser() != null) {
            con.setRequestProperty("Proxy-Authorization", "Basic " + Base64.encode((byte[])(mc.getProxyUser() + ":" + mc.getProxyPassword()).getBytes(Charset.forName("UTF-8"))));
        }
    }

    public static void setProxy(HttpClientBuilder httpClientBuilder, RequestConfig.Builder requestConfigBuilder, MerchantConfig merchantConfig) {
        if (merchantConfig.getProxyHost() != null) {
            HttpHost proxy = new HttpHost(merchantConfig.getProxyHost(), merchantConfig.getProxyPort());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            if (merchantConfig.getProxyUser() != null) {
                httpClientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
                requestConfigBuilder.setProxyPreferredAuthSchemes(Collections.singletonList("Basic"));
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(merchantConfig.getProxyUser(), merchantConfig.getProxyPassword()));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
    }
}

