/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.ClientException;
import com.cybersource.ws.client.ConfigException;
import com.cybersource.ws.client.Connection;
import com.cybersource.ws.client.FaultException;
import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.LoggerWrapper;
import com.cybersource.ws.client.MerchantConfig;
import com.cybersource.ws.client.SecurityUtil;
import com.cybersource.ws.client.SignEncryptException;
import com.cybersource.ws.client.SignException;
import com.cybersource.ws.client.Utility;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Client {
    private static final String SOAP_ENVELOPE1 = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n<soap:Body id=\"body1\">\n<nvpRequest xmlns=\"{0}\">\n{1}</nvpRequest>\n</soap:Body>\n</soap:Envelope>";
    private static final String ELEM_NVP_REPLY = "nvpReply";
    private static ConcurrentHashMap<String, MerchantConfig> mcObjects = new ConcurrentHashMap();

    public static Map<String, String> runTransaction(Map<String, String> request, Properties props) throws FaultException, ClientException {
        return Client.runTransaction(request, props, null, true, true);
    }

    public static Map<String, String> runTransaction(Map<String, String> request, Properties props, Logger _logger, boolean prepare, boolean logTranStart) throws FaultException, ClientException {
        LoggerWrapper logger = null;
        Connection con = null;
        try {
            String mtiField;
            long startTime = System.currentTimeMillis();
            boolean isMerchantConfigCacheEnabled = Boolean.parseBoolean(props.getProperty("merchantConfigCacheEnabled", "false"));
            MerchantConfig mc = isMerchantConfigCacheEnabled ? Client.getInstanceMap(request, props) : Client.getMerchantConfigObject(request, props);
            Client.setVersionInformation(request);
            logger = new LoggerWrapper(_logger, prepare, logTranStart, mc);
            String isAuthService = request.get("ccAuthService_run");
            if (Boolean.valueOf(isAuthService).booleanValue() && mc.getUseHttpClientWithConnectionPool() && StringUtils.isBlank((CharSequence)(mtiField = request.get("merchantTransactionIdentifier")))) {
                throw new ClientException(400, "merchantTransactionIdentifier field is mandatory if useHttpClientWithConnectionPool is set to true", false, logger);
            }
            DocumentBuilder builder = Utility.newDocumentBuilder();
            Document signedDoc = Client.soapWrapAndSign(request, mc, builder, logger);
            if (mc.isCustomHttpClassEnabled()) {
                try {
                    Class<?> customConnectionClass = Class.forName(mc.getCustomHttpClass());
                    Class[] constructor_Args = new Class[]{MerchantConfig.class, DocumentBuilder.class, LoggerWrapper.class};
                    con = (Connection)customConnectionClass.getDeclaredConstructor(constructor_Args).newInstance(mc, builder, logger);
                }
                catch (InstantiationException e) {
                    logger.log("INFO     ", "Failed to Instantiate the class " + e);
                    throw new ClientException(e, false, null);
                }
                catch (IllegalAccessException e) {
                    logger.log("INFO     ", "Could not Access the method invoked " + e);
                    throw new ClientException(e, false, null);
                }
                catch (ClassNotFoundException e) {
                    logger.log("INFO     ", "Could not load the custom HTTP class ");
                    throw new ClientException(e, false, null);
                }
                catch (IllegalArgumentException e) {
                    logger.log("INFO     ", "Method invoked with Illegal Argument list  " + e);
                    throw new ClientException(e, false, null);
                }
                catch (SecurityException e) {
                    logger.log("INFO     ", "Security Exception " + e);
                    throw new ClientException(e, false, null);
                }
                catch (InvocationTargetException e) {
                    logger.log("INFO     ", "Exception occured while calling the method " + e);
                    throw new ClientException(e, false, null);
                }
                catch (NoSuchMethodException e) {
                    logger.log("INFO     ", "Method not found ");
                    throw new ClientException(e, false, null);
                }
            } else {
                con = Connection.getInstance(mc, builder, logger);
            }
            Document wrappedReply = con.post(signedDoc, startTime);
            HashMap<String, String> replyMap = Client.soapUnwrap(wrappedReply, mc, logger);
            logger.log("INFO     ", "Client, End of runTransaction Call   ", false);
            HashMap<String, String> hashMap = replyMap;
            return hashMap;
        }
        catch (IOException e) {
            throw new ClientException(e, con != null && con.isRequestSent(), logger);
        }
        catch (ParserConfigurationException e) {
            throw new ClientException(e, con != null && con.isRequestSent(), logger);
        }
        catch (SignException e) {
            throw new ClientException(e, con != null && con.isRequestSent(), logger);
        }
        catch (ConfigException e) {
            throw new ClientException(e, con != null && con.isRequestSent(), logger);
        }
        catch (SAXException e) {
            throw new ClientException(e, con != null && con.isRequestSent(), logger);
        }
        catch (SignEncryptException e) {
            throw new ClientException(e, con != null && con.isRequestSent(), logger);
        }
        finally {
            if (con != null) {
                con.release();
            }
        }
    }

    private static void setVersionInformation(Map<String, String> request) {
        request.put("clientLibrary", Utility.NVP_LIBRARY);
        request.put("clientLibraryVersion", "6.2.15");
        request.put("clientEnvironment", Utility.ENVIRONMENT);
    }

    private static Document soapWrapAndSign(Map<String, String> request, MerchantConfig mc, DocumentBuilder builder, LoggerWrapper logger) throws IOException, SignException, SAXException, SignEncryptException, ConfigException {
        boolean logSignedData = mc.getLogSignedData();
        if (!logSignedData) {
            logger.log("REQUEST  ", "UUID   >  " + logger.getUniqueKey() + "\nInput request is\n======================================= \n" + Client.mapToString(request, true, 0));
        }
        Document wrappedDoc = Client.soapWrap(request, mc, builder);
        logger.log("INFO     ", "Client, End of soapWrap   ", true);
        SecurityUtil.loadMerchantP12File(mc, logger);
        logger.log("INFO     ", "Client, End of loading Merchant Certificates ", true);
        Document resultDocument = SecurityUtil.createSignedDoc(wrappedDoc, mc.getKeyAlias(), mc.getKeyPassword(), logger);
        logger.log("INFO     ", "Client, End of createSignedDoc   ", true);
        if (mc.getUseSignAndEncrypted()) {
            resultDocument = SecurityUtil.handleMessageCreation(resultDocument, request.get("merchantID"), logger);
            logger.log("INFO     ", "Client, End of handleMessageCreation   ", true);
        }
        if (logSignedData) {
            logger.log("REQUEST  ", Utility.nodeToString(resultDocument, 0));
        }
        return resultDocument;
    }

    private static Document soapWrap(Map request, MerchantConfig mc, DocumentBuilder builder) throws SAXException, IOException {
        Object[] arguments = new Object[]{mc.getEffectiveNamespaceURI(), Client.mapToString(request, false, 0)};
        String xmlString = MessageFormat.format(SOAP_ENVELOPE1, arguments);
        StringReader sr = new StringReader(xmlString);
        Document wrappedDoc = builder.parse(new InputSource(sr));
        sr.close();
        return wrappedDoc;
    }

    private static HashMap<String, String> soapUnwrap(Document doc, MerchantConfig mc, LoggerWrapper logger) {
        boolean logSignedData = mc.getLogSignedData();
        if (logSignedData) {
            logger.log("REPLY    ", Utility.nodeToString(doc, 1));
        }
        Element nvpReply = Utility.getElement(doc, ELEM_NVP_REPLY, mc.getEffectiveNamespaceURI());
        Text nvpString = (Text)nvpReply.getFirstChild();
        String replyString = nvpString.getNodeValue();
        HashMap<String, String> reply = Utility.stringToMap(replyString);
        if (!logSignedData) {
            logger.log("REPLY    ", Client.mapToString(reply, true, 1));
        }
        return reply;
    }

    static String mapToString(Map src, boolean mask, int type) {
        return Utility.mapToString(src, mask, type);
    }

    private static MerchantConfig getMerchantConfigObject(Map<String, String> request, Properties props) throws ConfigException {
        MerchantConfig mc;
        String merchantID = request.get("merchantID");
        if (merchantID == null) {
            mc = new MerchantConfig(props, null);
            merchantID = mc.getMerchantID();
            request.put("merchantID", merchantID);
        } else {
            mc = new MerchantConfig(props, merchantID);
        }
        return mc;
    }

    private static String getMerchantId(Map<String, String> request, Properties props) {
        String merchantID = request.get("merchantID");
        if (merchantID == null) {
            merchantID = props.getProperty("merchantID");
        }
        return merchantID;
    }

    private static String getKeyForInstanceMap(Map<String, String> request, Properties props) {
        String keyAlias = props.getProperty("keyAlias");
        if (keyAlias != null) {
            return keyAlias;
        }
        return Client.getMerchantId(request, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static MerchantConfig getInstanceMap(Map<String, String> request, Properties props) throws ConfigException {
        String midOrKeyAlias = Client.getKeyForInstanceMap(request, props);
        if (!mcObjects.containsKey(midOrKeyAlias)) {
            Class<Client> clazz = Client.class;
            // MONITORENTER : com.cybersource.ws.client.Client.class
            if (!mcObjects.containsKey(midOrKeyAlias)) {
                mcObjects.put(midOrKeyAlias, Client.getMerchantConfigObject(request, props));
            }
            // MONITOREXIT : clazz
        }
        MerchantConfig mc = mcObjects.get(midOrKeyAlias);
        String merchantID = request.get("merchantID");
        if (!StringUtils.isEmpty((CharSequence)merchantID)) return mc;
        merchantID = mc.getMerchantID();
        request.put("merchantID", merchantID);
        return mc;
    }
}

