/*
 * Decompiled with CFR 0.152.
 */
package utilities.telemetry;

import okhttp3.Request;
import okhttp3.Response;
import utilities.telemetry.ClientTelemetry;
import utilities.telemetry.RequestTransactionMetrics;

public class RequestResponseTelemetryHandler {
    public static void collectResponseTelemetry(RequestTransactionMetrics requestMetrics, Response response, int noOfRetries) {
        String correlationId = response.header("v-c-correlation-id");
        long timeTaken = response.receivedResponseAtMillis() - response.sentRequestAtMillis();
        ClientTelemetry.pushMetricsForRequest(requestMetrics.addHeaderValues(correlationId, timeTaken, noOfRetries));
    }

    public static Request addTelemetryFromPreviousRequest(Request request) {
        RequestTransactionMetrics previousRequestMetrics = ClientTelemetry.getMetricsForPreviousRequest();
        if (previousRequestMetrics != null) {
            Request newRequest = request.newBuilder().addHeader("v-c-client-telemetry", previousRequestMetrics.getTelemetryHeaderValue()).build();
            return newRequest;
        }
        return request;
    }
}

