/*
 * Decompiled with CFR 0.152.
 */
package Model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Retry policy for the individual webhooks that are a part of your subscription. If a message fails to deliver, it will execute through this retry policy.  Automatic suspend and resume:  If you experience downtime and have `deactivateFlag = true` any new messages will be held in a \"SUSPENDED\" status. When your healthCheckUrl returns healthy again, the subscription will automatically be re-enabled and your messages will be sent. We will ping your healthCheckUrl routinely using a POST call with an empty payload to check availability. If your endpoint returns an unhealthy status of != 200, we will check the healthCheckUrl at a more frequent rate until it is healthy again.  If you experience downtime and have `deactivateFlag = false` and your message exhausts all retry attempts the message will go to a \"FAILED\" status. Support will be notified and will reach out to suggest you execute the \"REPLAY\" endpoint at a later date when your server is healthy.   Reference the below values for formulas and calculations related to the frequency of retries depending on algorithm and configuration. ")
public class Notificationsubscriptionsv1webhooksRetryPolicy {
    @SerializedName(value="algorithm")
    private String algorithm = null;
    @SerializedName(value="firstRetry")
    private Integer firstRetry = null;
    @SerializedName(value="interval")
    private Integer interval = null;
    @SerializedName(value="numberOfRetries")
    private Integer numberOfRetries = null;
    @SerializedName(value="deactivateFlag")
    private String deactivateFlag = null;
    @SerializedName(value="repeatSequenceCount")
    private Integer repeatSequenceCount = null;
    @SerializedName(value="repeatSequenceWaitTime")
    private Integer repeatSequenceWaitTime = null;
    @SerializedName(value="additionalAttributes")
    private List<Map<String, String>> additionalAttributes = null;

    public Notificationsubscriptionsv1webhooksRetryPolicy algorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @ApiModelProperty(value="This is used to calculate the Retry Sequence.  Sample calculations using firstRetry=10, interval=30, maxNumberOfRetries=3 Arithmetic = a+r(n-1) Retry 1 - 10 minutes Retry 2 - 10+30x1 = 40 minutes Retry 3 - 10+30x2 = 70 minutes  Geometric = ar^(n-1) Retry 1 - 10 minutes Retry 2 - 10x30^1 = 300 minutes Retry 3 - 10x30^2 = 9,000 minutes ")
    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public Notificationsubscriptionsv1webhooksRetryPolicy firstRetry(Integer firstRetry) {
        this.firstRetry = firstRetry;
        return this;
    }

    @ApiModelProperty(value="When to initiate first retry, after the initial call failed. (in mins).")
    public Integer getFirstRetry() {
        return this.firstRetry;
    }

    public void setFirstRetry(Integer firstRetry) {
        this.firstRetry = firstRetry;
    }

    public Notificationsubscriptionsv1webhooksRetryPolicy interval(Integer interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(value="The interval between retries (in mins).")
    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public Notificationsubscriptionsv1webhooksRetryPolicy numberOfRetries(Integer numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
        return this;
    }

    @ApiModelProperty(value="The number of retries per sequence.")
    public Integer getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public void setNumberOfRetries(Integer numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
    }

    public Notificationsubscriptionsv1webhooksRetryPolicy deactivateFlag(String deactivateFlag) {
        this.deactivateFlag = deactivateFlag;
        return this;
    }

    @ApiModelProperty(value="Deactivate the subscription if your retries fail to deliver.  If this is set to `true`, the automatic suspend and resume feature will occur. This would prevent new webhooks from attempting to deliver and to queue up until your healthCheckUrl returns 200 again, then all messages will be sent.  If this is set to `false`, new individual messages will continue to retry and exhaust all failures, but the subscription will stay active. ")
    public String getDeactivateFlag() {
        return this.deactivateFlag;
    }

    public void setDeactivateFlag(String deactivateFlag) {
        this.deactivateFlag = deactivateFlag;
    }

    public Notificationsubscriptionsv1webhooksRetryPolicy repeatSequenceCount(Integer repeatSequenceCount) {
        this.repeatSequenceCount = repeatSequenceCount;
        return this;
    }

    @ApiModelProperty(value="The number of times to repeat the complete retry sequence. 0 => don't repeat the retry sequence 1 => repeat the retry sequence once (R1, R2, R3)+ (R1, R2, R3) 2 => repeat the retry sequence twice (R1, R2, R3) + (R1, R2, R3) + (R1, R2, R3) ")
    public Integer getRepeatSequenceCount() {
        return this.repeatSequenceCount;
    }

    public void setRepeatSequenceCount(Integer repeatSequenceCount) {
        this.repeatSequenceCount = repeatSequenceCount;
    }

    public Notificationsubscriptionsv1webhooksRetryPolicy repeatSequenceWaitTime(Integer repeatSequenceWaitTime) {
        this.repeatSequenceWaitTime = repeatSequenceWaitTime;
        return this;
    }

    @ApiModelProperty(value="The time to wait to before repeating the complete retry sequence. Amount of time to wait between each sequence. Sample calculation using repeatSequenceWaitTime=10 (R1, R2, R3) + (10) + (R1, R2, R3) + (10) + (R1, R2, R3) ")
    public Integer getRepeatSequenceWaitTime() {
        return this.repeatSequenceWaitTime;
    }

    public void setRepeatSequenceWaitTime(Integer repeatSequenceWaitTime) {
        this.repeatSequenceWaitTime = repeatSequenceWaitTime;
    }

    public Notificationsubscriptionsv1webhooksRetryPolicy additionalAttributes(List<Map<String, String>> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
        return this;
    }

    public Notificationsubscriptionsv1webhooksRetryPolicy addAdditionalAttributesItem(Map<String, String> additionalAttributesItem) {
        if (this.additionalAttributes == null) {
            this.additionalAttributes = new ArrayList<Map<String, String>>();
        }
        this.additionalAttributes.add(additionalAttributesItem);
        return this;
    }

    @ApiModelProperty(value="Additional data, if any.")
    public List<Map<String, String>> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public void setAdditionalAttributes(List<Map<String, String>> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notificationsubscriptionsv1webhooksRetryPolicy notificationsubscriptionsv1webhooksRetryPolicy = (Notificationsubscriptionsv1webhooksRetryPolicy)o;
        return Objects.equals(this.algorithm, notificationsubscriptionsv1webhooksRetryPolicy.algorithm) && Objects.equals(this.firstRetry, notificationsubscriptionsv1webhooksRetryPolicy.firstRetry) && Objects.equals(this.interval, notificationsubscriptionsv1webhooksRetryPolicy.interval) && Objects.equals(this.numberOfRetries, notificationsubscriptionsv1webhooksRetryPolicy.numberOfRetries) && Objects.equals(this.deactivateFlag, notificationsubscriptionsv1webhooksRetryPolicy.deactivateFlag) && Objects.equals(this.repeatSequenceCount, notificationsubscriptionsv1webhooksRetryPolicy.repeatSequenceCount) && Objects.equals(this.repeatSequenceWaitTime, notificationsubscriptionsv1webhooksRetryPolicy.repeatSequenceWaitTime) && Objects.equals(this.additionalAttributes, notificationsubscriptionsv1webhooksRetryPolicy.additionalAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.algorithm, this.firstRetry, this.interval, this.numberOfRetries, this.deactivateFlag, this.repeatSequenceCount, this.repeatSequenceWaitTime, this.additionalAttributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Notificationsubscriptionsv1webhooksRetryPolicy {\n");
        sb.append("    algorithm: ").append(this.toIndentedString(this.algorithm)).append("\n");
        sb.append("    firstRetry: ").append(this.toIndentedString(this.firstRetry)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    numberOfRetries: ").append(this.toIndentedString(this.numberOfRetries)).append("\n");
        sb.append("    deactivateFlag: ").append(this.toIndentedString(this.deactivateFlag)).append("\n");
        sb.append("    repeatSequenceCount: ").append(this.toIndentedString(this.repeatSequenceCount)).append("\n");
        sb.append("    repeatSequenceWaitTime: ").append(this.toIndentedString(this.repeatSequenceWaitTime)).append("\n");
        sb.append("    additionalAttributes: ").append(this.toIndentedString(this.additionalAttributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

