/*
 * Decompiled with CFR 0.152.
 */
package Model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Identifies the financial institution acting as the acquirer of this customer transaction. The acquirer is the member or system user that signed the merchant.")
public class CardProcessingConfigCommonAcquirer {
    @SerializedName(value="institutionId")
    private String institutionId = null;
    @SerializedName(value="interbankCardAssociationId")
    private String interbankCardAssociationId = null;
    @SerializedName(value="discoverInstitutionId")
    private String discoverInstitutionId = null;
    @SerializedName(value="countryCode")
    private String countryCode = null;
    @SerializedName(value="fileDestinationBin")
    private String fileDestinationBin = null;

    public CardProcessingConfigCommonAcquirer institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @ApiModelProperty(value="Identifier of the acquirer. This number is usually assigned by Visa. Applicable for VPC, GPX (gpx), CMCIC (cmcic), EFTPOS, CB2A, CUP, American Express Direct (amexdirect) and Six (six) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>1</td><td>13</td><td>^[0-9]+$</td><td>1111</td></tr> </table> ")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public CardProcessingConfigCommonAcquirer interbankCardAssociationId(String interbankCardAssociationId) {
        this.interbankCardAssociationId = interbankCardAssociationId;
        return this;
    }

    @ApiModelProperty(value="Number assigned by MasterCard to banks to identify the member in transactions. Applicable for VPC and GPX (gpx) processors.")
    public String getInterbankCardAssociationId() {
        return this.interbankCardAssociationId;
    }

    public void setInterbankCardAssociationId(String interbankCardAssociationId) {
        this.interbankCardAssociationId = interbankCardAssociationId;
    }

    public CardProcessingConfigCommonAcquirer discoverInstitutionId(String discoverInstitutionId) {
        this.discoverInstitutionId = discoverInstitutionId;
        return this;
    }

    @ApiModelProperty(value="Assigned by Discover to identify the acquirer. Applicable for VPC and GPX (gpx) processors.")
    public String getDiscoverInstitutionId() {
        return this.discoverInstitutionId;
    }

    public void setDiscoverInstitutionId(String discoverInstitutionId) {
        this.discoverInstitutionId = discoverInstitutionId;
    }

    public CardProcessingConfigCommonAcquirer countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="ISO 4217 format. Applicable for VPC, GPX (gpx), EFTPOS, RUPAY, Prisma (prisma) and CUP processors.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public CardProcessingConfigCommonAcquirer fileDestinationBin(String fileDestinationBin) {
        this.fileDestinationBin = fileDestinationBin;
        return this;
    }

    @ApiModelProperty(value="The BIN to which this\u00a0capturefile is sent. This field must contain a valid BIN. Applicable for VPC and GPX (gpx) processors.")
    public String getFileDestinationBin() {
        return this.fileDestinationBin;
    }

    public void setFileDestinationBin(String fileDestinationBin) {
        this.fileDestinationBin = fileDestinationBin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardProcessingConfigCommonAcquirer cardProcessingConfigCommonAcquirer = (CardProcessingConfigCommonAcquirer)o;
        return Objects.equals(this.institutionId, cardProcessingConfigCommonAcquirer.institutionId) && Objects.equals(this.interbankCardAssociationId, cardProcessingConfigCommonAcquirer.interbankCardAssociationId) && Objects.equals(this.discoverInstitutionId, cardProcessingConfigCommonAcquirer.discoverInstitutionId) && Objects.equals(this.countryCode, cardProcessingConfigCommonAcquirer.countryCode) && Objects.equals(this.fileDestinationBin, cardProcessingConfigCommonAcquirer.fileDestinationBin);
    }

    public int hashCode() {
        return Objects.hash(this.institutionId, this.interbankCardAssociationId, this.discoverInstitutionId, this.countryCode, this.fileDestinationBin);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardProcessingConfigCommonAcquirer {\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    interbankCardAssociationId: ").append(this.toIndentedString(this.interbankCardAssociationId)).append("\n");
        sb.append("    discoverInstitutionId: ").append(this.toIndentedString(this.discoverInstitutionId)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    fileDestinationBin: ").append(this.toIndentedString(this.fileDestinationBin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

