/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.ReportingV3NetFundingsGet200Response;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import utilities.tracking.SdkTracker;

public class NetFundingsApi {
    private static Logger logger = LogManager.getLogger(NetFundingsApi.class);
    private ApiClient apiClient;

    public NetFundingsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NetFundingsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getNetFundingDetailsCall(DateTime startTime, DateTime endTime, String organizationId, String groupName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/reporting/v3/net-fundings";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (startTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startTime", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "endTime", endTime));
        }
        if (organizationId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "organizationId", organizationId));
        }
        if (groupName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "groupName", groupName));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getNetFundingDetailsValidateBeforeCall(DateTime startTime, DateTime endTime, String organizationId, String groupName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (startTime == null) {
            logger.error("Missing the required parameter 'startTime' when calling getNetFundingDetails(Async)");
            throw new ApiException("Missing the required parameter 'startTime' when calling getNetFundingDetails(Async)");
        }
        if (endTime == null) {
            logger.error("Missing the required parameter 'endTime' when calling getNetFundingDetails(Async)");
            throw new ApiException("Missing the required parameter 'endTime' when calling getNetFundingDetails(Async)");
        }
        Call call = this.getNetFundingDetailsCall(startTime, endTime, organizationId, groupName, progressListener, progressRequestListener);
        return call;
    }

    public ReportingV3NetFundingsGet200Response getNetFundingDetails(DateTime startTime, DateTime endTime, String organizationId, String groupName) throws ApiException {
        logger.info("CALL TO METHOD 'getNetFundingDetails' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<ReportingV3NetFundingsGet200Response> resp = this.getNetFundingDetailsWithHttpInfo(startTime, endTime, organizationId, groupName);
        logger.info("CALL TO METHOD 'getNetFundingDetails' ENDED");
        return resp.getData();
    }

    public ApiResponse<ReportingV3NetFundingsGet200Response> getNetFundingDetailsWithHttpInfo(DateTime startTime, DateTime endTime, String organizationId, String groupName) throws ApiException {
        Call call = this.getNetFundingDetailsValidateBeforeCall(startTime, endTime, organizationId, groupName, null, null);
        Type localVarReturnType = new TypeToken<ReportingV3NetFundingsGet200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getNetFundingDetailsAsync(DateTime startTime, DateTime endTime, String organizationId, String groupName, final ApiCallback<ReportingV3NetFundingsGet200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getNetFundingDetailsValidateBeforeCall(startTime, endTime, organizationId, groupName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ReportingV3NetFundingsGet200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

