/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Model;

import java.util.Objects;
import java.util.Arrays;
import Model.Ptsv2paymentsProcessingInformationAuthorizationOptions;
import Model.Ptsv2paymentsProcessingInformationBankTransferOptions;
import Model.Ptsv2paymentsProcessingInformationCaptureOptions;
import Model.Ptsv2paymentsProcessingInformationElectronicBenefitsTransfer;
import Model.Ptsv2paymentsProcessingInformationJapanPaymentOptions;
import Model.Ptsv2paymentsProcessingInformationLoanOptions;
import Model.Ptsv2paymentsProcessingInformationPurchaseOptions;
import Model.Ptsv2paymentsProcessingInformationRecurringOptions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Ptsv2paymentsProcessingInformation
 */

public class Ptsv2paymentsProcessingInformation {
  @SerializedName("actionList")
  private List<String> actionList = null;

  @SerializedName("enableEscrowOption")
  private Boolean enableEscrowOption = null;

  @SerializedName("actionTokenTypes")
  private List<String> actionTokenTypes = null;

  @SerializedName("binSource")
  private String binSource = null;

  @SerializedName("capture")
  private Boolean capture = false;

  @SerializedName("processorId")
  private String processorId = null;

  @SerializedName("businessApplicationId")
  private String businessApplicationId = null;

  @SerializedName("commerceIndicator")
  private String commerceIndicator = null;

  @SerializedName("commerceIndicatorLabel")
  private String commerceIndicatorLabel = null;

  @SerializedName("paymentSolution")
  private String paymentSolution = null;

  @SerializedName("reconciliationId")
  private String reconciliationId = null;

  @SerializedName("linkId")
  private String linkId = null;

  @SerializedName("purchaseLevel")
  private String purchaseLevel = null;

  @SerializedName("transactionTimeout")
  private Integer transactionTimeout = null;

  @SerializedName("intentsId")
  private String intentsId = null;

  @SerializedName("paymentId")
  private String paymentId = null;

  @SerializedName("reportGroup")
  private String reportGroup = null;

  @SerializedName("visaCheckoutId")
  private String visaCheckoutId = null;

  @SerializedName("industryDataType")
  private String industryDataType = null;

  @SerializedName("authorizationOptions")
  private Ptsv2paymentsProcessingInformationAuthorizationOptions authorizationOptions = null;

  @SerializedName("captureOptions")
  private Ptsv2paymentsProcessingInformationCaptureOptions captureOptions = null;

  @SerializedName("recurringOptions")
  private Ptsv2paymentsProcessingInformationRecurringOptions recurringOptions = null;

  @SerializedName("bankTransferOptions")
  private Ptsv2paymentsProcessingInformationBankTransferOptions bankTransferOptions = null;

  @SerializedName("purchaseOptions")
  private Ptsv2paymentsProcessingInformationPurchaseOptions purchaseOptions = null;

  @SerializedName("electronicBenefitsTransfer")
  private Ptsv2paymentsProcessingInformationElectronicBenefitsTransfer electronicBenefitsTransfer = null;

  @SerializedName("loanOptions")
  private Ptsv2paymentsProcessingInformationLoanOptions loanOptions = null;

  @SerializedName("walletType")
  private String walletType = null;

  @SerializedName("nationalNetDomesticData")
  private String nationalNetDomesticData = null;

  @SerializedName("japanPaymentOptions")
  private Ptsv2paymentsProcessingInformationJapanPaymentOptions japanPaymentOptions = null;

  @SerializedName("mobileRemotePaymentType")
  private String mobileRemotePaymentType = null;

  @SerializedName("extendedCreditTotalCount")
  private String extendedCreditTotalCount = null;

  @SerializedName("networkRoutingOrder")
  private String networkRoutingOrder = null;

  @SerializedName("payByPointsIndicator")
  private Boolean payByPointsIndicator = null;

  @SerializedName("timeout")
  private Integer timeout = null;

  @SerializedName("isReturnAuthRecordEnabled")
  private Boolean isReturnAuthRecordEnabled = null;

  @SerializedName("networkPartnerId")
  private String networkPartnerId = null;

  @SerializedName("paymentType")
  private String paymentType = null;

  public Ptsv2paymentsProcessingInformation actionList(List<String> actionList) {
    this.actionList = actionList;
    return this;
  }

  public Ptsv2paymentsProcessingInformation addActionListItem(String actionListItem) {
    if (this.actionList == null) {
      this.actionList = new ArrayList<String>();
    }
    this.actionList.add(actionListItem);
    return this;
  }

   /**
   * Array of actions (one or more) to be included in the payment to invoke bundled services along with payment.  Possible values are one or more of follows:   - &#x60;DECISION_SKIP&#x60;: Use this when you want to skip Decision Manager service(s).   - &#x60;TOKEN_CREATE&#x60;: Use this when you want to create a token from the card/bank data in your payment request.   - &#x60;CONSUMER_AUTHENTICATION&#x60;: Use this when you want to check if a card is enrolled in Payer Authentication along with your payment request.   - &#x60;VALIDATE_CONSUMER_AUTHENTICATION&#x60;: Use this after you acquire a Payer Authentication result that needs to be included for your payment request.    - &#x60;AP_INITIATE&#x60;: Use this when Alternative Payment Initiate service is requested.   - &#x60;WATCHLIST_SCREENING&#x60; : Use this when you want to call Watchlist Screening service.   - &#x60;AP_SALE&#x60; : Use this when Alternative Payment Sale service is requested.    - &#x60;AP_AUTH&#x60; : Use this when Alternative Payment Authorize service is requested. 
   * @return actionList
  **/
  @ApiModelProperty(value = "Array of actions (one or more) to be included in the payment to invoke bundled services along with payment.  Possible values are one or more of follows:   - `DECISION_SKIP`: Use this when you want to skip Decision Manager service(s).   - `TOKEN_CREATE`: Use this when you want to create a token from the card/bank data in your payment request.   - `CONSUMER_AUTHENTICATION`: Use this when you want to check if a card is enrolled in Payer Authentication along with your payment request.   - `VALIDATE_CONSUMER_AUTHENTICATION`: Use this after you acquire a Payer Authentication result that needs to be included for your payment request.    - `AP_INITIATE`: Use this when Alternative Payment Initiate service is requested.   - `WATCHLIST_SCREENING` : Use this when you want to call Watchlist Screening service.   - `AP_SALE` : Use this when Alternative Payment Sale service is requested.    - `AP_AUTH` : Use this when Alternative Payment Authorize service is requested. ")
  public List<String> getActionList() {
    return actionList;
  }

  public void setActionList(List<String> actionList) {
    this.actionList = actionList;
  }

  public Ptsv2paymentsProcessingInformation enableEscrowOption(Boolean enableEscrowOption) {
    this.enableEscrowOption = enableEscrowOption;
    return this;
  }

   /**
   * Indicates whether to use the customer&#39;s escrow agreement. Possible values: - &#x60;true&#x60;: yes, use the customer&#39;s escrow agreement. - &#x60;false&#x60;: no, do not use the customer&#39;s escrow agreement.  
   * @return enableEscrowOption
  **/
  @ApiModelProperty(value = "Indicates whether to use the customer's escrow agreement. Possible values: - `true`: yes, use the customer's escrow agreement. - `false`: no, do not use the customer's escrow agreement.  ")
  public Boolean isEnableEscrowOption() {
    return enableEscrowOption;
  }

  public void setEnableEscrowOption(Boolean enableEscrowOption) {
    this.enableEscrowOption = enableEscrowOption;
  }

  public Ptsv2paymentsProcessingInformation actionTokenTypes(List<String> actionTokenTypes) {
    this.actionTokenTypes = actionTokenTypes;
    return this;
  }

  public Ptsv2paymentsProcessingInformation addActionTokenTypesItem(String actionTokenTypesItem) {
    if (this.actionTokenTypes == null) {
      this.actionTokenTypes = new ArrayList<String>();
    }
    this.actionTokenTypes.add(actionTokenTypesItem);
    return this;
  }

   /**
   * CyberSource tokens types you are performing a create on. If not supplied the default token type for the merchants token vault will be used.  Valid values: - customer - paymentInstrument - instrumentIdentifier - shippingAddress 
   * @return actionTokenTypes
  **/
  @ApiModelProperty(value = "CyberSource tokens types you are performing a create on. If not supplied the default token type for the merchants token vault will be used.  Valid values: - customer - paymentInstrument - instrumentIdentifier - shippingAddress ")
  public List<String> getActionTokenTypes() {
    return actionTokenTypes;
  }

  public void setActionTokenTypes(List<String> actionTokenTypes) {
    this.actionTokenTypes = actionTokenTypes;
  }

  public Ptsv2paymentsProcessingInformation binSource(String binSource) {
    this.binSource = binSource;
    return this;
  }

   /**
   * Bin Source File Identifier. Possible values: - itmx - rupay 
   * @return binSource
  **/
  @ApiModelProperty(value = "Bin Source File Identifier. Possible values: - itmx - rupay ")
  public String getBinSource() {
    return binSource;
  }

  public void setBinSource(String binSource) {
    this.binSource = binSource;
  }

  public Ptsv2paymentsProcessingInformation capture(Boolean capture) {
    this.capture = capture;
    return this;
  }

   /**
   * Indicates whether to also include a capture  in the submitted authorization request or not.  Possible values: - &#x60;true&#x60;: Include a capture with an authorization request. - &#x60;false&#x60;: (default) Do not include a capture with an authorization request.  #### Used by **Authorization and Capture** Optional field. 
   * @return capture
  **/
  @ApiModelProperty(value = "Indicates whether to also include a capture  in the submitted authorization request or not.  Possible values: - `true`: Include a capture with an authorization request. - `false`: (default) Do not include a capture with an authorization request.  #### Used by **Authorization and Capture** Optional field. ")
  public Boolean isCapture() {
    return capture;
  }

  public void setCapture(Boolean capture) {
    this.capture = capture;
  }

  public Ptsv2paymentsProcessingInformation processorId(String processorId) {
    this.processorId = processorId;
    return this;
  }

   /**
   * Value that identifies the processor/acquirer to use for the transaction. This value is supported only for **CyberSource through VisaNet**.  Contact CyberSource Customer Support to get the value for this field. 
   * @return processorId
  **/
  @ApiModelProperty(value = "Value that identifies the processor/acquirer to use for the transaction. This value is supported only for **CyberSource through VisaNet**.  Contact CyberSource Customer Support to get the value for this field. ")
  public String getProcessorId() {
    return processorId;
  }

  public void setProcessorId(String processorId) {
    this.processorId = processorId;
  }

  public Ptsv2paymentsProcessingInformation businessApplicationId(String businessApplicationId) {
    this.businessApplicationId = businessApplicationId;
    return this;
  }

   /**
   * Payouts transaction type. Required for OCT transactions. This field is a pass-through, which means that CyberSource does not verify the value or modify it in any way before sending it to the processor. **Note** When the request includes this field, this value overrides the information in your CyberSource account. 
   * @return businessApplicationId
  **/
  @ApiModelProperty(value = "Payouts transaction type. Required for OCT transactions. This field is a pass-through, which means that CyberSource does not verify the value or modify it in any way before sending it to the processor. **Note** When the request includes this field, this value overrides the information in your CyberSource account. ")
  public String getBusinessApplicationId() {
    return businessApplicationId;
  }

  public void setBusinessApplicationId(String businessApplicationId) {
    this.businessApplicationId = businessApplicationId;
  }

  public Ptsv2paymentsProcessingInformation commerceIndicator(String commerceIndicator) {
    this.commerceIndicator = commerceIndicator;
    return this;
  }

   /**
   * Type of transaction. Some payment card companies use this information when determining discount rates.  #### Used by **Authorization** Required payer authentication transactions; otherwise, optional. **Credit** Required for standalone credits on Chase Paymentech solutions; otherwise, optional.  The list of valid values in this field depends on your processor.  #### Ingenico ePayments When you omit this field for Ingenico ePayments, the processor uses the default transaction type they have on file for you instead of the default value   #### Card Present You must set this field to &#x60;retail&#x60;. This field is required for a card-present transaction. Note that this should ONLY be used when the cardholder and card are present at the time of the transaction. For all keyed transactions originated from a POS terminal where the cardholder and card are not present, commerceIndicator should be submitted as \&quot;moto\&quot; 
   * @return commerceIndicator
  **/
  @ApiModelProperty(value = "Type of transaction. Some payment card companies use this information when determining discount rates.  #### Used by **Authorization** Required payer authentication transactions; otherwise, optional. **Credit** Required for standalone credits on Chase Paymentech solutions; otherwise, optional.  The list of valid values in this field depends on your processor.  #### Ingenico ePayments When you omit this field for Ingenico ePayments, the processor uses the default transaction type they have on file for you instead of the default value   #### Card Present You must set this field to `retail`. This field is required for a card-present transaction. Note that this should ONLY be used when the cardholder and card are present at the time of the transaction. For all keyed transactions originated from a POS terminal where the cardholder and card are not present, commerceIndicator should be submitted as \"moto\" ")
  public String getCommerceIndicator() {
    return commerceIndicator;
  }

  public void setCommerceIndicator(String commerceIndicator) {
    this.commerceIndicator = commerceIndicator;
  }

  public Ptsv2paymentsProcessingInformation commerceIndicatorLabel(String commerceIndicatorLabel) {
    this.commerceIndicatorLabel = commerceIndicatorLabel;
    return this;
  }

   /**
   * Type of transaction. Some payment card companies use this information when determining discount rates.  #### Used by **Authorization** Required payer authentication transactions; otherwise, optional. **Credit** Required for standalone credits on Chase Paymentech solutions; otherwise, optional.  The list of valid values in this field depends on your processor.  #### Ingenico ePayments When you omit this field for Ingenico ePayments, the processor uses the default transaction type they have on file for you instead of the default value   #### Card Present You must set this field to &#x60;retail&#x60;. This field is required for a card-present transaction. Note that this should ONLY be used when the cardholder and card are present at the time of the transaction. For all keyed transactions originated from a POS terminal where the cardholder and card are not present, commerceIndicator should be submitted as &#x60;moto&#x60; 
   * @return commerceIndicatorLabel
  **/
  @ApiModelProperty(value = "Type of transaction. Some payment card companies use this information when determining discount rates.  #### Used by **Authorization** Required payer authentication transactions; otherwise, optional. **Credit** Required for standalone credits on Chase Paymentech solutions; otherwise, optional.  The list of valid values in this field depends on your processor.  #### Ingenico ePayments When you omit this field for Ingenico ePayments, the processor uses the default transaction type they have on file for you instead of the default value   #### Card Present You must set this field to `retail`. This field is required for a card-present transaction. Note that this should ONLY be used when the cardholder and card are present at the time of the transaction. For all keyed transactions originated from a POS terminal where the cardholder and card are not present, commerceIndicator should be submitted as `moto` ")
  public String getCommerceIndicatorLabel() {
    return commerceIndicatorLabel;
  }

  public void setCommerceIndicatorLabel(String commerceIndicatorLabel) {
    this.commerceIndicatorLabel = commerceIndicatorLabel;
  }

  public Ptsv2paymentsProcessingInformation paymentSolution(String paymentSolution) {
    this.paymentSolution = paymentSolution;
    return this;
  }

   /**
   * Type of digital payment solution for the transaction. Possible Values:   - &#x60;visacheckout&#x60;: Visa Checkout. This value is required for Visa Checkout transactions. For details, see &#x60;payment_solution&#x60; field description in [Visa Checkout Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/VCO_SCMP_API/html/)  - &#x60;001&#x60;: Apple Pay.  - &#x60;004&#x60;: Cybersource In-App Solution.  - &#x60;005&#x60;: Masterpass. This value is required for Masterpass transactions on OmniPay Direct. For details, see \&quot;Masterpass\&quot; in the [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/)  - &#x60;006&#x60;: Android Pay.  - &#x60;007&#x60;: Chase Pay.  - &#x60;008&#x60;: Samsung Pay.  - &#x60;012&#x60;: Google Pay.  - &#x60;013&#x60;: Cybersource P2PE Decryption  - &#x60;014&#x60;: Mastercard credential on file (COF) payment network token. Returned in authorizations that use a payment network token associated with a TMS token.  - &#x60;015&#x60;: Visa credential on file (COF) payment network token. Returned in authorizations that use a payment network token associated with a TMS token.  - &#x60;027&#x60;: Click to Pay. 
   * @return paymentSolution
  **/
  @ApiModelProperty(value = "Type of digital payment solution for the transaction. Possible Values:   - `visacheckout`: Visa Checkout. This value is required for Visa Checkout transactions. For details, see `payment_solution` field description in [Visa Checkout Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/VCO_SCMP_API/html/)  - `001`: Apple Pay.  - `004`: Cybersource In-App Solution.  - `005`: Masterpass. This value is required for Masterpass transactions on OmniPay Direct. For details, see \"Masterpass\" in the [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/)  - `006`: Android Pay.  - `007`: Chase Pay.  - `008`: Samsung Pay.  - `012`: Google Pay.  - `013`: Cybersource P2PE Decryption  - `014`: Mastercard credential on file (COF) payment network token. Returned in authorizations that use a payment network token associated with a TMS token.  - `015`: Visa credential on file (COF) payment network token. Returned in authorizations that use a payment network token associated with a TMS token.  - `027`: Click to Pay. ")
  public String getPaymentSolution() {
    return paymentSolution;
  }

  public void setPaymentSolution(String paymentSolution) {
    this.paymentSolution = paymentSolution;
  }

  public Ptsv2paymentsProcessingInformation reconciliationId(String reconciliationId) {
    this.reconciliationId = reconciliationId;
    return this;
  }

   /**
   * Please check with Cybersource customer support to see if your merchant account is configured correctly so you can include this field in your request. * For Payouts: max length for FDCCompass is String (22). 
   * @return reconciliationId
  **/
  @ApiModelProperty(value = "Please check with Cybersource customer support to see if your merchant account is configured correctly so you can include this field in your request. * For Payouts: max length for FDCCompass is String (22). ")
  public String getReconciliationId() {
    return reconciliationId;
  }

  public void setReconciliationId(String reconciliationId) {
    this.reconciliationId = reconciliationId;
  }

  public Ptsv2paymentsProcessingInformation linkId(String linkId) {
    this.linkId = linkId;
    return this;
  }

   /**
   * Value that links the current authorization request to the original authorization request. Set this value to the ID that was returned in the reply message from the original authorization request.  This value is used for:  - Partial authorizations - Split shipments 
   * @return linkId
  **/
  @ApiModelProperty(value = "Value that links the current authorization request to the original authorization request. Set this value to the ID that was returned in the reply message from the original authorization request.  This value is used for:  - Partial authorizations - Split shipments ")
  public String getLinkId() {
    return linkId;
  }

  public void setLinkId(String linkId) {
    this.linkId = linkId;
  }

  public Ptsv2paymentsProcessingInformation purchaseLevel(String purchaseLevel) {
    this.purchaseLevel = purchaseLevel;
    return this;
  }

   /**
   * Set this field to 3 to indicate that the request includes Level III data.
   * @return purchaseLevel
  **/
  @ApiModelProperty(value = "Set this field to 3 to indicate that the request includes Level III data.")
  public String getPurchaseLevel() {
    return purchaseLevel;
  }

  public void setPurchaseLevel(String purchaseLevel) {
    this.purchaseLevel = purchaseLevel;
  }

  public Ptsv2paymentsProcessingInformation transactionTimeout(Integer transactionTimeout) {
    this.transactionTimeout = transactionTimeout;
    return this;
  }

   /**
   * The time-out limit in seconds for the transaction. The time-out limit starts when the customer is directed to the merchant URL that is included in the sale service response. The maximum value is 99999 (about 27 hours). When the transaction times out, the payment system changes the status to abandoned.
   * maximum: 99999
   * @return transactionTimeout
  **/
  @ApiModelProperty(value = "The time-out limit in seconds for the transaction. The time-out limit starts when the customer is directed to the merchant URL that is included in the sale service response. The maximum value is 99999 (about 27 hours). When the transaction times out, the payment system changes the status to abandoned.")
  public Integer getTransactionTimeout() {
    return transactionTimeout;
  }

  public void setTransactionTimeout(Integer transactionTimeout) {
    this.transactionTimeout = transactionTimeout;
  }

  public Ptsv2paymentsProcessingInformation intentsId(String intentsId) {
    this.intentsId = intentsId;
    return this;
  }

   /**
   * Set to the value of the requestID field returned in the order service response.
   * @return intentsId
  **/
  @ApiModelProperty(value = "Set to the value of the requestID field returned in the order service response.")
  public String getIntentsId() {
    return intentsId;
  }

  public void setIntentsId(String intentsId) {
    this.intentsId = intentsId;
  }

  public Ptsv2paymentsProcessingInformation paymentId(String paymentId) {
    this.paymentId = paymentId;
    return this;
  }

   /**
   * This field is to accept the id of credit/capture in the body of L1 requests so the type of void can be identified and processed correctly downstream.
   * @return paymentId
  **/
  @ApiModelProperty(value = "This field is to accept the id of credit/capture in the body of L1 requests so the type of void can be identified and processed correctly downstream.")
  public String getPaymentId() {
    return paymentId;
  }

  public void setPaymentId(String paymentId) {
    this.paymentId = paymentId;
  }

  public Ptsv2paymentsProcessingInformation reportGroup(String reportGroup) {
    this.reportGroup = reportGroup;
    return this;
  }

   /**
   * Attribute that lets you define custom grouping for your processor reports. This field is supported only for **Worldpay VAP**. 
   * @return reportGroup
  **/
  @ApiModelProperty(value = "Attribute that lets you define custom grouping for your processor reports. This field is supported only for **Worldpay VAP**. ")
  public String getReportGroup() {
    return reportGroup;
  }

  public void setReportGroup(String reportGroup) {
    this.reportGroup = reportGroup;
  }

  public Ptsv2paymentsProcessingInformation visaCheckoutId(String visaCheckoutId) {
    this.visaCheckoutId = visaCheckoutId;
    return this;
  }

   /**
   * Identifier for the **Visa Checkout** order. Visa Checkout provides a unique order ID for every transaction in the Visa Checkout **callID** field. 
   * @return visaCheckoutId
  **/
  @ApiModelProperty(value = "Identifier for the **Visa Checkout** order. Visa Checkout provides a unique order ID for every transaction in the Visa Checkout **callID** field. ")
  public String getVisaCheckoutId() {
    return visaCheckoutId;
  }

  public void setVisaCheckoutId(String visaCheckoutId) {
    this.visaCheckoutId = visaCheckoutId;
  }

  public Ptsv2paymentsProcessingInformation industryDataType(String industryDataType) {
    this.industryDataType = industryDataType;
    return this;
  }

   /**
   * Indicates that the transaction includes industry-specific data.  Possible Values: - &#x60;airline&#x60; - &#x60;restaurant&#x60; - &#x60;lodging&#x60; - &#x60;auto_rental&#x60; - &#x60;transit&#x60; - &#x60;healthcare_medical&#x60; - &#x60;healthcare_transit&#x60; - &#x60;transit&#x60;  #### Card Present, Airlines and Auto Rental You must set this field to &#x60;airline&#x60; in order for airline data to be sent to the processor. For example, if this field is not set to &#x60;airline&#x60; or is not included in the request, no airline data is sent to the processor.  You must set this field to &#x60;restaurant&#x60; in order for restaurant data to be sent to the processor. When this field is not set to &#x60;restaurant&#x60; or is not included in the request, no restaurant data is sent to the processor.  You must set this field to &#x60;auto_rental&#x60; in order for auto rental data to be sent to the processor. For example, if this field is not set to &#x60;auto_rental&#x60; or is not included in the request, no auto rental data is sent to the processor.  Restaurant data is supported only on CyberSource through VisaNet. 
   * @return industryDataType
  **/
  @ApiModelProperty(value = "Indicates that the transaction includes industry-specific data.  Possible Values: - `airline` - `restaurant` - `lodging` - `auto_rental` - `transit` - `healthcare_medical` - `healthcare_transit` - `transit`  #### Card Present, Airlines and Auto Rental You must set this field to `airline` in order for airline data to be sent to the processor. For example, if this field is not set to `airline` or is not included in the request, no airline data is sent to the processor.  You must set this field to `restaurant` in order for restaurant data to be sent to the processor. When this field is not set to `restaurant` or is not included in the request, no restaurant data is sent to the processor.  You must set this field to `auto_rental` in order for auto rental data to be sent to the processor. For example, if this field is not set to `auto_rental` or is not included in the request, no auto rental data is sent to the processor.  Restaurant data is supported only on CyberSource through VisaNet. ")
  public String getIndustryDataType() {
    return industryDataType;
  }

  public void setIndustryDataType(String industryDataType) {
    this.industryDataType = industryDataType;
  }

  public Ptsv2paymentsProcessingInformation authorizationOptions(Ptsv2paymentsProcessingInformationAuthorizationOptions authorizationOptions) {
    this.authorizationOptions = authorizationOptions;
    return this;
  }

   /**
   * Get authorizationOptions
   * @return authorizationOptions
  **/
  @ApiModelProperty(value = "")
  public Ptsv2paymentsProcessingInformationAuthorizationOptions getAuthorizationOptions() {
    return authorizationOptions;
  }

  public void setAuthorizationOptions(Ptsv2paymentsProcessingInformationAuthorizationOptions authorizationOptions) {
    this.authorizationOptions = authorizationOptions;
  }

  public Ptsv2paymentsProcessingInformation captureOptions(Ptsv2paymentsProcessingInformationCaptureOptions captureOptions) {
    this.captureOptions = captureOptions;
    return this;
  }

   /**
   * Get captureOptions
   * @return captureOptions
  **/
  @ApiModelProperty(value = "")
  public Ptsv2paymentsProcessingInformationCaptureOptions getCaptureOptions() {
    return captureOptions;
  }

  public void setCaptureOptions(Ptsv2paymentsProcessingInformationCaptureOptions captureOptions) {
    this.captureOptions = captureOptions;
  }

  public Ptsv2paymentsProcessingInformation recurringOptions(Ptsv2paymentsProcessingInformationRecurringOptions recurringOptions) {
    this.recurringOptions = recurringOptions;
    return this;
  }

   /**
   * Get recurringOptions
   * @return recurringOptions
  **/
  @ApiModelProperty(value = "")
  public Ptsv2paymentsProcessingInformationRecurringOptions getRecurringOptions() {
    return recurringOptions;
  }

  public void setRecurringOptions(Ptsv2paymentsProcessingInformationRecurringOptions recurringOptions) {
    this.recurringOptions = recurringOptions;
  }

  public Ptsv2paymentsProcessingInformation bankTransferOptions(Ptsv2paymentsProcessingInformationBankTransferOptions bankTransferOptions) {
    this.bankTransferOptions = bankTransferOptions;
    return this;
  }

   /**
   * Get bankTransferOptions
   * @return bankTransferOptions
  **/
  @ApiModelProperty(value = "")
  public Ptsv2paymentsProcessingInformationBankTransferOptions getBankTransferOptions() {
    return bankTransferOptions;
  }

  public void setBankTransferOptions(Ptsv2paymentsProcessingInformationBankTransferOptions bankTransferOptions) {
    this.bankTransferOptions = bankTransferOptions;
  }

  public Ptsv2paymentsProcessingInformation purchaseOptions(Ptsv2paymentsProcessingInformationPurchaseOptions purchaseOptions) {
    this.purchaseOptions = purchaseOptions;
    return this;
  }

   /**
   * Get purchaseOptions
   * @return purchaseOptions
  **/
  @ApiModelProperty(value = "")
  public Ptsv2paymentsProcessingInformationPurchaseOptions getPurchaseOptions() {
    return purchaseOptions;
  }

  public void setPurchaseOptions(Ptsv2paymentsProcessingInformationPurchaseOptions purchaseOptions) {
    this.purchaseOptions = purchaseOptions;
  }

  public Ptsv2paymentsProcessingInformation electronicBenefitsTransfer(Ptsv2paymentsProcessingInformationElectronicBenefitsTransfer electronicBenefitsTransfer) {
    this.electronicBenefitsTransfer = electronicBenefitsTransfer;
    return this;
  }

   /**
   * Get electronicBenefitsTransfer
   * @return electronicBenefitsTransfer
  **/
  @ApiModelProperty(value = "")
  public Ptsv2paymentsProcessingInformationElectronicBenefitsTransfer getElectronicBenefitsTransfer() {
    return electronicBenefitsTransfer;
  }

  public void setElectronicBenefitsTransfer(Ptsv2paymentsProcessingInformationElectronicBenefitsTransfer electronicBenefitsTransfer) {
    this.electronicBenefitsTransfer = electronicBenefitsTransfer;
  }

  public Ptsv2paymentsProcessingInformation loanOptions(Ptsv2paymentsProcessingInformationLoanOptions loanOptions) {
    this.loanOptions = loanOptions;
    return this;
  }

   /**
   * Get loanOptions
   * @return loanOptions
  **/
  @ApiModelProperty(value = "")
  public Ptsv2paymentsProcessingInformationLoanOptions getLoanOptions() {
    return loanOptions;
  }

  public void setLoanOptions(Ptsv2paymentsProcessingInformationLoanOptions loanOptions) {
    this.loanOptions = loanOptions;
  }

  public Ptsv2paymentsProcessingInformation walletType(String walletType) {
    this.walletType = walletType;
    return this;
  }

   /**
   * This field carries the wallet type in authorization requests and credit requests. Possible value are: - &#x60;101&#x60;: Masterpass remote payment. The customer created the wallet by manually interacting with a customer-controlled device such as a computer, tablet, or phone. This value is supported only for Masterpass transactions on Chase Paymentech Solutions and CyberSource through VisaNet. - &#x60;102&#x60;: Masterpass remote near field communication (NFC) payment. The customer created the wallet by tapping a PayPass card or customer-controlled device at a contactless card reader. This value is supported only for card-present Masterpass transactions on CyberSource through VisaNet. - &#x60;103&#x60;: Masterpass Apple Pay payment. The payment was made with a combination of Masterpass and Apple Pay. This value is supported only for Masterpass Apple Pay transactions on CyberSource through VisaNet. - &#x60;216&#x60;: Masterpass Google Pay payment. The payment was made with a combination of Masterpass and Google Pay. This value is supported only for Masterpass Google Pay transactions on CyberSource through VisaNet. - &#x60;217&#x60;: Masterpass Samsung Pay payment. The payment was made with a combination of Masterpass and Samsung Pay. This value is supported only for Masterpass Samsung Pay transactions on CyberSource through VisaNet. - &#x60;SDW&#x60;: Staged digital wallet. An issuer or operator created the wallet. This value is supported only for Masterpass transactions on Chase Paymentech Solutions. - &#x60;VCIND&#x60;: Visa Checkout payment. This value is supported only on CyberSource through VisaNet, FDC Compass, FDC Nashville Global, FDI Australia, and TSYS Acquiring Solutions. See Getting Started with Visa Checkout. For Visa Checkout transactions, the way CyberSource processes the value for this field depends on the processor. See the Visa Checkout section below. For all other values, this field is a passthrough; therefore, CyberSource does not verify the value or modify it in any way before sending it to the processor. Masterpass (101, 102, 103, 216, and 217): The Masterpass platform generates the wallet type value and passes it to you along with the customer&#39;s checkout information.  Visa Checkout: This field is optional for Visa Checkout authorizations on FDI Australia. For all other processors, this field is required for Visa Checkout authorizations. For Visa Checkout transactions on the following processors, CyberSource sends the value that the processor expects for this field:FDC Compass,FDC Nashville Global,FDI Australia,TSYS Acquiring Solutions For all other processors, this field is a passthrough; therefore, CyberSource does not verify the value or modify it in any way before sending it to the processor. For incremental authorizations, this field is supported only for Mastercard and the supported values are 101 and 102. Payment card companies can introduce new values without notice. Your order management system should be able to process new values without problems.  CyberSource through VisaNet When the value for this field is 101, 102, 103, 216, or 217, it corresponds to the following data in the TC 33 capture file5: Record: CP01 TCR6, Position: 88-90,  Field: Mastercard Wallet Identifier. When the value for this field is VCIND, it corresponds to the following data in the TC 33 capture file5: Record: CP01 TCR8, Position: 72-76, Field: Agent Unique ID. 
   * @return walletType
  **/
  @ApiModelProperty(value = "This field carries the wallet type in authorization requests and credit requests. Possible value are: - `101`: Masterpass remote payment. The customer created the wallet by manually interacting with a customer-controlled device such as a computer, tablet, or phone. This value is supported only for Masterpass transactions on Chase Paymentech Solutions and CyberSource through VisaNet. - `102`: Masterpass remote near field communication (NFC) payment. The customer created the wallet by tapping a PayPass card or customer-controlled device at a contactless card reader. This value is supported only for card-present Masterpass transactions on CyberSource through VisaNet. - `103`: Masterpass Apple Pay payment. The payment was made with a combination of Masterpass and Apple Pay. This value is supported only for Masterpass Apple Pay transactions on CyberSource through VisaNet. - `216`: Masterpass Google Pay payment. The payment was made with a combination of Masterpass and Google Pay. This value is supported only for Masterpass Google Pay transactions on CyberSource through VisaNet. - `217`: Masterpass Samsung Pay payment. The payment was made with a combination of Masterpass and Samsung Pay. This value is supported only for Masterpass Samsung Pay transactions on CyberSource through VisaNet. - `SDW`: Staged digital wallet. An issuer or operator created the wallet. This value is supported only for Masterpass transactions on Chase Paymentech Solutions. - `VCIND`: Visa Checkout payment. This value is supported only on CyberSource through VisaNet, FDC Compass, FDC Nashville Global, FDI Australia, and TSYS Acquiring Solutions. See Getting Started with Visa Checkout. For Visa Checkout transactions, the way CyberSource processes the value for this field depends on the processor. See the Visa Checkout section below. For all other values, this field is a passthrough; therefore, CyberSource does not verify the value or modify it in any way before sending it to the processor. Masterpass (101, 102, 103, 216, and 217): The Masterpass platform generates the wallet type value and passes it to you along with the customer's checkout information.  Visa Checkout: This field is optional for Visa Checkout authorizations on FDI Australia. For all other processors, this field is required for Visa Checkout authorizations. For Visa Checkout transactions on the following processors, CyberSource sends the value that the processor expects for this field:FDC Compass,FDC Nashville Global,FDI Australia,TSYS Acquiring Solutions For all other processors, this field is a passthrough; therefore, CyberSource does not verify the value or modify it in any way before sending it to the processor. For incremental authorizations, this field is supported only for Mastercard and the supported values are 101 and 102. Payment card companies can introduce new values without notice. Your order management system should be able to process new values without problems.  CyberSource through VisaNet When the value for this field is 101, 102, 103, 216, or 217, it corresponds to the following data in the TC 33 capture file5: Record: CP01 TCR6, Position: 88-90,  Field: Mastercard Wallet Identifier. When the value for this field is VCIND, it corresponds to the following data in the TC 33 capture file5: Record: CP01 TCR8, Position: 72-76, Field: Agent Unique ID. ")
  public String getWalletType() {
    return walletType;
  }

  public void setWalletType(String walletType) {
    this.walletType = walletType;
  }

  public Ptsv2paymentsProcessingInformation nationalNetDomesticData(String nationalNetDomesticData) {
    this.nationalNetDomesticData = nationalNetDomesticData;
    return this;
  }

   /**
   * Supplementary domestic transaction information provided by the acquirer for National Net Settlement Service (NNSS) transactions. NNSS is a settlement service that Visa provides. For transactions on CyberSource through VisaNet in countries that subscribe to NNSS: VisaNet clears transactions; VisaNet transfers funds to the acquirer after deducting processing fees and interchange fees. VisaNet settles transactions in the local pricing currency through a local financial institution. This field is supported only on CyberSource through VisaNet for domestic data in Colombia 
   * @return nationalNetDomesticData
  **/
  @ApiModelProperty(value = "Supplementary domestic transaction information provided by the acquirer for National Net Settlement Service (NNSS) transactions. NNSS is a settlement service that Visa provides. For transactions on CyberSource through VisaNet in countries that subscribe to NNSS: VisaNet clears transactions; VisaNet transfers funds to the acquirer after deducting processing fees and interchange fees. VisaNet settles transactions in the local pricing currency through a local financial institution. This field is supported only on CyberSource through VisaNet for domestic data in Colombia ")
  public String getNationalNetDomesticData() {
    return nationalNetDomesticData;
  }

  public void setNationalNetDomesticData(String nationalNetDomesticData) {
    this.nationalNetDomesticData = nationalNetDomesticData;
  }

  public Ptsv2paymentsProcessingInformation japanPaymentOptions(Ptsv2paymentsProcessingInformationJapanPaymentOptions japanPaymentOptions) {
    this.japanPaymentOptions = japanPaymentOptions;
    return this;
  }

   /**
   * Get japanPaymentOptions
   * @return japanPaymentOptions
  **/
  @ApiModelProperty(value = "")
  public Ptsv2paymentsProcessingInformationJapanPaymentOptions getJapanPaymentOptions() {
    return japanPaymentOptions;
  }

  public void setJapanPaymentOptions(Ptsv2paymentsProcessingInformationJapanPaymentOptions japanPaymentOptions) {
    this.japanPaymentOptions = japanPaymentOptions;
  }

  public Ptsv2paymentsProcessingInformation mobileRemotePaymentType(String mobileRemotePaymentType) {
    this.mobileRemotePaymentType = mobileRemotePaymentType;
    return this;
  }

   /**
   * Type of payment initiated from a cardholder&#39;s mobile device. Possible values: - &#x60;1&#x60; :  Consumer-initiated remote purchase, face-to-face - &#x60;2&#x60; :  Consumer-initiated remote purchase, e-commerce - &#x60;3&#x60; :  Consumer-initiated remote purchase, mail order / telephone order - &#x60;4&#x60; :  Consumer-initiated bill pay - &#x60;5&#x60; :  Consumer-initiated top up - &#x60;6&#x60; :  Consumer-initiated cash out - &#x60;7&#x60; :  ATM triggered or agent-initiated cash out - &#x60;8&#x60; :  Merchant-initiated remote purchase, face-to-face - &#x60;9&#x60; :  Merchant-initiated remote purchase, e-commerce  This field is supported only for Mastercard transactions on CyberSource through VisaNet.  Optional field.  **Note** On CyberSource through VisaNet, the value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR6 - Position: 94 - Field: Mastercard Mobile Remote Payment Program Indicator  The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant&#39;s acquirer, who uses this information to facilitate end-of-day clearing processing with payment networks. 
   * @return mobileRemotePaymentType
  **/
  @ApiModelProperty(value = "Type of payment initiated from a cardholder's mobile device. Possible values: - `1` :  Consumer-initiated remote purchase, face-to-face - `2` :  Consumer-initiated remote purchase, e-commerce - `3` :  Consumer-initiated remote purchase, mail order / telephone order - `4` :  Consumer-initiated bill pay - `5` :  Consumer-initiated top up - `6` :  Consumer-initiated cash out - `7` :  ATM triggered or agent-initiated cash out - `8` :  Merchant-initiated remote purchase, face-to-face - `9` :  Merchant-initiated remote purchase, e-commerce  This field is supported only for Mastercard transactions on CyberSource through VisaNet.  Optional field.  **Note** On CyberSource through VisaNet, the value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR6 - Position: 94 - Field: Mastercard Mobile Remote Payment Program Indicator  The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant's acquirer, who uses this information to facilitate end-of-day clearing processing with payment networks. ")
  public String getMobileRemotePaymentType() {
    return mobileRemotePaymentType;
  }

  public void setMobileRemotePaymentType(String mobileRemotePaymentType) {
    this.mobileRemotePaymentType = mobileRemotePaymentType;
  }

  public Ptsv2paymentsProcessingInformation extendedCreditTotalCount(String extendedCreditTotalCount) {
    this.extendedCreditTotalCount = extendedCreditTotalCount;
    return this;
  }

   /**
   * A private national-use field submitted by acquirers and issuers in South Africa for South Africa-domestic (intra-country) authorizations and financial requests. Values for this field are 00 through 99. 
   * @return extendedCreditTotalCount
  **/
  @ApiModelProperty(value = "A private national-use field submitted by acquirers and issuers in South Africa for South Africa-domestic (intra-country) authorizations and financial requests. Values for this field are 00 through 99. ")
  public String getExtendedCreditTotalCount() {
    return extendedCreditTotalCount;
  }

  public void setExtendedCreditTotalCount(String extendedCreditTotalCount) {
    this.extendedCreditTotalCount = extendedCreditTotalCount;
  }

  public Ptsv2paymentsProcessingInformation networkRoutingOrder(String networkRoutingOrder) {
    this.networkRoutingOrder = networkRoutingOrder;
    return this;
  }

   /**
   * On PIN Debit Gateways: This U.S.-only field is optionally used by  participants (merchants and acquirers) to specify the network access priority. VisaNet checks to determine if there are issuer routing preferences for any of the networks specified by the sharing group code. If an issuer preference exists for one of the specified debit networks, VisaNet makes a routing selection based on the issuer&#39;s preference. If an issuer preference exists for more than one of the specified debit networks, or if no issuer preference exists, VisaNet makes a selection based on the acquirer&#39;s routing priorities.  #### PIN debit Priority order of the networks through which he transaction will be routed. Set this value to a series of one-character network codes in your preferred order. This is a list of the network codes:  | Network | Code | | --- | --- | | Accel | E | | AFFN | U | | Alaska Option | 3 | | CU24 | C | | Interlink | G | | Maestro | 8 | | NETS | P | | NYCE | F | | Pulse | H | | Shazam | 7 | | Star | M | | Visa | V |  For example, if the Star network is your first preference and Pulse is your second preference, set this field to a value of &#x60;MH&#x60;.  When you do not include this value in your PIN debit request, the list of network codes from your account is used. **Note** This field is supported only for businesses located in the U.S.  Optional field for PIN debit credit or PIN debit purchase. 
   * @return networkRoutingOrder
  **/
  @ApiModelProperty(value = "On PIN Debit Gateways: This U.S.-only field is optionally used by  participants (merchants and acquirers) to specify the network access priority. VisaNet checks to determine if there are issuer routing preferences for any of the networks specified by the sharing group code. If an issuer preference exists for one of the specified debit networks, VisaNet makes a routing selection based on the issuer's preference. If an issuer preference exists for more than one of the specified debit networks, or if no issuer preference exists, VisaNet makes a selection based on the acquirer's routing priorities.  #### PIN debit Priority order of the networks through which he transaction will be routed. Set this value to a series of one-character network codes in your preferred order. This is a list of the network codes:  | Network | Code | | --- | --- | | Accel | E | | AFFN | U | | Alaska Option | 3 | | CU24 | C | | Interlink | G | | Maestro | 8 | | NETS | P | | NYCE | F | | Pulse | H | | Shazam | 7 | | Star | M | | Visa | V |  For example, if the Star network is your first preference and Pulse is your second preference, set this field to a value of `MH`.  When you do not include this value in your PIN debit request, the list of network codes from your account is used. **Note** This field is supported only for businesses located in the U.S.  Optional field for PIN debit credit or PIN debit purchase. ")
  public String getNetworkRoutingOrder() {
    return networkRoutingOrder;
  }

  public void setNetworkRoutingOrder(String networkRoutingOrder) {
    this.networkRoutingOrder = networkRoutingOrder;
  }

  public Ptsv2paymentsProcessingInformation payByPointsIndicator(Boolean payByPointsIndicator) {
    this.payByPointsIndicator = payByPointsIndicator;
    return this;
  }

   /**
   * Flag that indicates if the transaction is pay by points transaction true: Transaction uses loyalty points false: Transaction does not use loyalty points Default: false 
   * @return payByPointsIndicator
  **/
  @ApiModelProperty(value = "Flag that indicates if the transaction is pay by points transaction true: Transaction uses loyalty points false: Transaction does not use loyalty points Default: false ")
  public Boolean isPayByPointsIndicator() {
    return payByPointsIndicator;
  }

  public void setPayByPointsIndicator(Boolean payByPointsIndicator) {
    this.payByPointsIndicator = payByPointsIndicator;
  }

  public Ptsv2paymentsProcessingInformation timeout(Integer timeout) {
    this.timeout = timeout;
    return this;
  }

   /**
   * Minutes until a pending MyBank transaction will be timed out. Value must be between 5 and 30. Default is 5. 
   * @return timeout
  **/
  @ApiModelProperty(value = "Minutes until a pending MyBank transaction will be timed out. Value must be between 5 and 30. Default is 5. ")
  public Integer getTimeout() {
    return timeout;
  }

  public void setTimeout(Integer timeout) {
    this.timeout = timeout;
  }

  public Ptsv2paymentsProcessingInformation isReturnAuthRecordEnabled(Boolean isReturnAuthRecordEnabled) {
    this.isReturnAuthRecordEnabled = isReturnAuthRecordEnabled;
    return this;
  }

   /**
   * Flag that indicates the functionality we are having for merchants for which auth is done through Cybersource but settlement is done by themselves. true: functionality is supported. Processor should send raw processor auth response to Merchant. false: functionality is not supported. Default: false 
   * @return isReturnAuthRecordEnabled
  **/
  @ApiModelProperty(value = "Flag that indicates the functionality we are having for merchants for which auth is done through Cybersource but settlement is done by themselves. true: functionality is supported. Processor should send raw processor auth response to Merchant. false: functionality is not supported. Default: false ")
  public Boolean isIsReturnAuthRecordEnabled() {
    return isReturnAuthRecordEnabled;
  }

  public void setIsReturnAuthRecordEnabled(Boolean isReturnAuthRecordEnabled) {
    this.isReturnAuthRecordEnabled = isReturnAuthRecordEnabled;
  }

  public Ptsv2paymentsProcessingInformation networkPartnerId(String networkPartnerId) {
    this.networkPartnerId = networkPartnerId;
    return this;
  }

   /**
   * Merchant payment gateway ID that is assigned by Mastercard and is provided by the acquirer when a registered merchant payment gateway service provider is involved in the transaction.  This field is supported for Visa Platform Connect. 
   * @return networkPartnerId
  **/
  @ApiModelProperty(value = "Merchant payment gateway ID that is assigned by Mastercard and is provided by the acquirer when a registered merchant payment gateway service provider is involved in the transaction.  This field is supported for Visa Platform Connect. ")
  public String getNetworkPartnerId() {
    return networkPartnerId;
  }

  public void setNetworkPartnerId(String networkPartnerId) {
    this.networkPartnerId = networkPartnerId;
  }

  public Ptsv2paymentsProcessingInformation paymentType(String paymentType) {
    this.paymentType = paymentType;
    return this;
  }

   /**
   * Identifier for the payment type. 
   * @return paymentType
  **/
  @ApiModelProperty(value = "Identifier for the payment type. ")
  public String getPaymentType() {
    return paymentType;
  }

  public void setPaymentType(String paymentType) {
    this.paymentType = paymentType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Ptsv2paymentsProcessingInformation ptsv2paymentsProcessingInformation = (Ptsv2paymentsProcessingInformation) o;
    return Objects.equals(this.actionList, ptsv2paymentsProcessingInformation.actionList) &&
        Objects.equals(this.enableEscrowOption, ptsv2paymentsProcessingInformation.enableEscrowOption) &&
        Objects.equals(this.actionTokenTypes, ptsv2paymentsProcessingInformation.actionTokenTypes) &&
        Objects.equals(this.binSource, ptsv2paymentsProcessingInformation.binSource) &&
        Objects.equals(this.capture, ptsv2paymentsProcessingInformation.capture) &&
        Objects.equals(this.processorId, ptsv2paymentsProcessingInformation.processorId) &&
        Objects.equals(this.businessApplicationId, ptsv2paymentsProcessingInformation.businessApplicationId) &&
        Objects.equals(this.commerceIndicator, ptsv2paymentsProcessingInformation.commerceIndicator) &&
        Objects.equals(this.commerceIndicatorLabel, ptsv2paymentsProcessingInformation.commerceIndicatorLabel) &&
        Objects.equals(this.paymentSolution, ptsv2paymentsProcessingInformation.paymentSolution) &&
        Objects.equals(this.reconciliationId, ptsv2paymentsProcessingInformation.reconciliationId) &&
        Objects.equals(this.linkId, ptsv2paymentsProcessingInformation.linkId) &&
        Objects.equals(this.purchaseLevel, ptsv2paymentsProcessingInformation.purchaseLevel) &&
        Objects.equals(this.transactionTimeout, ptsv2paymentsProcessingInformation.transactionTimeout) &&
        Objects.equals(this.intentsId, ptsv2paymentsProcessingInformation.intentsId) &&
        Objects.equals(this.paymentId, ptsv2paymentsProcessingInformation.paymentId) &&
        Objects.equals(this.reportGroup, ptsv2paymentsProcessingInformation.reportGroup) &&
        Objects.equals(this.visaCheckoutId, ptsv2paymentsProcessingInformation.visaCheckoutId) &&
        Objects.equals(this.industryDataType, ptsv2paymentsProcessingInformation.industryDataType) &&
        Objects.equals(this.authorizationOptions, ptsv2paymentsProcessingInformation.authorizationOptions) &&
        Objects.equals(this.captureOptions, ptsv2paymentsProcessingInformation.captureOptions) &&
        Objects.equals(this.recurringOptions, ptsv2paymentsProcessingInformation.recurringOptions) &&
        Objects.equals(this.bankTransferOptions, ptsv2paymentsProcessingInformation.bankTransferOptions) &&
        Objects.equals(this.purchaseOptions, ptsv2paymentsProcessingInformation.purchaseOptions) &&
        Objects.equals(this.electronicBenefitsTransfer, ptsv2paymentsProcessingInformation.electronicBenefitsTransfer) &&
        Objects.equals(this.loanOptions, ptsv2paymentsProcessingInformation.loanOptions) &&
        Objects.equals(this.walletType, ptsv2paymentsProcessingInformation.walletType) &&
        Objects.equals(this.nationalNetDomesticData, ptsv2paymentsProcessingInformation.nationalNetDomesticData) &&
        Objects.equals(this.japanPaymentOptions, ptsv2paymentsProcessingInformation.japanPaymentOptions) &&
        Objects.equals(this.mobileRemotePaymentType, ptsv2paymentsProcessingInformation.mobileRemotePaymentType) &&
        Objects.equals(this.extendedCreditTotalCount, ptsv2paymentsProcessingInformation.extendedCreditTotalCount) &&
        Objects.equals(this.networkRoutingOrder, ptsv2paymentsProcessingInformation.networkRoutingOrder) &&
        Objects.equals(this.payByPointsIndicator, ptsv2paymentsProcessingInformation.payByPointsIndicator) &&
        Objects.equals(this.timeout, ptsv2paymentsProcessingInformation.timeout) &&
        Objects.equals(this.isReturnAuthRecordEnabled, ptsv2paymentsProcessingInformation.isReturnAuthRecordEnabled) &&
        Objects.equals(this.networkPartnerId, ptsv2paymentsProcessingInformation.networkPartnerId) &&
        Objects.equals(this.paymentType, ptsv2paymentsProcessingInformation.paymentType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(actionList, enableEscrowOption, actionTokenTypes, binSource, capture, processorId, businessApplicationId, commerceIndicator, commerceIndicatorLabel, paymentSolution, reconciliationId, linkId, purchaseLevel, transactionTimeout, intentsId, paymentId, reportGroup, visaCheckoutId, industryDataType, authorizationOptions, captureOptions, recurringOptions, bankTransferOptions, purchaseOptions, electronicBenefitsTransfer, loanOptions, walletType, nationalNetDomesticData, japanPaymentOptions, mobileRemotePaymentType, extendedCreditTotalCount, networkRoutingOrder, payByPointsIndicator, timeout, isReturnAuthRecordEnabled, networkPartnerId, paymentType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Ptsv2paymentsProcessingInformation {\n");
    
    sb.append("    actionList: ").append(toIndentedString(actionList)).append("\n");
    sb.append("    enableEscrowOption: ").append(toIndentedString(enableEscrowOption)).append("\n");
    sb.append("    actionTokenTypes: ").append(toIndentedString(actionTokenTypes)).append("\n");
    sb.append("    binSource: ").append(toIndentedString(binSource)).append("\n");
    sb.append("    capture: ").append(toIndentedString(capture)).append("\n");
    sb.append("    processorId: ").append(toIndentedString(processorId)).append("\n");
    sb.append("    businessApplicationId: ").append(toIndentedString(businessApplicationId)).append("\n");
    sb.append("    commerceIndicator: ").append(toIndentedString(commerceIndicator)).append("\n");
    sb.append("    commerceIndicatorLabel: ").append(toIndentedString(commerceIndicatorLabel)).append("\n");
    sb.append("    paymentSolution: ").append(toIndentedString(paymentSolution)).append("\n");
    sb.append("    reconciliationId: ").append(toIndentedString(reconciliationId)).append("\n");
    sb.append("    linkId: ").append(toIndentedString(linkId)).append("\n");
    sb.append("    purchaseLevel: ").append(toIndentedString(purchaseLevel)).append("\n");
    sb.append("    transactionTimeout: ").append(toIndentedString(transactionTimeout)).append("\n");
    sb.append("    intentsId: ").append(toIndentedString(intentsId)).append("\n");
    sb.append("    paymentId: ").append(toIndentedString(paymentId)).append("\n");
    sb.append("    reportGroup: ").append(toIndentedString(reportGroup)).append("\n");
    sb.append("    visaCheckoutId: ").append(toIndentedString(visaCheckoutId)).append("\n");
    sb.append("    industryDataType: ").append(toIndentedString(industryDataType)).append("\n");
    sb.append("    authorizationOptions: ").append(toIndentedString(authorizationOptions)).append("\n");
    sb.append("    captureOptions: ").append(toIndentedString(captureOptions)).append("\n");
    sb.append("    recurringOptions: ").append(toIndentedString(recurringOptions)).append("\n");
    sb.append("    bankTransferOptions: ").append(toIndentedString(bankTransferOptions)).append("\n");
    sb.append("    purchaseOptions: ").append(toIndentedString(purchaseOptions)).append("\n");
    sb.append("    electronicBenefitsTransfer: ").append(toIndentedString(electronicBenefitsTransfer)).append("\n");
    sb.append("    loanOptions: ").append(toIndentedString(loanOptions)).append("\n");
    sb.append("    walletType: ").append(toIndentedString(walletType)).append("\n");
    sb.append("    nationalNetDomesticData: ").append(toIndentedString(nationalNetDomesticData)).append("\n");
    sb.append("    japanPaymentOptions: ").append(toIndentedString(japanPaymentOptions)).append("\n");
    sb.append("    mobileRemotePaymentType: ").append(toIndentedString(mobileRemotePaymentType)).append("\n");
    sb.append("    extendedCreditTotalCount: ").append(toIndentedString(extendedCreditTotalCount)).append("\n");
    sb.append("    networkRoutingOrder: ").append(toIndentedString(networkRoutingOrder)).append("\n");
    sb.append("    payByPointsIndicator: ").append(toIndentedString(payByPointsIndicator)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("    isReturnAuthRecordEnabled: ").append(toIndentedString(isReturnAuthRecordEnabled)).append("\n");
    sb.append("    networkPartnerId: ").append(toIndentedString(networkPartnerId)).append("\n");
    sb.append("    paymentType: ").append(toIndentedString(paymentType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

