/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Model;

import java.util.Objects;
import java.util.Arrays;
import Model.InlineResponse2011IntegrationInformation;
import Model.InlineResponse2011OrganizationInformation;
import Model.InlineResponse2011ProductInformationSetups;
import Model.InlineResponse2011RegistrationInformation;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDate;

/**
 * InlineResponse2011
 */

public class InlineResponse2011 {
  @SerializedName("id")
  private String id = null;

  @SerializedName("submitTimeUtc")
  private LocalDate submitTimeUtc = null;

  /**
   * The status of Registration request Possible Values:   - &#39;INITIALIZED&#39;   - &#39;RECEIVED&#39;   - &#39;PROCESSING&#39;   - &#39;SUCCESS&#39;   - &#39;FAILURE&#39;   - &#39;PARTIAL&#39; 
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    INITIALIZED("INITIALIZED"),
    
    RECEIVED("RECEIVED"),
    
    PROCESSING("PROCESSING"),
    
    SUCCESS("SUCCESS"),
    
    FAILURE("FAILURE"),
    
    PARTIAL("PARTIAL");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return StatusEnum.fromValue(String.valueOf(value));
      }
    }
  }
  @SerializedName("status")
  private StatusEnum status = null;

  @SerializedName("registrationInformation")
  private InlineResponse2011RegistrationInformation registrationInformation = null;

  @SerializedName("integrationInformation")
  private InlineResponse2011IntegrationInformation integrationInformation = null;

  @SerializedName("organizationInformation")
  private InlineResponse2011OrganizationInformation organizationInformation = null;

  @SerializedName("productInformationSetups")
  private List<InlineResponse2011ProductInformationSetups> productInformationSetups = null;

  @SerializedName("message")
  private String message = null;

  @SerializedName("details")
  private Map<String, List<Object>> details = null;

  public InlineResponse2011 id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(example = "12351234", value = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public InlineResponse2011 submitTimeUtc(LocalDate submitTimeUtc) {
    this.submitTimeUtc = submitTimeUtc;
    return this;
  }

   /**
   * Time of request in UTC. &#x60;Format: YYYY-MM-DDThh:mm:ssZ&#x60;  Example 2016-08-11T22:47:57Z equals August 11, 2016, at 22:47:57 (10:47:57 p.m.). The T separates the date and the time. The Z indicates UTC. 
   * @return submitTimeUtc
  **/
  @ApiModelProperty(example = "2019-06-11T22:47:57.000Z", value = "Time of request in UTC. `Format: YYYY-MM-DDThh:mm:ssZ`  Example 2016-08-11T22:47:57Z equals August 11, 2016, at 22:47:57 (10:47:57 p.m.). The T separates the date and the time. The Z indicates UTC. ")
  public LocalDate getSubmitTimeUtc() {
    return submitTimeUtc;
  }

  public void setSubmitTimeUtc(LocalDate submitTimeUtc) {
    this.submitTimeUtc = submitTimeUtc;
  }

   /**
   * The status of Registration request Possible Values:   - &#39;INITIALIZED&#39;   - &#39;RECEIVED&#39;   - &#39;PROCESSING&#39;   - &#39;SUCCESS&#39;   - &#39;FAILURE&#39;   - &#39;PARTIAL&#39; 
   * @return status
  **/
  @ApiModelProperty(value = "The status of Registration request Possible Values:   - 'INITIALIZED'   - 'RECEIVED'   - 'PROCESSING'   - 'SUCCESS'   - 'FAILURE'   - 'PARTIAL' ")
  public StatusEnum getStatus() {
    return status;
  }

  public InlineResponse2011 registrationInformation(InlineResponse2011RegistrationInformation registrationInformation) {
    this.registrationInformation = registrationInformation;
    return this;
  }

   /**
   * Get registrationInformation
   * @return registrationInformation
  **/
  @ApiModelProperty(value = "")
  public InlineResponse2011RegistrationInformation getRegistrationInformation() {
    return registrationInformation;
  }

  public void setRegistrationInformation(InlineResponse2011RegistrationInformation registrationInformation) {
    this.registrationInformation = registrationInformation;
  }

  public InlineResponse2011 integrationInformation(InlineResponse2011IntegrationInformation integrationInformation) {
    this.integrationInformation = integrationInformation;
    return this;
  }

   /**
   * Get integrationInformation
   * @return integrationInformation
  **/
  @ApiModelProperty(value = "")
  public InlineResponse2011IntegrationInformation getIntegrationInformation() {
    return integrationInformation;
  }

  public void setIntegrationInformation(InlineResponse2011IntegrationInformation integrationInformation) {
    this.integrationInformation = integrationInformation;
  }

  public InlineResponse2011 organizationInformation(InlineResponse2011OrganizationInformation organizationInformation) {
    this.organizationInformation = organizationInformation;
    return this;
  }

   /**
   * Get organizationInformation
   * @return organizationInformation
  **/
  @ApiModelProperty(value = "")
  public InlineResponse2011OrganizationInformation getOrganizationInformation() {
    return organizationInformation;
  }

  public void setOrganizationInformation(InlineResponse2011OrganizationInformation organizationInformation) {
    this.organizationInformation = organizationInformation;
  }

  public InlineResponse2011 productInformationSetups(List<InlineResponse2011ProductInformationSetups> productInformationSetups) {
    this.productInformationSetups = productInformationSetups;
    return this;
  }

  public InlineResponse2011 addProductInformationSetupsItem(InlineResponse2011ProductInformationSetups productInformationSetupsItem) {
    if (this.productInformationSetups == null) {
      this.productInformationSetups = new ArrayList<InlineResponse2011ProductInformationSetups>();
    }
    this.productInformationSetups.add(productInformationSetupsItem);
    return this;
  }

   /**
   * Get productInformationSetups
   * @return productInformationSetups
  **/
  @ApiModelProperty(value = "")
  public List<InlineResponse2011ProductInformationSetups> getProductInformationSetups() {
    return productInformationSetups;
  }

  public void setProductInformationSetups(List<InlineResponse2011ProductInformationSetups> productInformationSetups) {
    this.productInformationSetups = productInformationSetups;
  }

  public InlineResponse2011 message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @ApiModelProperty(example = "Request was processed succesfully.", value = "")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public InlineResponse2011 details(Map<String, List<Object>> details) {
    this.details = details;
    return this;
  }

  public InlineResponse2011 putDetailsItem(String key, List<Object> detailsItem) {
    if (this.details == null) {
      this.details = new HashMap<String, List<Object>>();
    }
    this.details.put(key, detailsItem);
    return this;
  }

   /**
   * Get details
   * @return details
  **/
  @ApiModelProperty(value = "")
  public Map<String, List<Object>> getDetails() {
    return details;
  }

  public void setDetails(Map<String, List<Object>> details) {
    this.details = details;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InlineResponse2011 inlineResponse2011 = (InlineResponse2011) o;
    return Objects.equals(this.id, inlineResponse2011.id) &&
        Objects.equals(this.submitTimeUtc, inlineResponse2011.submitTimeUtc) &&
        Objects.equals(this.status, inlineResponse2011.status) &&
        Objects.equals(this.registrationInformation, inlineResponse2011.registrationInformation) &&
        Objects.equals(this.integrationInformation, inlineResponse2011.integrationInformation) &&
        Objects.equals(this.organizationInformation, inlineResponse2011.organizationInformation) &&
        Objects.equals(this.productInformationSetups, inlineResponse2011.productInformationSetups) &&
        Objects.equals(this.message, inlineResponse2011.message) &&
        Objects.equals(this.details, inlineResponse2011.details);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, submitTimeUtc, status, registrationInformation, integrationInformation, organizationInformation, productInformationSetups, message, details);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InlineResponse2011 {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    submitTimeUtc: ").append(toIndentedString(submitTimeUtc)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    registrationInformation: ").append(toIndentedString(registrationInformation)).append("\n");
    sb.append("    integrationInformation: ").append(toIndentedString(integrationInformation)).append("\n");
    sb.append("    organizationInformation: ").append(toIndentedString(organizationInformation)).append("\n");
    sb.append("    productInformationSetups: ").append(toIndentedString(productInformationSetups)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

