/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Model;

import java.util.Objects;
import java.util.Arrays;
import Model.CardProcessingConfigCommonMerchantDescriptorInformation;
import Model.CardProcessingConfigCommonProcessors;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * CardProcessingConfigCommon
 */

public class CardProcessingConfigCommon {
  @SerializedName("processors")
  private Map<String, CardProcessingConfigCommonProcessors> processors = null;

  @SerializedName("amexVendorCode")
  private String amexVendorCode = null;

  /**
   * Authorization Finality indicator. Please note that the input can be in small case or capitals but response is in small case as of now. It will be made capitals everywhere in the next version. Applicable for Elavon Americas (elavonamericas), TSYS (tsys), Barclays (barclays2), Streamline (streamline2), Six (six), Barclays HISO (barclayshiso), GPN (gpn), FDI Global (fdiglobal), GPX (gpx), Paymentech Tampa (paymentechtampa), FDC Nashville (smartfdc), VPC and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Default Value&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;Barclays&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;FINAL&lt;/td&gt;&lt;/tr&gt; &lt;tr&gt;&lt;td&gt;Barclays HISO&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;Yes&lt;/td&gt;&lt;td&gt;FINAL&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   */
  @JsonAdapter(DefaultAuthTypeCodeEnum.Adapter.class)
  public enum DefaultAuthTypeCodeEnum {
    PRE("PRE"),
    
    FINAL("FINAL"),
    
    UNDEFINED("UNDEFINED");

    private String value;

    DefaultAuthTypeCodeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DefaultAuthTypeCodeEnum fromValue(String text) {
      for (DefaultAuthTypeCodeEnum b : DefaultAuthTypeCodeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<DefaultAuthTypeCodeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DefaultAuthTypeCodeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DefaultAuthTypeCodeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return DefaultAuthTypeCodeEnum.fromValue(String.valueOf(value));
      }
    }
  }
  @SerializedName("defaultAuthTypeCode")
  private DefaultAuthTypeCodeEnum defaultAuthTypeCode = null;

  @SerializedName("masterCardAssignedId")
  private String masterCardAssignedId = null;

  @SerializedName("enablePartialAuth")
  private Boolean enablePartialAuth = null;

  @SerializedName("merchantCategoryCode")
  private String merchantCategoryCode = null;

  @SerializedName("sicCode")
  private String sicCode = null;

  @SerializedName("foodAndConsumerServiceId")
  private String foodAndConsumerServiceId = null;

  @SerializedName("enableSplitShipment")
  private Boolean enableSplitShipment = null;

  @SerializedName("enableInterchangeOptimization")
  private Boolean enableInterchangeOptimization = null;

  @SerializedName("visaDelegatedAuthenticationId")
  private String visaDelegatedAuthenticationId = null;

  @SerializedName("creditCardRefundLimitPercent")
  private String creditCardRefundLimitPercent = null;

  @SerializedName("businessCenterCreditCardRefundLimitPercent")
  private String businessCenterCreditCardRefundLimitPercent = null;

  @SerializedName("allowCapturesGreaterThanAuthorizations")
  private Boolean allowCapturesGreaterThanAuthorizations = null;

  @SerializedName("enableDuplicateMerchantReferenceNumberBlocking")
  private Boolean enableDuplicateMerchantReferenceNumberBlocking = null;

  @SerializedName("domesticMerchantId")
  private Boolean domesticMerchantId = null;

  @SerializedName("processLevel3Data")
  private String processLevel3Data = null;

  @SerializedName("subMerchantId")
  private String subMerchantId = null;

  @SerializedName("subMerchantBusinessName")
  private String subMerchantBusinessName = null;

  @SerializedName("preferCobadgedSecondaryBrand")
  private Boolean preferCobadgedSecondaryBrand = null;

  @SerializedName("merchantDescriptorInformation")
  private CardProcessingConfigCommonMerchantDescriptorInformation merchantDescriptorInformation = null;

  public CardProcessingConfigCommon processors(Map<String, CardProcessingConfigCommonProcessors> processors) {
    this.processors = processors;
    return this;
  }

  public CardProcessingConfigCommon putProcessorsItem(String key, CardProcessingConfigCommonProcessors processorsItem) {
    if (this.processors == null) {
      this.processors = new HashMap<String, CardProcessingConfigCommonProcessors>();
    }
    this.processors.put(key, processorsItem);
    return this;
  }

   /**
   * e.g. * amexdirect * barclays2 * CUP * EFTPOS * fdiglobal * gpngsapv3 * gpx * smartfdc * tsys * vero * VPC  For VPC, CUP and EFTPOS processors, replace the processor name from VPC or CUP or EFTPOS to the actual processor name in the sample request. e.g. replace VPC with &amp;lt;your vpc processor&amp;gt; 
   * @return processors
  **/
  @ApiModelProperty(value = "e.g. * amexdirect * barclays2 * CUP * EFTPOS * fdiglobal * gpngsapv3 * gpx * smartfdc * tsys * vero * VPC  For VPC, CUP and EFTPOS processors, replace the processor name from VPC or CUP or EFTPOS to the actual processor name in the sample request. e.g. replace VPC with &lt;your vpc processor&gt; ")
  public Map<String, CardProcessingConfigCommonProcessors> getProcessors() {
    return processors;
  }

  public void setProcessors(Map<String, CardProcessingConfigCommonProcessors> processors) {
    this.processors = processors;
  }

  public CardProcessingConfigCommon amexVendorCode(String amexVendorCode) {
    this.amexVendorCode = amexVendorCode;
    return this;
  }

   /**
   * Vendor code assigned by American Express. Applicable for TSYS (tsys) processor.
   * @return amexVendorCode
  **/
  @ApiModelProperty(value = "Vendor code assigned by American Express. Applicable for TSYS (tsys) processor.")
  public String getAmexVendorCode() {
    return amexVendorCode;
  }

  public void setAmexVendorCode(String amexVendorCode) {
    this.amexVendorCode = amexVendorCode;
  }

  public CardProcessingConfigCommon defaultAuthTypeCode(DefaultAuthTypeCodeEnum defaultAuthTypeCode) {
    this.defaultAuthTypeCode = defaultAuthTypeCode;
    return this;
  }

   /**
   * Authorization Finality indicator. Please note that the input can be in small case or capitals but response is in small case as of now. It will be made capitals everywhere in the next version. Applicable for Elavon Americas (elavonamericas), TSYS (tsys), Barclays (barclays2), Streamline (streamline2), Six (six), Barclays HISO (barclayshiso), GPN (gpn), FDI Global (fdiglobal), GPX (gpx), Paymentech Tampa (paymentechtampa), FDC Nashville (smartfdc), VPC and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Default Value&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;Barclays&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;FINAL&lt;/td&gt;&lt;/tr&gt; &lt;tr&gt;&lt;td&gt;Barclays HISO&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;Yes&lt;/td&gt;&lt;td&gt;FINAL&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return defaultAuthTypeCode
  **/
  @ApiModelProperty(value = "Authorization Finality indicator. Please note that the input can be in small case or capitals but response is in small case as of now. It will be made capitals everywhere in the next version. Applicable for Elavon Americas (elavonamericas), TSYS (tsys), Barclays (barclays2), Streamline (streamline2), Six (six), Barclays HISO (barclayshiso), GPN (gpn), FDI Global (fdiglobal), GPX (gpx), Paymentech Tampa (paymentechtampa), FDC Nashville (smartfdc), VPC and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>FINAL</td></tr> <tr><td>Barclays HISO</td><td>cnp, cp, hybrid</td><td>Yes</td><td>FINAL</td></tr> </table> ")
  public DefaultAuthTypeCodeEnum getDefaultAuthTypeCode() {
    return defaultAuthTypeCode;
  }

  public void setDefaultAuthTypeCode(DefaultAuthTypeCodeEnum defaultAuthTypeCode) {
    this.defaultAuthTypeCode = defaultAuthTypeCode;
  }

  public CardProcessingConfigCommon masterCardAssignedId(String masterCardAssignedId) {
    this.masterCardAssignedId = masterCardAssignedId;
    return this;
  }

   /**
   * MAID aka MasterCard assigned ID, MasterCard equivalent of Merchant Verification Value by Visa. Applicable for VPC, GPX (gpx) and FDI Global (fdiglobal) processors.
   * @return masterCardAssignedId
  **/
  @ApiModelProperty(value = "MAID aka MasterCard assigned ID, MasterCard equivalent of Merchant Verification Value by Visa. Applicable for VPC, GPX (gpx) and FDI Global (fdiglobal) processors.")
  public String getMasterCardAssignedId() {
    return masterCardAssignedId;
  }

  public void setMasterCardAssignedId(String masterCardAssignedId) {
    this.masterCardAssignedId = masterCardAssignedId;
  }

  public CardProcessingConfigCommon enablePartialAuth(Boolean enablePartialAuth) {
    this.enablePartialAuth = enablePartialAuth;
    return this;
  }

   /**
   * Allow merchants to accept partial authorization approvals. Applicable for Elavon Americas (elavonamericas), VPC, GPX (gpx), FDI Global (fdiglobal), FDC Nashville (smartfdc), GPN (gpn), TSYS (tsys), American Express Direct (amexdirect), Paymentech Tampa (paymentechtampa) and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Default Value&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return enablePartialAuth
  **/
  @ApiModelProperty(value = "Allow merchants to accept partial authorization approvals. Applicable for Elavon Americas (elavonamericas), VPC, GPX (gpx), FDI Global (fdiglobal), FDC Nashville (smartfdc), GPN (gpn), TSYS (tsys), American Express Direct (amexdirect), Paymentech Tampa (paymentechtampa) and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>No</td></tr> </table> ")
  public Boolean isEnablePartialAuth() {
    return enablePartialAuth;
  }

  public void setEnablePartialAuth(Boolean enablePartialAuth) {
    this.enablePartialAuth = enablePartialAuth;
  }

  public CardProcessingConfigCommon merchantCategoryCode(String merchantCategoryCode) {
    this.merchantCategoryCode = merchantCategoryCode;
    return this;
  }

   /**
   * Indicates type of business product or service of the merchant. Applicable for Chase Paymentech Salem (chasepaymentechsalem), FDI Global (fdiglobal), RUPAY, Elavon Americas (elavonamericas), American Express Direct (amexdirect), CMCIC (cmcic), GPX (gpx), VPC, TSYS (tsys), EFTPOS, CUP, Paymentech Tampa (paymentechtampa), CB2A, Barclays (barclays2), Prisma (prisma) and GPN (gpn) processors.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Min. Length&lt;/th&gt;&lt;th&gt;Max. Length&lt;/th&gt;&lt;th&gt;Regex&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;Barclays&lt;/td&gt;&lt;td&gt;cnp&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;4&lt;/td&gt;&lt;td&gt;4&lt;/td&gt;&lt;td&gt;^[0-9]+$&lt;/td&gt;&lt;/tr&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;Yes&lt;/td&gt;&lt;td&gt;4&lt;/td&gt;&lt;td&gt;4&lt;/td&gt;&lt;td&gt;^[0-9]+$&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return merchantCategoryCode
  **/
  @ApiModelProperty(value = "Indicates type of business product or service of the merchant. Applicable for Chase Paymentech Salem (chasepaymentechsalem), FDI Global (fdiglobal), RUPAY, Elavon Americas (elavonamericas), American Express Direct (amexdirect), CMCIC (cmcic), GPX (gpx), VPC, TSYS (tsys), EFTPOS, CUP, Paymentech Tampa (paymentechtampa), CB2A, Barclays (barclays2), Prisma (prisma) and GPN (gpn) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays</td><td>cnp</td><td>No</td><td>4</td><td>4</td><td>^[0-9]+$</td></tr> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>4</td><td>4</td><td>^[0-9]+$</td></tr> </table> ")
  public String getMerchantCategoryCode() {
    return merchantCategoryCode;
  }

  public void setMerchantCategoryCode(String merchantCategoryCode) {
    this.merchantCategoryCode = merchantCategoryCode;
  }

  public CardProcessingConfigCommon sicCode(String sicCode) {
    this.sicCode = sicCode;
    return this;
  }

   /**
   * The Standard Industrial Classification (SIC) are four-digit codes that categorize the industries that companies belong to based on their business activities. Standard Industrial Classification codes were mostly replaced by the six-digit North American Industry Classification System (NAICS). Applicable for VPC and GPX (gpx) processors.
   * @return sicCode
  **/
  @ApiModelProperty(value = "The Standard Industrial Classification (SIC) are four-digit codes that categorize the industries that companies belong to based on their business activities. Standard Industrial Classification codes were mostly replaced by the six-digit North American Industry Classification System (NAICS). Applicable for VPC and GPX (gpx) processors.")
  public String getSicCode() {
    return sicCode;
  }

  public void setSicCode(String sicCode) {
    this.sicCode = sicCode;
  }

  public CardProcessingConfigCommon foodAndConsumerServiceId(String foodAndConsumerServiceId) {
    this.foodAndConsumerServiceId = foodAndConsumerServiceId;
    return this;
  }

   /**
   * Food and Consumer Service ID. Identifies the merchant as being certified and approved to accept Food Stamps. Applicable for GPX (gpx) processor.
   * @return foodAndConsumerServiceId
  **/
  @ApiModelProperty(value = "Food and Consumer Service ID. Identifies the merchant as being certified and approved to accept Food Stamps. Applicable for GPX (gpx) processor.")
  public String getFoodAndConsumerServiceId() {
    return foodAndConsumerServiceId;
  }

  public void setFoodAndConsumerServiceId(String foodAndConsumerServiceId) {
    this.foodAndConsumerServiceId = foodAndConsumerServiceId;
  }

  public CardProcessingConfigCommon enableSplitShipment(Boolean enableSplitShipment) {
    this.enableSplitShipment = enableSplitShipment;
    return this;
  }

   /**
   * Enables you to split an order into multiple shipments with multiple captures. This feature is provided by CyberSource and supports three different scenarios:  * multiple authorizations * multiple captures * multiple authorizations with multiple captures  Applicable for VPC processors. 
   * @return enableSplitShipment
  **/
  @ApiModelProperty(value = "Enables you to split an order into multiple shipments with multiple captures. This feature is provided by CyberSource and supports three different scenarios:  * multiple authorizations * multiple captures * multiple authorizations with multiple captures  Applicable for VPC processors. ")
  public Boolean isEnableSplitShipment() {
    return enableSplitShipment;
  }

  public void setEnableSplitShipment(Boolean enableSplitShipment) {
    this.enableSplitShipment = enableSplitShipment;
  }

  public CardProcessingConfigCommon enableInterchangeOptimization(Boolean enableInterchangeOptimization) {
    this.enableInterchangeOptimization = enableInterchangeOptimization;
    return this;
  }

   /**
   * Reduces your interchange fees by using automatic authorization refresh and automatic partial authorization reversal. Applicable for VPC processors.
   * @return enableInterchangeOptimization
  **/
  @ApiModelProperty(value = "Reduces your interchange fees by using automatic authorization refresh and automatic partial authorization reversal. Applicable for VPC processors.")
  public Boolean isEnableInterchangeOptimization() {
    return enableInterchangeOptimization;
  }

  public void setEnableInterchangeOptimization(Boolean enableInterchangeOptimization) {
    this.enableInterchangeOptimization = enableInterchangeOptimization;
  }

  public CardProcessingConfigCommon visaDelegatedAuthenticationId(String visaDelegatedAuthenticationId) {
    this.visaDelegatedAuthenticationId = visaDelegatedAuthenticationId;
    return this;
  }

   /**
   * Identifier provided to merchants who opt for Visa&#39;s delegated authorization program. Applicable for VPC processors.
   * @return visaDelegatedAuthenticationId
  **/
  @ApiModelProperty(value = "Identifier provided to merchants who opt for Visa's delegated authorization program. Applicable for VPC processors.")
  public String getVisaDelegatedAuthenticationId() {
    return visaDelegatedAuthenticationId;
  }

  public void setVisaDelegatedAuthenticationId(String visaDelegatedAuthenticationId) {
    this.visaDelegatedAuthenticationId = visaDelegatedAuthenticationId;
  }

  public CardProcessingConfigCommon creditCardRefundLimitPercent(String creditCardRefundLimitPercent) {
    this.creditCardRefundLimitPercent = creditCardRefundLimitPercent;
    return this;
  }

   /**
   * Blocks over-refunds when the aggregated refund amount is higher than the percentage set for this field. Applicable for GPX (gpx), VPC and Chase Paymentech Salem (chasepaymentechsalem) processors.
   * @return creditCardRefundLimitPercent
  **/
  @ApiModelProperty(value = "Blocks over-refunds when the aggregated refund amount is higher than the percentage set for this field. Applicable for GPX (gpx), VPC and Chase Paymentech Salem (chasepaymentechsalem) processors.")
  public String getCreditCardRefundLimitPercent() {
    return creditCardRefundLimitPercent;
  }

  public void setCreditCardRefundLimitPercent(String creditCardRefundLimitPercent) {
    this.creditCardRefundLimitPercent = creditCardRefundLimitPercent;
  }

  public CardProcessingConfigCommon businessCenterCreditCardRefundLimitPercent(String businessCenterCreditCardRefundLimitPercent) {
    this.businessCenterCreditCardRefundLimitPercent = businessCenterCreditCardRefundLimitPercent;
    return this;
  }

   /**
   * Limits refunds to the percentage set in this field. Applicable for GPX (gpx) and VPC processors.
   * @return businessCenterCreditCardRefundLimitPercent
  **/
  @ApiModelProperty(value = "Limits refunds to the percentage set in this field. Applicable for GPX (gpx) and VPC processors.")
  public String getBusinessCenterCreditCardRefundLimitPercent() {
    return businessCenterCreditCardRefundLimitPercent;
  }

  public void setBusinessCenterCreditCardRefundLimitPercent(String businessCenterCreditCardRefundLimitPercent) {
    this.businessCenterCreditCardRefundLimitPercent = businessCenterCreditCardRefundLimitPercent;
  }

  public CardProcessingConfigCommon allowCapturesGreaterThanAuthorizations(Boolean allowCapturesGreaterThanAuthorizations) {
    this.allowCapturesGreaterThanAuthorizations = allowCapturesGreaterThanAuthorizations;
    return this;
  }

   /**
   * Enables this merchant account to capture amounts greater than the authorization amount. Applicable for GPX (gpx), VPC, Paymentech Tampa (paymentechtampa) and Chase Paymentech Salem (chasepaymentechsalem) processors.
   * @return allowCapturesGreaterThanAuthorizations
  **/
  @ApiModelProperty(value = "Enables this merchant account to capture amounts greater than the authorization amount. Applicable for GPX (gpx), VPC, Paymentech Tampa (paymentechtampa) and Chase Paymentech Salem (chasepaymentechsalem) processors.")
  public Boolean isAllowCapturesGreaterThanAuthorizations() {
    return allowCapturesGreaterThanAuthorizations;
  }

  public void setAllowCapturesGreaterThanAuthorizations(Boolean allowCapturesGreaterThanAuthorizations) {
    this.allowCapturesGreaterThanAuthorizations = allowCapturesGreaterThanAuthorizations;
  }

  public CardProcessingConfigCommon enableDuplicateMerchantReferenceNumberBlocking(Boolean enableDuplicateMerchantReferenceNumberBlocking) {
    this.enableDuplicateMerchantReferenceNumberBlocking = enableDuplicateMerchantReferenceNumberBlocking;
    return this;
  }

   /**
   * Helps prevent duplicate transactions. Applicable for VPC, GPX (gpx) and Chase Paymentech Salem (chasepaymentechsalem) processors.
   * @return enableDuplicateMerchantReferenceNumberBlocking
  **/
  @ApiModelProperty(value = "Helps prevent duplicate transactions. Applicable for VPC, GPX (gpx) and Chase Paymentech Salem (chasepaymentechsalem) processors.")
  public Boolean isEnableDuplicateMerchantReferenceNumberBlocking() {
    return enableDuplicateMerchantReferenceNumberBlocking;
  }

  public void setEnableDuplicateMerchantReferenceNumberBlocking(Boolean enableDuplicateMerchantReferenceNumberBlocking) {
    this.enableDuplicateMerchantReferenceNumberBlocking = enableDuplicateMerchantReferenceNumberBlocking;
  }

  public CardProcessingConfigCommon domesticMerchantId(Boolean domesticMerchantId) {
    this.domesticMerchantId = domesticMerchantId;
    return this;
  }

   /**
   * This is a local merchant ID used by merchants in addition to the conventional merchant ID. This value is sent to the issuer. Applicable for VPC and Prisma (prisma) processors.
   * @return domesticMerchantId
  **/
  @ApiModelProperty(value = "This is a local merchant ID used by merchants in addition to the conventional merchant ID. This value is sent to the issuer. Applicable for VPC and Prisma (prisma) processors.")
  public Boolean isDomesticMerchantId() {
    return domesticMerchantId;
  }

  public void setDomesticMerchantId(Boolean domesticMerchantId) {
    this.domesticMerchantId = domesticMerchantId;
  }

  public CardProcessingConfigCommon processLevel3Data(String processLevel3Data) {
    this.processLevel3Data = processLevel3Data;
    return this;
  }

   /**
   * Indicates whether merchant processes Level 3 transactions. Applicable for TSYS (tsys), Barclays (barclays2), Paymentech Tampa (paymentechtampa), FDI Global (fdiglobal), Elavon Americas (elavonamericas) and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;Barclays&lt;/td&gt;&lt;td&gt;cnp&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return processLevel3Data
  **/
  @ApiModelProperty(value = "Indicates whether merchant processes Level 3 transactions. Applicable for TSYS (tsys), Barclays (barclays2), Paymentech Tampa (paymentechtampa), FDI Global (fdiglobal), Elavon Americas (elavonamericas) and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp</td><td>No</td></tr> </table> ")
  public String getProcessLevel3Data() {
    return processLevel3Data;
  }

  public void setProcessLevel3Data(String processLevel3Data) {
    this.processLevel3Data = processLevel3Data;
  }

  public CardProcessingConfigCommon subMerchantId(String subMerchantId) {
    this.subMerchantId = subMerchantId;
    return this;
  }

   /**
   * The ID assigned to the sub-merchant. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Min. Length&lt;/th&gt;&lt;th&gt;Max. Length&lt;/th&gt;&lt;th&gt;Regex&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;1&lt;/td&gt;&lt;td&gt;20&lt;/td&gt;&lt;td&gt;^[0-9a-zA-Z&amp;#92;-&amp;#92;_&amp;#92;,\\s.]+$&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return subMerchantId
  **/
  @ApiModelProperty(value = "The ID assigned to the sub-merchant. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>20</td><td>^[0-9a-zA-Z&#92;-&#92;_&#92;,\\s.]+$</td></tr> </table> ")
  public String getSubMerchantId() {
    return subMerchantId;
  }

  public void setSubMerchantId(String subMerchantId) {
    this.subMerchantId = subMerchantId;
  }

  public CardProcessingConfigCommon subMerchantBusinessName(String subMerchantBusinessName) {
    this.subMerchantBusinessName = subMerchantBusinessName;
    return this;
  }

   /**
   * Sub-merchant&#39;s business name. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  &lt;table&gt; &lt;thead&gt;&lt;tr&gt;&lt;th&gt;Processor&lt;/th&gt;&lt;th&gt;Acceptance Type&lt;/th&gt;&lt;th&gt;Required&lt;/th&gt;&lt;th&gt;Min. Length&lt;/th&gt;&lt;th&gt;Max. Length&lt;/th&gt;&lt;th&gt;Regex&lt;/th&gt;&lt;/tr&gt;&lt;/thead&gt; &lt;tr&gt;&lt;td&gt;American Express Direct&lt;/td&gt;&lt;td&gt;cnp, cp, hybrid&lt;/td&gt;&lt;td&gt;No&lt;/td&gt;&lt;td&gt;1&lt;/td&gt;&lt;td&gt;37&lt;/td&gt;&lt;td&gt;^[0-9a-zA-Z&amp;#92;-&amp;#92;_&amp;#92;,\\s.]+$&lt;/td&gt;&lt;/tr&gt; &lt;/table&gt; 
   * @return subMerchantBusinessName
  **/
  @ApiModelProperty(value = "Sub-merchant's business name. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>37</td><td>^[0-9a-zA-Z&#92;-&#92;_&#92;,\\s.]+$</td></tr> </table> ")
  public String getSubMerchantBusinessName() {
    return subMerchantBusinessName;
  }

  public void setSubMerchantBusinessName(String subMerchantBusinessName) {
    this.subMerchantBusinessName = subMerchantBusinessName;
  }

  public CardProcessingConfigCommon preferCobadgedSecondaryBrand(Boolean preferCobadgedSecondaryBrand) {
    this.preferCobadgedSecondaryBrand = preferCobadgedSecondaryBrand;
    return this;
  }

   /**
   * It denotes merchant&#39;s preference on secondary brand for routing in case of co-branded cards. Applicable for EFTPOS processors.
   * @return preferCobadgedSecondaryBrand
  **/
  @ApiModelProperty(value = "It denotes merchant's preference on secondary brand for routing in case of co-branded cards. Applicable for EFTPOS processors.")
  public Boolean isPreferCobadgedSecondaryBrand() {
    return preferCobadgedSecondaryBrand;
  }

  public void setPreferCobadgedSecondaryBrand(Boolean preferCobadgedSecondaryBrand) {
    this.preferCobadgedSecondaryBrand = preferCobadgedSecondaryBrand;
  }

  public CardProcessingConfigCommon merchantDescriptorInformation(CardProcessingConfigCommonMerchantDescriptorInformation merchantDescriptorInformation) {
    this.merchantDescriptorInformation = merchantDescriptorInformation;
    return this;
  }

   /**
   * Get merchantDescriptorInformation
   * @return merchantDescriptorInformation
  **/
  @ApiModelProperty(value = "")
  public CardProcessingConfigCommonMerchantDescriptorInformation getMerchantDescriptorInformation() {
    return merchantDescriptorInformation;
  }

  public void setMerchantDescriptorInformation(CardProcessingConfigCommonMerchantDescriptorInformation merchantDescriptorInformation) {
    this.merchantDescriptorInformation = merchantDescriptorInformation;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CardProcessingConfigCommon cardProcessingConfigCommon = (CardProcessingConfigCommon) o;
    return Objects.equals(this.processors, cardProcessingConfigCommon.processors) &&
        Objects.equals(this.amexVendorCode, cardProcessingConfigCommon.amexVendorCode) &&
        Objects.equals(this.defaultAuthTypeCode, cardProcessingConfigCommon.defaultAuthTypeCode) &&
        Objects.equals(this.masterCardAssignedId, cardProcessingConfigCommon.masterCardAssignedId) &&
        Objects.equals(this.enablePartialAuth, cardProcessingConfigCommon.enablePartialAuth) &&
        Objects.equals(this.merchantCategoryCode, cardProcessingConfigCommon.merchantCategoryCode) &&
        Objects.equals(this.sicCode, cardProcessingConfigCommon.sicCode) &&
        Objects.equals(this.foodAndConsumerServiceId, cardProcessingConfigCommon.foodAndConsumerServiceId) &&
        Objects.equals(this.enableSplitShipment, cardProcessingConfigCommon.enableSplitShipment) &&
        Objects.equals(this.enableInterchangeOptimization, cardProcessingConfigCommon.enableInterchangeOptimization) &&
        Objects.equals(this.visaDelegatedAuthenticationId, cardProcessingConfigCommon.visaDelegatedAuthenticationId) &&
        Objects.equals(this.creditCardRefundLimitPercent, cardProcessingConfigCommon.creditCardRefundLimitPercent) &&
        Objects.equals(this.businessCenterCreditCardRefundLimitPercent, cardProcessingConfigCommon.businessCenterCreditCardRefundLimitPercent) &&
        Objects.equals(this.allowCapturesGreaterThanAuthorizations, cardProcessingConfigCommon.allowCapturesGreaterThanAuthorizations) &&
        Objects.equals(this.enableDuplicateMerchantReferenceNumberBlocking, cardProcessingConfigCommon.enableDuplicateMerchantReferenceNumberBlocking) &&
        Objects.equals(this.domesticMerchantId, cardProcessingConfigCommon.domesticMerchantId) &&
        Objects.equals(this.processLevel3Data, cardProcessingConfigCommon.processLevel3Data) &&
        Objects.equals(this.subMerchantId, cardProcessingConfigCommon.subMerchantId) &&
        Objects.equals(this.subMerchantBusinessName, cardProcessingConfigCommon.subMerchantBusinessName) &&
        Objects.equals(this.preferCobadgedSecondaryBrand, cardProcessingConfigCommon.preferCobadgedSecondaryBrand) &&
        Objects.equals(this.merchantDescriptorInformation, cardProcessingConfigCommon.merchantDescriptorInformation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processors, amexVendorCode, defaultAuthTypeCode, masterCardAssignedId, enablePartialAuth, merchantCategoryCode, sicCode, foodAndConsumerServiceId, enableSplitShipment, enableInterchangeOptimization, visaDelegatedAuthenticationId, creditCardRefundLimitPercent, businessCenterCreditCardRefundLimitPercent, allowCapturesGreaterThanAuthorizations, enableDuplicateMerchantReferenceNumberBlocking, domesticMerchantId, processLevel3Data, subMerchantId, subMerchantBusinessName, preferCobadgedSecondaryBrand, merchantDescriptorInformation);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CardProcessingConfigCommon {\n");
    
    sb.append("    processors: ").append(toIndentedString(processors)).append("\n");
    sb.append("    amexVendorCode: ").append(toIndentedString(amexVendorCode)).append("\n");
    sb.append("    defaultAuthTypeCode: ").append(toIndentedString(defaultAuthTypeCode)).append("\n");
    sb.append("    masterCardAssignedId: ").append(toIndentedString(masterCardAssignedId)).append("\n");
    sb.append("    enablePartialAuth: ").append(toIndentedString(enablePartialAuth)).append("\n");
    sb.append("    merchantCategoryCode: ").append(toIndentedString(merchantCategoryCode)).append("\n");
    sb.append("    sicCode: ").append(toIndentedString(sicCode)).append("\n");
    sb.append("    foodAndConsumerServiceId: ").append(toIndentedString(foodAndConsumerServiceId)).append("\n");
    sb.append("    enableSplitShipment: ").append(toIndentedString(enableSplitShipment)).append("\n");
    sb.append("    enableInterchangeOptimization: ").append(toIndentedString(enableInterchangeOptimization)).append("\n");
    sb.append("    visaDelegatedAuthenticationId: ").append(toIndentedString(visaDelegatedAuthenticationId)).append("\n");
    sb.append("    creditCardRefundLimitPercent: ").append(toIndentedString(creditCardRefundLimitPercent)).append("\n");
    sb.append("    businessCenterCreditCardRefundLimitPercent: ").append(toIndentedString(businessCenterCreditCardRefundLimitPercent)).append("\n");
    sb.append("    allowCapturesGreaterThanAuthorizations: ").append(toIndentedString(allowCapturesGreaterThanAuthorizations)).append("\n");
    sb.append("    enableDuplicateMerchantReferenceNumberBlocking: ").append(toIndentedString(enableDuplicateMerchantReferenceNumberBlocking)).append("\n");
    sb.append("    domesticMerchantId: ").append(toIndentedString(domesticMerchantId)).append("\n");
    sb.append("    processLevel3Data: ").append(toIndentedString(processLevel3Data)).append("\n");
    sb.append("    subMerchantId: ").append(toIndentedString(subMerchantId)).append("\n");
    sb.append("    subMerchantBusinessName: ").append(toIndentedString(subMerchantBusinessName)).append("\n");
    sb.append("    preferCobadgedSecondaryBrand: ").append(toIndentedString(preferCobadgedSecondaryBrand)).append("\n");
    sb.append("    merchantDescriptorInformation: ").append(toIndentedString(merchantDescriptorInformation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

