/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.InlineResponse2004;
import Model.InlineResponse2014;
import Model.ReplayWebhooks;
import Model.SaveAsymEgressKey;
import Model.UpdateWebhook;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class ManageWebhooksApi {
    private static Logger logger = LogManager.getLogger(ManageWebhooksApi.class);
    private ApiClient apiClient;

    public ManageWebhooksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ManageWebhooksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteWebhookSubscriptionCall(String webhookId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("DELETE".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/notification-subscriptions/v1/webhooks/{webhookId}".replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteWebhookSubscriptionValidateBeforeCall(String webhookId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhookId == null) {
            logger.error("Missing the required parameter 'webhookId' when calling deleteWebhookSubscription(Async)");
            throw new ApiException("Missing the required parameter 'webhookId' when calling deleteWebhookSubscription(Async)");
        }
        Call call = this.deleteWebhookSubscriptionCall(webhookId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteWebhookSubscription(String webhookId) throws ApiException {
        logger.info("CALL TO METHOD 'deleteWebhookSubscription' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        this.deleteWebhookSubscriptionWithHttpInfo(webhookId);
    }

    public ApiResponse<Void> deleteWebhookSubscriptionWithHttpInfo(String webhookId) throws ApiException {
        Call call = this.deleteWebhookSubscriptionValidateBeforeCall(webhookId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteWebhookSubscriptionAsync(String webhookId, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteWebhookSubscriptionValidateBeforeCall(webhookId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getAllWebhooksCall(String organizationId, String productId, String eventType, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/notification-subscriptions/v1/webhooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (organizationId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "organizationId", organizationId));
        }
        if (productId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "productId", productId));
        }
        if (eventType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "eventType", eventType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllWebhooksValidateBeforeCall(String organizationId, String productId, String eventType, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (organizationId == null) {
            logger.error("Missing the required parameter 'organizationId' when calling getAllWebhooks(Async)");
            throw new ApiException("Missing the required parameter 'organizationId' when calling getAllWebhooks(Async)");
        }
        if (productId == null) {
            logger.error("Missing the required parameter 'productId' when calling getAllWebhooks(Async)");
            throw new ApiException("Missing the required parameter 'productId' when calling getAllWebhooks(Async)");
        }
        if (eventType == null) {
            logger.error("Missing the required parameter 'eventType' when calling getAllWebhooks(Async)");
            throw new ApiException("Missing the required parameter 'eventType' when calling getAllWebhooks(Async)");
        }
        Call call = this.getAllWebhooksCall(organizationId, productId, eventType, progressListener, progressRequestListener);
        return call;
    }

    public List<InlineResponse2004> getAllWebhooks(String organizationId, String productId, String eventType) throws ApiException {
        logger.info("CALL TO METHOD 'getAllWebhooks' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<List<InlineResponse2004>> resp = this.getAllWebhooksWithHttpInfo(organizationId, productId, eventType);
        logger.info("CALL TO METHOD 'getAllWebhooks' ENDED");
        return resp.getData();
    }

    public ApiResponse<List<InlineResponse2004>> getAllWebhooksWithHttpInfo(String organizationId, String productId, String eventType) throws ApiException {
        Call call = this.getAllWebhooksValidateBeforeCall(organizationId, productId, eventType, null, null);
        Type localVarReturnType = new TypeToken<List<InlineResponse2004>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllWebhooksAsync(String organizationId, String productId, String eventType, final ApiCallback<List<InlineResponse2004>> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllWebhooksValidateBeforeCall(organizationId, productId, eventType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<InlineResponse2004>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getWebhookDetailsCall(String webhookId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/notification-subscriptions/v1/webhooks/{webhookId}".replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getWebhookDetailsValidateBeforeCall(String webhookId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhookId == null) {
            logger.error("Missing the required parameter 'webhookId' when calling getWebhookDetails(Async)");
            throw new ApiException("Missing the required parameter 'webhookId' when calling getWebhookDetails(Async)");
        }
        Call call = this.getWebhookDetailsCall(webhookId, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2004 getWebhookDetails(String webhookId) throws ApiException {
        logger.info("CALL TO METHOD 'getWebhookDetails' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<InlineResponse2004> resp = this.getWebhookDetailsWithHttpInfo(webhookId);
        logger.info("CALL TO METHOD 'getWebhookDetails' ENDED");
        return resp.getData();
    }

    public ApiResponse<InlineResponse2004> getWebhookDetailsWithHttpInfo(String webhookId) throws ApiException {
        Call call = this.getWebhookDetailsValidateBeforeCall(webhookId, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2004>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getWebhookDetailsAsync(String webhookId, final ApiCallback<InlineResponse2004> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getWebhookDetailsValidateBeforeCall(webhookId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2004>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call replayPreviousWebhookCall(String webhookId, ReplayWebhooks replayWebhooks, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(replayWebhooks, ReplayWebhooks.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment());
        String localVarPath = "/nrtf/v1/webhooks/{webhookId}/replays".replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call replayPreviousWebhookValidateBeforeCall(String webhookId, ReplayWebhooks replayWebhooks, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhookId == null) {
            logger.error("Missing the required parameter 'webhookId' when calling replayPreviousWebhook(Async)");
            throw new ApiException("Missing the required parameter 'webhookId' when calling replayPreviousWebhook(Async)");
        }
        Call call = this.replayPreviousWebhookCall(webhookId, replayWebhooks, progressListener, progressRequestListener);
        return call;
    }

    public void replayPreviousWebhook(String webhookId, ReplayWebhooks replayWebhooks) throws ApiException {
        logger.info("CALL TO METHOD 'replayPreviousWebhook' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        this.replayPreviousWebhookWithHttpInfo(webhookId, replayWebhooks);
    }

    public ApiResponse<Void> replayPreviousWebhookWithHttpInfo(String webhookId, ReplayWebhooks replayWebhooks) throws ApiException {
        Call call = this.replayPreviousWebhookValidateBeforeCall(webhookId, replayWebhooks, null, null);
        return this.apiClient.execute(call);
    }

    public Call replayPreviousWebhookAsync(String webhookId, ReplayWebhooks replayWebhooks, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.replayPreviousWebhookValidateBeforeCall(webhookId, replayWebhooks, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call saveAsymEgressKeyCall(String vCSenderOrganizationId, String vCPermissions, SaveAsymEgressKey saveAsymEgressKey, String vCCorrelationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(saveAsymEgressKey, SaveAsymEgressKey.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment());
        String localVarPath = "/kms/egress/v2/keys-asym";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (vCCorrelationId != null) {
            localVarHeaderParams.put("v-c-correlation-id", this.apiClient.parameterToString(vCCorrelationId));
        }
        if (vCSenderOrganizationId != null) {
            localVarHeaderParams.put("v-c-sender-organization-id", this.apiClient.parameterToString(vCSenderOrganizationId));
        }
        if (vCPermissions != null) {
            localVarHeaderParams.put("v-c-permissions", this.apiClient.parameterToString(vCPermissions));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call saveAsymEgressKeyValidateBeforeCall(String vCSenderOrganizationId, String vCPermissions, SaveAsymEgressKey saveAsymEgressKey, String vCCorrelationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (vCSenderOrganizationId == null) {
            logger.error("Missing the required parameter 'vCSenderOrganizationId' when calling saveAsymEgressKey(Async)");
            throw new ApiException("Missing the required parameter 'vCSenderOrganizationId' when calling saveAsymEgressKey(Async)");
        }
        if (vCPermissions == null) {
            logger.error("Missing the required parameter 'vCPermissions' when calling saveAsymEgressKey(Async)");
            throw new ApiException("Missing the required parameter 'vCPermissions' when calling saveAsymEgressKey(Async)");
        }
        if (saveAsymEgressKey == null) {
            logger.error("Missing the required parameter 'saveAsymEgressKey' when calling saveAsymEgressKey(Async)");
            throw new ApiException("Missing the required parameter 'saveAsymEgressKey' when calling saveAsymEgressKey(Async)");
        }
        Call call = this.saveAsymEgressKeyCall(vCSenderOrganizationId, vCPermissions, saveAsymEgressKey, vCCorrelationId, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2014 saveAsymEgressKey(String vCSenderOrganizationId, String vCPermissions, SaveAsymEgressKey saveAsymEgressKey, String vCCorrelationId) throws ApiException {
        logger.info("CALL TO METHOD 'saveAsymEgressKey' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<InlineResponse2014> resp = this.saveAsymEgressKeyWithHttpInfo(vCSenderOrganizationId, vCPermissions, saveAsymEgressKey, vCCorrelationId);
        logger.info("CALL TO METHOD 'saveAsymEgressKey' ENDED");
        return resp.getData();
    }

    public ApiResponse<InlineResponse2014> saveAsymEgressKeyWithHttpInfo(String vCSenderOrganizationId, String vCPermissions, SaveAsymEgressKey saveAsymEgressKey, String vCCorrelationId) throws ApiException {
        Call call = this.saveAsymEgressKeyValidateBeforeCall(vCSenderOrganizationId, vCPermissions, saveAsymEgressKey, vCCorrelationId, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2014>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call saveAsymEgressKeyAsync(String vCSenderOrganizationId, String vCPermissions, SaveAsymEgressKey saveAsymEgressKey, String vCCorrelationId, final ApiCallback<InlineResponse2014> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.saveAsymEgressKeyValidateBeforeCall(vCSenderOrganizationId, vCPermissions, saveAsymEgressKey, vCCorrelationId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2014>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateWebhookSubscriptionCall(String webhookId, UpdateWebhook updateWebhook, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(updateWebhook, UpdateWebhook.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment());
        String localVarPath = "/notification-subscriptions/v1/webhooks/{webhookId}".replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateWebhookSubscriptionValidateBeforeCall(String webhookId, UpdateWebhook updateWebhook, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhookId == null) {
            logger.error("Missing the required parameter 'webhookId' when calling updateWebhookSubscription(Async)");
            throw new ApiException("Missing the required parameter 'webhookId' when calling updateWebhookSubscription(Async)");
        }
        Call call = this.updateWebhookSubscriptionCall(webhookId, updateWebhook, progressListener, progressRequestListener);
        return call;
    }

    public void updateWebhookSubscription(String webhookId, UpdateWebhook updateWebhook) throws ApiException {
        logger.info("CALL TO METHOD 'updateWebhookSubscription' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        this.updateWebhookSubscriptionWithHttpInfo(webhookId, updateWebhook);
    }

    public ApiResponse<Void> updateWebhookSubscriptionWithHttpInfo(String webhookId, UpdateWebhook updateWebhook) throws ApiException {
        Call call = this.updateWebhookSubscriptionValidateBeforeCall(webhookId, updateWebhook, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateWebhookSubscriptionAsync(String webhookId, UpdateWebhook updateWebhook, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateWebhookSubscriptionValidateBeforeCall(webhookId, updateWebhook, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

