/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;
import java.io.InputStream;


import Model.AddNegativeListRequest;
import Model.CaseManagementActionsRequest;
import Model.CaseManagementCommentsRequest;
import Model.CreateBundledDecisionManagerCaseRequest;
import Model.FraudMarkingActionRequest;
import Model.InlineResponse200;
import Model.InlineResponse201;
import Model.InlineResponse4001;
import Model.InlineResponse4031;
import Model.InlineResponse422;
import Model.InlineResponse5001;
import Model.InlineResponse502;
import Model.InlineResponse503;
import Model.PtsV2PaymentsPost502Response;
import Model.RiskV1DecisionsPost201Response;
import Model.RiskV1DecisionsPost400Response;
import Model.RiskV1DecisionsPost400Response1;
import Model.RiskV1UpdatePost201Response;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class DecisionManagerApi {
    private static Logger logger = LogManager.getLogger(DecisionManagerApi.class);
    
    private ApiClient apiClient;

    public DecisionManagerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DecisionManagerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for actionDecisionManagerCase
     * @param id An unique identification number generated by Cybersource to identify the submitted request. (required)
     * @param caseManagementActionsRequest  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call actionDecisionManagerCaseCall(String id, CaseManagementActionsRequest caseManagementActionsRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(caseManagementActionsRequest, CaseManagementActionsRequest.class.getSimpleName(), apiClient.merchantConfig.getRunEnvironment());
        
        // create path and map variables
        String localVarPath = "/risk/v1/decisions/{id}/actions"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call actionDecisionManagerCaseValidateBeforeCall(String id, CaseManagementActionsRequest caseManagementActionsRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            logger.error("Missing the required parameter 'id' when calling actionDecisionManagerCase(Async)");
            throw new ApiException("Missing the required parameter 'id' when calling actionDecisionManagerCase(Async)");
        }
        
        // verify the required parameter 'caseManagementActionsRequest' is set
        if (caseManagementActionsRequest == null) {
            logger.error("Missing the required parameter 'caseManagementActionsRequest' when calling actionDecisionManagerCase(Async)");
            throw new ApiException("Missing the required parameter 'caseManagementActionsRequest' when calling actionDecisionManagerCase(Async)");
        }
        
        
        okhttp3.Call call = actionDecisionManagerCaseCall(id, caseManagementActionsRequest, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Take action on a DM post-transactional case
     * Take action on a DM post-transactional case
     * @param id An unique identification number generated by Cybersource to identify the submitted request. (required)
     * @param caseManagementActionsRequest  (required)
     * @return InlineResponse200
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public InlineResponse200 actionDecisionManagerCase(String id, CaseManagementActionsRequest caseManagementActionsRequest) throws ApiException {
        logger.info("CALL TO METHOD 'actionDecisionManagerCase' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<InlineResponse200> resp = actionDecisionManagerCaseWithHttpInfo(id, caseManagementActionsRequest);
        logger.info("CALL TO METHOD 'actionDecisionManagerCase' ENDED");
        return resp.getData();
    }

    /**
     * Take action on a DM post-transactional case
     * Take action on a DM post-transactional case
     * @param id An unique identification number generated by Cybersource to identify the submitted request. (required)
     * @param caseManagementActionsRequest  (required)
     * @return ApiResponse&lt;InlineResponse200&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<InlineResponse200> actionDecisionManagerCaseWithHttpInfo(String id, CaseManagementActionsRequest caseManagementActionsRequest) throws ApiException {
        okhttp3.Call call = actionDecisionManagerCaseValidateBeforeCall(id, caseManagementActionsRequest, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse200>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Take action on a DM post-transactional case (asynchronously)
     * Take action on a DM post-transactional case
     * @param id An unique identification number generated by Cybersource to identify the submitted request. (required)
     * @param caseManagementActionsRequest  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call actionDecisionManagerCaseAsync(String id, CaseManagementActionsRequest caseManagementActionsRequest, final ApiCallback<InlineResponse200> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = actionDecisionManagerCaseValidateBeforeCall(id, caseManagementActionsRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse200>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for addNegative
     * @param type The list to be updated. It can be &#39;positive&#39;, &#39;negative&#39; or &#39;review&#39;. (required)
     * @param addNegativeListRequest  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call addNegativeCall(String type, AddNegativeListRequest addNegativeListRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(addNegativeListRequest, AddNegativeListRequest.class.getSimpleName(), apiClient.merchantConfig.getRunEnvironment());
        
        // create path and map variables
        String localVarPath = "/risk/v1/lists/{type}/entries"
            .replaceAll("\\{" + "type" + "\\}", apiClient.escapeString(type.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/hal+json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call addNegativeValidateBeforeCall(String type, AddNegativeListRequest addNegativeListRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'type' is set
        if (type == null) {
            logger.error("Missing the required parameter 'type' when calling addNegative(Async)");
            throw new ApiException("Missing the required parameter 'type' when calling addNegative(Async)");
        }
        
        // verify the required parameter 'addNegativeListRequest' is set
        if (addNegativeListRequest == null) {
            logger.error("Missing the required parameter 'addNegativeListRequest' when calling addNegative(Async)");
            throw new ApiException("Missing the required parameter 'addNegativeListRequest' when calling addNegative(Async)");
        }
        
        
        okhttp3.Call call = addNegativeCall(type, addNegativeListRequest, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * List Management
     * This call adds/deletes/converts the request information in the negative list.  Provide the list to be updated as the path parameter. This value can be &#39;postiive&#39;, &#39;negative&#39; or &#39;review&#39;. 
     * @param type The list to be updated. It can be &#39;positive&#39;, &#39;negative&#39; or &#39;review&#39;. (required)
     * @param addNegativeListRequest  (required)
     * @return RiskV1UpdatePost201Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RiskV1UpdatePost201Response addNegative(String type, AddNegativeListRequest addNegativeListRequest) throws ApiException {
        logger.info("CALL TO METHOD 'addNegative' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<RiskV1UpdatePost201Response> resp = addNegativeWithHttpInfo(type, addNegativeListRequest);
        logger.info("CALL TO METHOD 'addNegative' ENDED");
        return resp.getData();
    }

    /**
     * List Management
     * This call adds/deletes/converts the request information in the negative list.  Provide the list to be updated as the path parameter. This value can be &#39;postiive&#39;, &#39;negative&#39; or &#39;review&#39;. 
     * @param type The list to be updated. It can be &#39;positive&#39;, &#39;negative&#39; or &#39;review&#39;. (required)
     * @param addNegativeListRequest  (required)
     * @return ApiResponse&lt;RiskV1UpdatePost201Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RiskV1UpdatePost201Response> addNegativeWithHttpInfo(String type, AddNegativeListRequest addNegativeListRequest) throws ApiException {
        okhttp3.Call call = addNegativeValidateBeforeCall(type, addNegativeListRequest, null, null);
        Type localVarReturnType = new TypeToken<RiskV1UpdatePost201Response>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List Management (asynchronously)
     * This call adds/deletes/converts the request information in the negative list.  Provide the list to be updated as the path parameter. This value can be &#39;postiive&#39;, &#39;negative&#39; or &#39;review&#39;. 
     * @param type The list to be updated. It can be &#39;positive&#39;, &#39;negative&#39; or &#39;review&#39;. (required)
     * @param addNegativeListRequest  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call addNegativeAsync(String type, AddNegativeListRequest addNegativeListRequest, final ApiCallback<RiskV1UpdatePost201Response> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = addNegativeValidateBeforeCall(type, addNegativeListRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RiskV1UpdatePost201Response>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for commentDecisionManagerCase
     * @param id An unique identification number generated by Cybersource to identify the submitted request. (required)
     * @param caseManagementCommentsRequest  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call commentDecisionManagerCaseCall(String id, CaseManagementCommentsRequest caseManagementCommentsRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(caseManagementCommentsRequest, CaseManagementCommentsRequest.class.getSimpleName(), apiClient.merchantConfig.getRunEnvironment());
        
        // create path and map variables
        String localVarPath = "/risk/v1/decisions/{id}/comments"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call commentDecisionManagerCaseValidateBeforeCall(String id, CaseManagementCommentsRequest caseManagementCommentsRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            logger.error("Missing the required parameter 'id' when calling commentDecisionManagerCase(Async)");
            throw new ApiException("Missing the required parameter 'id' when calling commentDecisionManagerCase(Async)");
        }
        
        // verify the required parameter 'caseManagementCommentsRequest' is set
        if (caseManagementCommentsRequest == null) {
            logger.error("Missing the required parameter 'caseManagementCommentsRequest' when calling commentDecisionManagerCase(Async)");
            throw new ApiException("Missing the required parameter 'caseManagementCommentsRequest' when calling commentDecisionManagerCase(Async)");
        }
        
        
        okhttp3.Call call = commentDecisionManagerCaseCall(id, caseManagementCommentsRequest, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Add a comment to a DM post-transactional case
     * Add a comment to a DM post-transactional case
     * @param id An unique identification number generated by Cybersource to identify the submitted request. (required)
     * @param caseManagementCommentsRequest  (required)
     * @return InlineResponse201
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public InlineResponse201 commentDecisionManagerCase(String id, CaseManagementCommentsRequest caseManagementCommentsRequest) throws ApiException {
        logger.info("CALL TO METHOD 'commentDecisionManagerCase' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<InlineResponse201> resp = commentDecisionManagerCaseWithHttpInfo(id, caseManagementCommentsRequest);
        logger.info("CALL TO METHOD 'commentDecisionManagerCase' ENDED");
        return resp.getData();
    }

    /**
     * Add a comment to a DM post-transactional case
     * Add a comment to a DM post-transactional case
     * @param id An unique identification number generated by Cybersource to identify the submitted request. (required)
     * @param caseManagementCommentsRequest  (required)
     * @return ApiResponse&lt;InlineResponse201&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<InlineResponse201> commentDecisionManagerCaseWithHttpInfo(String id, CaseManagementCommentsRequest caseManagementCommentsRequest) throws ApiException {
        okhttp3.Call call = commentDecisionManagerCaseValidateBeforeCall(id, caseManagementCommentsRequest, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse201>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add a comment to a DM post-transactional case (asynchronously)
     * Add a comment to a DM post-transactional case
     * @param id An unique identification number generated by Cybersource to identify the submitted request. (required)
     * @param caseManagementCommentsRequest  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call commentDecisionManagerCaseAsync(String id, CaseManagementCommentsRequest caseManagementCommentsRequest, final ApiCallback<InlineResponse201> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = commentDecisionManagerCaseValidateBeforeCall(id, caseManagementCommentsRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse201>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for createBundledDecisionManagerCase
     * @param createBundledDecisionManagerCaseRequest  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call createBundledDecisionManagerCaseCall(CreateBundledDecisionManagerCaseRequest createBundledDecisionManagerCaseRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(createBundledDecisionManagerCaseRequest, CreateBundledDecisionManagerCaseRequest.class.getSimpleName(), apiClient.merchantConfig.getRunEnvironment());
        
        // create path and map variables
        String localVarPath = "/risk/v1/decisions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/hal+json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call createBundledDecisionManagerCaseValidateBeforeCall(CreateBundledDecisionManagerCaseRequest createBundledDecisionManagerCaseRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'createBundledDecisionManagerCaseRequest' is set
        if (createBundledDecisionManagerCaseRequest == null) {
            logger.error("Missing the required parameter 'createBundledDecisionManagerCaseRequest' when calling createBundledDecisionManagerCase(Async)");
            throw new ApiException("Missing the required parameter 'createBundledDecisionManagerCaseRequest' when calling createBundledDecisionManagerCase(Async)");
        }
        
        
        okhttp3.Call call = createBundledDecisionManagerCaseCall(createBundledDecisionManagerCaseRequest, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Create Decision Manager
     * Decision Manager can help you automate and streamline your fraud operations. Decision Manager will return a decision based on the request values.
     * @param createBundledDecisionManagerCaseRequest  (required)
     * @return RiskV1DecisionsPost201Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RiskV1DecisionsPost201Response createBundledDecisionManagerCase(CreateBundledDecisionManagerCaseRequest createBundledDecisionManagerCaseRequest) throws ApiException {
        logger.info("CALL TO METHOD 'createBundledDecisionManagerCase' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<RiskV1DecisionsPost201Response> resp = createBundledDecisionManagerCaseWithHttpInfo(createBundledDecisionManagerCaseRequest);
        logger.info("CALL TO METHOD 'createBundledDecisionManagerCase' ENDED");
        return resp.getData();
    }

    /**
     * Create Decision Manager
     * Decision Manager can help you automate and streamline your fraud operations. Decision Manager will return a decision based on the request values.
     * @param createBundledDecisionManagerCaseRequest  (required)
     * @return ApiResponse&lt;RiskV1DecisionsPost201Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RiskV1DecisionsPost201Response> createBundledDecisionManagerCaseWithHttpInfo(CreateBundledDecisionManagerCaseRequest createBundledDecisionManagerCaseRequest) throws ApiException {
        okhttp3.Call call = createBundledDecisionManagerCaseValidateBeforeCall(createBundledDecisionManagerCaseRequest, null, null);
        Type localVarReturnType = new TypeToken<RiskV1DecisionsPost201Response>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create Decision Manager (asynchronously)
     * Decision Manager can help you automate and streamline your fraud operations. Decision Manager will return a decision based on the request values.
     * @param createBundledDecisionManagerCaseRequest  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call createBundledDecisionManagerCaseAsync(CreateBundledDecisionManagerCaseRequest createBundledDecisionManagerCaseRequest, final ApiCallback<RiskV1DecisionsPost201Response> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = createBundledDecisionManagerCaseValidateBeforeCall(createBundledDecisionManagerCaseRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RiskV1DecisionsPost201Response>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for fraudUpdate
     * @param id Request ID of the transaction that you want to mark as suspect or remove from history. (required)
     * @param fraudMarkingActionRequest  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call fraudUpdateCall(String id, FraudMarkingActionRequest fraudMarkingActionRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(fraudMarkingActionRequest, FraudMarkingActionRequest.class.getSimpleName(), apiClient.merchantConfig.getRunEnvironment());
        
        // create path and map variables
        String localVarPath = "/risk/v1/decisions/{id}/marking"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/hal+json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call fraudUpdateValidateBeforeCall(String id, FraudMarkingActionRequest fraudMarkingActionRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            logger.error("Missing the required parameter 'id' when calling fraudUpdate(Async)");
            throw new ApiException("Missing the required parameter 'id' when calling fraudUpdate(Async)");
        }
        
        // verify the required parameter 'fraudMarkingActionRequest' is set
        if (fraudMarkingActionRequest == null) {
            logger.error("Missing the required parameter 'fraudMarkingActionRequest' when calling fraudUpdate(Async)");
            throw new ApiException("Missing the required parameter 'fraudMarkingActionRequest' when calling fraudUpdate(Async)");
        }
        
        
        okhttp3.Call call = fraudUpdateCall(id, fraudMarkingActionRequest, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Fraud Marking
     * This can be used to - 1. Add known fraudulent data to the fraud history 2. Remove data added to history with Transaction Marking Tool or by uploading chargeback files 3. Remove chargeback data from history that was automatically added. For detailed information, contact your Cybersource representative  Place the request ID of the transaction you want to mark as suspect (or remove from history) as the path parameter in this request. 
     * @param id Request ID of the transaction that you want to mark as suspect or remove from history. (required)
     * @param fraudMarkingActionRequest  (required)
     * @return RiskV1UpdatePost201Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RiskV1UpdatePost201Response fraudUpdate(String id, FraudMarkingActionRequest fraudMarkingActionRequest) throws ApiException {
        logger.info("CALL TO METHOD 'fraudUpdate' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<RiskV1UpdatePost201Response> resp = fraudUpdateWithHttpInfo(id, fraudMarkingActionRequest);
        logger.info("CALL TO METHOD 'fraudUpdate' ENDED");
        return resp.getData();
    }

    /**
     * Fraud Marking
     * This can be used to - 1. Add known fraudulent data to the fraud history 2. Remove data added to history with Transaction Marking Tool or by uploading chargeback files 3. Remove chargeback data from history that was automatically added. For detailed information, contact your Cybersource representative  Place the request ID of the transaction you want to mark as suspect (or remove from history) as the path parameter in this request. 
     * @param id Request ID of the transaction that you want to mark as suspect or remove from history. (required)
     * @param fraudMarkingActionRequest  (required)
     * @return ApiResponse&lt;RiskV1UpdatePost201Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RiskV1UpdatePost201Response> fraudUpdateWithHttpInfo(String id, FraudMarkingActionRequest fraudMarkingActionRequest) throws ApiException {
        okhttp3.Call call = fraudUpdateValidateBeforeCall(id, fraudMarkingActionRequest, null, null);
        Type localVarReturnType = new TypeToken<RiskV1UpdatePost201Response>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Fraud Marking (asynchronously)
     * This can be used to - 1. Add known fraudulent data to the fraud history 2. Remove data added to history with Transaction Marking Tool or by uploading chargeback files 3. Remove chargeback data from history that was automatically added. For detailed information, contact your Cybersource representative  Place the request ID of the transaction you want to mark as suspect (or remove from history) as the path parameter in this request. 
     * @param id Request ID of the transaction that you want to mark as suspect or remove from history. (required)
     * @param fraudMarkingActionRequest  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call fraudUpdateAsync(String id, FraudMarkingActionRequest fraudMarkingActionRequest, final ApiCallback<RiskV1UpdatePost201Response> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = fraudUpdateValidateBeforeCall(id, fraudMarkingActionRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RiskV1UpdatePost201Response>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
