/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Api.NotificationOfChangesApi;
import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.AccessTokenResponse;
import Model.CreateAccessTokenRequest;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OAuthApi {
    private static Logger logger = LogManager.getLogger(NotificationOfChangesApi.class);
    private ApiClient apiClient;

    public OAuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OAuthApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call postAccessTokenFromAuthCodeCall(CreateAccessTokenRequest createAccessTokenRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateAccessTokenRequest localVarPostBody = createAccessTokenRequest;
        String localVarPath = "/oauth2/v3/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postAccessTokenFromAuthCodeValidateBeforeCall(CreateAccessTokenRequest createAccessTokenRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createAccessTokenRequest == null) {
            throw new ApiException("Missing the required parameter 'createAccessTokenRequest' when calling postAccessTokenFromAuthCode(Async)");
        }
        Call call = this.postAccessTokenFromAuthCodeCall(createAccessTokenRequest, progressListener, progressRequestListener);
        return call;
    }

    public AccessTokenResponse postAccessTokenFromAuthCode(CreateAccessTokenRequest createAccessTokenRequest) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<AccessTokenResponse> resp = this.postAccessTokenFromAuthCodeWithHttpInfo(createAccessTokenRequest);
        return resp.getData();
    }

    public ApiResponse<AccessTokenResponse> postAccessTokenFromAuthCodeWithHttpInfo(CreateAccessTokenRequest createAccessTokenRequest) throws ApiException {
        Call call = this.postAccessTokenFromAuthCodeValidateBeforeCall(createAccessTokenRequest, null, null);
        Type localVarReturnType = new TypeToken<AccessTokenResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postAccessTokenFromAuthCodeAsync(CreateAccessTokenRequest createAccessTokenRequest, final ApiCallback<AccessTokenResponse> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postAccessTokenFromAuthCodeValidateBeforeCall(createAccessTokenRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AccessTokenResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postAccessTokenFromRefreshTokenCall(CreateAccessTokenRequest createAccessTokenRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateAccessTokenRequest localVarPostBody = createAccessTokenRequest;
        String localVarPath = "/oauth2/v3/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postAccessTokenFromRefreshTokenValidateBeforeCall(CreateAccessTokenRequest createAccessTokenRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createAccessTokenRequest == null) {
            throw new ApiException("Missing the required parameter 'createAccessTokenRequest' when calling postAccessTokenFromRefreshToken(Async)");
        }
        Call call = this.postAccessTokenFromRefreshTokenCall(createAccessTokenRequest, progressListener, progressRequestListener);
        return call;
    }

    public AccessTokenResponse postAccessTokenFromRefreshToken(CreateAccessTokenRequest createAccessTokenRequest) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<AccessTokenResponse> resp = this.postAccessTokenFromRefreshTokenWithHttpInfo(createAccessTokenRequest);
        return resp.getData();
    }

    public ApiResponse<AccessTokenResponse> postAccessTokenFromRefreshTokenWithHttpInfo(CreateAccessTokenRequest createAccessTokenRequest) throws ApiException {
        Call call = this.postAccessTokenFromRefreshTokenValidateBeforeCall(createAccessTokenRequest, null, null);
        Type localVarReturnType = new TypeToken<AccessTokenResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postAccessTokenFromRefreshTokenAsync(CreateAccessTokenRequest createAccessTokenRequest, final ApiCallback<AccessTokenResponse> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postAccessTokenFromRefreshTokenValidateBeforeCall(createAccessTokenRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AccessTokenResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

