/*
 * Decompiled with CFR 0.152.
 */
package Model;

import Model.Reportingv3reportsReportPreferences;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateReportSubscriptionRequest {
    @SerializedName(value="organizationId")
    private String organizationId = null;
    @SerializedName(value="reportDefinitionName")
    private String reportDefinitionName = null;
    @SerializedName(value="reportFields")
    private List<String> reportFields = new ArrayList<String>();
    @SerializedName(value="reportMimeType")
    private String reportMimeType = null;
    @SerializedName(value="reportFrequency")
    private String reportFrequency = null;
    @SerializedName(value="reportInterval")
    private String reportInterval = null;
    @SerializedName(value="reportName")
    private String reportName = null;
    @SerializedName(value="timezone")
    private String timezone = null;
    @SerializedName(value="startTime")
    private String startTime = null;
    @SerializedName(value="startDay")
    private Integer startDay = null;
    @SerializedName(value="reportFilters")
    private Map<String, List<String>> reportFilters = null;
    @SerializedName(value="reportPreferences")
    private Reportingv3reportsReportPreferences reportPreferences = null;
    @SerializedName(value="groupName")
    private String groupName = null;

    public CreateReportSubscriptionRequest organizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    @ApiModelProperty(example="Merchant 1", value="Valid CyberSource organizationId")
    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public CreateReportSubscriptionRequest reportDefinitionName(String reportDefinitionName) {
        this.reportDefinitionName = reportDefinitionName;
        return this;
    }

    @ApiModelProperty(example="TransactionDetailReportClass", required=true, value="Valid Report Definition Name")
    public String getReportDefinitionName() {
        return this.reportDefinitionName;
    }

    public void setReportDefinitionName(String reportDefinitionName) {
        this.reportDefinitionName = reportDefinitionName;
    }

    public CreateReportSubscriptionRequest reportFields(List<String> reportFields) {
        this.reportFields = reportFields;
        return this;
    }

    public CreateReportSubscriptionRequest addReportFieldsItem(String reportFieldsItem) {
        this.reportFields.add(reportFieldsItem);
        return this;
    }

    @ApiModelProperty(example="[\"Request.RequestID\",\"Request.TransactionDate\",\"Request.MerchantID\"]", required=true, value="")
    public List<String> getReportFields() {
        return this.reportFields;
    }

    public void setReportFields(List<String> reportFields) {
        this.reportFields = reportFields;
    }

    public CreateReportSubscriptionRequest reportMimeType(String reportMimeType) {
        this.reportMimeType = reportMimeType;
        return this;
    }

    @ApiModelProperty(example="application/xml", required=true, value="Valid values: - application/xml - text/csv ")
    public String getReportMimeType() {
        return this.reportMimeType;
    }

    public void setReportMimeType(String reportMimeType) {
        this.reportMimeType = reportMimeType;
    }

    public CreateReportSubscriptionRequest reportFrequency(String reportFrequency) {
        this.reportFrequency = reportFrequency;
        return this;
    }

    @ApiModelProperty(example="DAILY", required=true, value="'The frequency for which subscription is created.' **NOTE: Do not document USER_DEFINED Frequency field in developer center** Valid Values:   - 'DAILY'   - 'WEEKLY'   - 'MONTHLY'   - 'USER_DEFINED' ")
    public String getReportFrequency() {
        return this.reportFrequency;
    }

    public void setReportFrequency(String reportFrequency) {
        this.reportFrequency = reportFrequency;
    }

    public CreateReportSubscriptionRequest reportInterval(String reportInterval) {
        this.reportInterval = reportInterval;
        return this;
    }

    @ApiModelProperty(value="If the reportFrequency is User-defined, reportInterval should be in **ISO 8601 time format** Please refer the following link to know more about ISO 8601 format.[Rfc Time Format](https://en.wikipedia.org/wiki/ISO_8601#Durations)  **Example time format for 2 hours and 30 Mins:**   - PT2H30M **NOTE: Do not document reportInterval field in developer center** ")
    public String getReportInterval() {
        return this.reportInterval;
    }

    public void setReportInterval(String reportInterval) {
        this.reportInterval = reportInterval;
    }

    public CreateReportSubscriptionRequest reportName(String reportName) {
        this.reportName = reportName;
        return this;
    }

    @ApiModelProperty(example="My Daily Subscription", required=true, value="")
    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public CreateReportSubscriptionRequest timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @ApiModelProperty(example="America/Chicago", required=true, value="")
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public CreateReportSubscriptionRequest startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="0900", required=true, value="The hour at which the report generation should start. It should be in hhmm format.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public CreateReportSubscriptionRequest startDay(Integer startDay) {
        this.startDay = startDay;
        return this;
    }

    @ApiModelProperty(value="This is the start day if the frequency is WEEKLY or MONTHLY. The value varies from 1-7 for WEEKLY and 1-31 for MONTHLY. For WEEKLY 1 means Sunday and 7 means Saturday. By default the value is 1.")
    public Integer getStartDay() {
        return this.startDay;
    }

    public void setStartDay(Integer startDay) {
        this.startDay = startDay;
    }

    public CreateReportSubscriptionRequest reportFilters(Map<String, List<String>> reportFilters) {
        this.reportFilters = reportFilters;
        return this;
    }

    public CreateReportSubscriptionRequest putReportFiltersItem(String key, List<String> reportFiltersItem) {
        if (this.reportFilters == null) {
            this.reportFilters = new HashMap<String, List<String>>();
        }
        this.reportFilters.put(key, reportFiltersItem);
        return this;
    }

    @ApiModelProperty(example="{\"Application.Name\":[\"ics_auth\",\"ics_bill\"]}", value="List of filters to apply")
    public Map<String, List<String>> getReportFilters() {
        return this.reportFilters;
    }

    public void setReportFilters(Map<String, List<String>> reportFilters) {
        this.reportFilters = reportFilters;
    }

    public CreateReportSubscriptionRequest reportPreferences(Reportingv3reportsReportPreferences reportPreferences) {
        this.reportPreferences = reportPreferences;
        return this;
    }

    @ApiModelProperty(value="")
    public Reportingv3reportsReportPreferences getReportPreferences() {
        return this.reportPreferences;
    }

    public void setReportPreferences(Reportingv3reportsReportPreferences reportPreferences) {
        this.reportPreferences = reportPreferences;
    }

    public CreateReportSubscriptionRequest groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @ApiModelProperty(example="CEMEA Group", value="Valid GroupName")
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateReportSubscriptionRequest createReportSubscriptionRequest = (CreateReportSubscriptionRequest)o;
        return Objects.equals(this.organizationId, createReportSubscriptionRequest.organizationId) && Objects.equals(this.reportDefinitionName, createReportSubscriptionRequest.reportDefinitionName) && Objects.equals(this.reportFields, createReportSubscriptionRequest.reportFields) && Objects.equals(this.reportMimeType, createReportSubscriptionRequest.reportMimeType) && Objects.equals(this.reportFrequency, createReportSubscriptionRequest.reportFrequency) && Objects.equals(this.reportInterval, createReportSubscriptionRequest.reportInterval) && Objects.equals(this.reportName, createReportSubscriptionRequest.reportName) && Objects.equals(this.timezone, createReportSubscriptionRequest.timezone) && Objects.equals(this.startTime, createReportSubscriptionRequest.startTime) && Objects.equals(this.startDay, createReportSubscriptionRequest.startDay) && Objects.equals(this.reportFilters, createReportSubscriptionRequest.reportFilters) && Objects.equals(this.reportPreferences, createReportSubscriptionRequest.reportPreferences) && Objects.equals(this.groupName, createReportSubscriptionRequest.groupName);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.reportDefinitionName, this.reportFields, this.reportMimeType, this.reportFrequency, this.reportInterval, this.reportName, this.timezone, this.startTime, this.startDay, this.reportFilters, this.reportPreferences, this.groupName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateReportSubscriptionRequest {\n");
        sb.append("    organizationId: ").append(this.toIndentedString(this.organizationId)).append("\n");
        sb.append("    reportDefinitionName: ").append(this.toIndentedString(this.reportDefinitionName)).append("\n");
        sb.append("    reportFields: ").append(this.toIndentedString(this.reportFields)).append("\n");
        sb.append("    reportMimeType: ").append(this.toIndentedString(this.reportMimeType)).append("\n");
        sb.append("    reportFrequency: ").append(this.toIndentedString(this.reportFrequency)).append("\n");
        sb.append("    reportInterval: ").append(this.toIndentedString(this.reportInterval)).append("\n");
        sb.append("    reportName: ").append(this.toIndentedString(this.reportName)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    startDay: ").append(this.toIndentedString(this.startDay)).append("\n");
        sb.append("    reportFilters: ").append(this.toIndentedString(this.reportFilters)).append("\n");
        sb.append("    reportPreferences: ").append(this.toIndentedString(this.reportPreferences)).append("\n");
        sb.append("    groupName: ").append(this.toIndentedString(this.groupName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

