/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.PatchCustomerShippingAddressRequest;
import Model.PostCustomerShippingAddressRequest;
import Model.ShippingAddressListForCustomer;
import Model.Tmsv2customersEmbeddedDefaultShippingAddress;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomerShippingAddressApi {
    private static Logger logger = LogManager.getLogger(CustomerShippingAddressApi.class);
    private ApiClient apiClient;

    public CustomerShippingAddressApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomerShippingAddressApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteCustomerShippingAddressCall(String customerTokenId, String shippingAddressTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tms/v2/customers/{customerTokenId}/shipping-addresses/{shippingAddressTokenId}".replaceAll("\\{customerTokenId\\}", this.apiClient.escapeString(customerTokenId.toString())).replaceAll("\\{shippingAddressTokenId\\}", this.apiClient.escapeString(shippingAddressTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCustomerShippingAddressValidateBeforeCall(String customerTokenId, String shippingAddressTokenId, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerTokenId == null) {
            logger.error("Missing the required parameter 'customerTokenId' when calling deleteCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling deleteCustomerShippingAddress(Async)");
        }
        if (shippingAddressTokenId == null) {
            logger.error("Missing the required parameter 'shippingAddressTokenId' when calling deleteCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'shippingAddressTokenId' when calling deleteCustomerShippingAddress(Async)");
        }
        Call call = this.deleteCustomerShippingAddressCall(customerTokenId, shippingAddressTokenId, profileId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteCustomerShippingAddress(String customerTokenId, String shippingAddressTokenId, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'deleteCustomerShippingAddress' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        this.deleteCustomerShippingAddressWithHttpInfo(customerTokenId, shippingAddressTokenId, profileId);
    }

    public ApiResponse<Void> deleteCustomerShippingAddressWithHttpInfo(String customerTokenId, String shippingAddressTokenId, String profileId) throws ApiException {
        Call call = this.deleteCustomerShippingAddressValidateBeforeCall(customerTokenId, shippingAddressTokenId, profileId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCustomerShippingAddressAsync(String customerTokenId, String shippingAddressTokenId, String profileId, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCustomerShippingAddressValidateBeforeCall(customerTokenId, shippingAddressTokenId, profileId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getCustomerShippingAddressCall(String customerTokenId, String shippingAddressTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tms/v2/customers/{customerTokenId}/shipping-addresses/{shippingAddressTokenId}".replaceAll("\\{customerTokenId\\}", this.apiClient.escapeString(customerTokenId.toString())).replaceAll("\\{shippingAddressTokenId\\}", this.apiClient.escapeString(shippingAddressTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomerShippingAddressValidateBeforeCall(String customerTokenId, String shippingAddressTokenId, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerTokenId == null) {
            logger.error("Missing the required parameter 'customerTokenId' when calling getCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling getCustomerShippingAddress(Async)");
        }
        if (shippingAddressTokenId == null) {
            logger.error("Missing the required parameter 'shippingAddressTokenId' when calling getCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'shippingAddressTokenId' when calling getCustomerShippingAddress(Async)");
        }
        Call call = this.getCustomerShippingAddressCall(customerTokenId, shippingAddressTokenId, profileId, progressListener, progressRequestListener);
        return call;
    }

    public Tmsv2customersEmbeddedDefaultShippingAddress getCustomerShippingAddress(String customerTokenId, String shippingAddressTokenId, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'getCustomerShippingAddress' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultShippingAddress> resp = this.getCustomerShippingAddressWithHttpInfo(customerTokenId, shippingAddressTokenId, profileId);
        logger.info("CALL TO METHOD 'getCustomerShippingAddress' ENDED");
        return resp.getData();
    }

    public ApiResponse<Tmsv2customersEmbeddedDefaultShippingAddress> getCustomerShippingAddressWithHttpInfo(String customerTokenId, String shippingAddressTokenId, String profileId) throws ApiException {
        Call call = this.getCustomerShippingAddressValidateBeforeCall(customerTokenId, shippingAddressTokenId, profileId, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultShippingAddress>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomerShippingAddressAsync(String customerTokenId, String shippingAddressTokenId, String profileId, final ApiCallback<Tmsv2customersEmbeddedDefaultShippingAddress> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomerShippingAddressValidateBeforeCall(customerTokenId, shippingAddressTokenId, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultShippingAddress>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCustomerShippingAddressesListCall(String customerTokenId, String profileId, Long offset, Long limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tms/v2/customers/{customerTokenId}/shipping-addresses".replaceAll("\\{customerTokenId\\}", this.apiClient.escapeString(customerTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomerShippingAddressesListValidateBeforeCall(String customerTokenId, String profileId, Long offset, Long limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerTokenId == null) {
            logger.error("Missing the required parameter 'customerTokenId' when calling getCustomerShippingAddressesList(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling getCustomerShippingAddressesList(Async)");
        }
        Call call = this.getCustomerShippingAddressesListCall(customerTokenId, profileId, offset, limit, progressListener, progressRequestListener);
        return call;
    }

    public ShippingAddressListForCustomer getCustomerShippingAddressesList(String customerTokenId, String profileId, Long offset, Long limit) throws ApiException {
        logger.info("CALL TO METHOD 'getCustomerShippingAddressesList' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<ShippingAddressListForCustomer> resp = this.getCustomerShippingAddressesListWithHttpInfo(customerTokenId, profileId, offset, limit);
        logger.info("CALL TO METHOD 'getCustomerShippingAddressesList' ENDED");
        return resp.getData();
    }

    public ApiResponse<ShippingAddressListForCustomer> getCustomerShippingAddressesListWithHttpInfo(String customerTokenId, String profileId, Long offset, Long limit) throws ApiException {
        Call call = this.getCustomerShippingAddressesListValidateBeforeCall(customerTokenId, profileId, offset, limit, null, null);
        Type localVarReturnType = new TypeToken<ShippingAddressListForCustomer>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomerShippingAddressesListAsync(String customerTokenId, String profileId, Long offset, Long limit, final ApiCallback<ShippingAddressListForCustomer> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomerShippingAddressesListValidateBeforeCall(customerTokenId, profileId, offset, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ShippingAddressListForCustomer>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchCustomersShippingAddressCall(String customerTokenId, String shippingAddressTokenId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PatchCustomerShippingAddressRequest localVarPostBody = patchCustomerShippingAddressRequest;
        String localVarPath = "/tms/v2/customers/{customerTokenId}/shipping-addresses/{shippingAddressTokenId}".replaceAll("\\{customerTokenId\\}", this.apiClient.escapeString(customerTokenId.toString())).replaceAll("\\{shippingAddressTokenId\\}", this.apiClient.escapeString(shippingAddressTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("if-match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchCustomersShippingAddressValidateBeforeCall(String customerTokenId, String shippingAddressTokenId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerTokenId == null) {
            logger.error("Missing the required parameter 'customerTokenId' when calling patchCustomersShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling patchCustomersShippingAddress(Async)");
        }
        if (shippingAddressTokenId == null) {
            logger.error("Missing the required parameter 'shippingAddressTokenId' when calling patchCustomersShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'shippingAddressTokenId' when calling patchCustomersShippingAddress(Async)");
        }
        if (patchCustomerShippingAddressRequest == null) {
            logger.error("Missing the required parameter 'patchCustomerShippingAddressRequest' when calling patchCustomersShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'patchCustomerShippingAddressRequest' when calling patchCustomersShippingAddress(Async)");
        }
        Call call = this.patchCustomersShippingAddressCall(customerTokenId, shippingAddressTokenId, patchCustomerShippingAddressRequest, profileId, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public Tmsv2customersEmbeddedDefaultShippingAddress patchCustomersShippingAddress(String customerTokenId, String shippingAddressTokenId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch) throws ApiException {
        logger.info("CALL TO METHOD 'patchCustomersShippingAddress' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultShippingAddress> resp = this.patchCustomersShippingAddressWithHttpInfo(customerTokenId, shippingAddressTokenId, patchCustomerShippingAddressRequest, profileId, ifMatch);
        logger.info("CALL TO METHOD 'patchCustomersShippingAddress' ENDED");
        return resp.getData();
    }

    public ApiResponse<Tmsv2customersEmbeddedDefaultShippingAddress> patchCustomersShippingAddressWithHttpInfo(String customerTokenId, String shippingAddressTokenId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch) throws ApiException {
        Call call = this.patchCustomersShippingAddressValidateBeforeCall(customerTokenId, shippingAddressTokenId, patchCustomerShippingAddressRequest, profileId, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultShippingAddress>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchCustomersShippingAddressAsync(String customerTokenId, String shippingAddressTokenId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch, final ApiCallback<Tmsv2customersEmbeddedDefaultShippingAddress> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchCustomersShippingAddressValidateBeforeCall(customerTokenId, shippingAddressTokenId, patchCustomerShippingAddressRequest, profileId, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultShippingAddress>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postCustomerShippingAddressCall(String customerTokenId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PostCustomerShippingAddressRequest localVarPostBody = postCustomerShippingAddressRequest;
        String localVarPath = "/tms/v2/customers/{customerTokenId}/shipping-addresses".replaceAll("\\{customerTokenId\\}", this.apiClient.escapeString(customerTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postCustomerShippingAddressValidateBeforeCall(String customerTokenId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerTokenId == null) {
            logger.error("Missing the required parameter 'customerTokenId' when calling postCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling postCustomerShippingAddress(Async)");
        }
        if (postCustomerShippingAddressRequest == null) {
            logger.error("Missing the required parameter 'postCustomerShippingAddressRequest' when calling postCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'postCustomerShippingAddressRequest' when calling postCustomerShippingAddress(Async)");
        }
        Call call = this.postCustomerShippingAddressCall(customerTokenId, postCustomerShippingAddressRequest, profileId, progressListener, progressRequestListener);
        return call;
    }

    public Tmsv2customersEmbeddedDefaultShippingAddress postCustomerShippingAddress(String customerTokenId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'postCustomerShippingAddress' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultShippingAddress> resp = this.postCustomerShippingAddressWithHttpInfo(customerTokenId, postCustomerShippingAddressRequest, profileId);
        logger.info("CALL TO METHOD 'postCustomerShippingAddress' ENDED");
        return resp.getData();
    }

    public ApiResponse<Tmsv2customersEmbeddedDefaultShippingAddress> postCustomerShippingAddressWithHttpInfo(String customerTokenId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId) throws ApiException {
        Call call = this.postCustomerShippingAddressValidateBeforeCall(customerTokenId, postCustomerShippingAddressRequest, profileId, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultShippingAddress>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postCustomerShippingAddressAsync(String customerTokenId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId, final ApiCallback<Tmsv2customersEmbeddedDefaultShippingAddress> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postCustomerShippingAddressValidateBeforeCall(customerTokenId, postCustomerShippingAddressRequest, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultShippingAddress>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

