/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.PatchCustomerRequest;
import Model.PostCustomerRequest;
import Model.TmsV2CustomersResponse;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomerApi {
    private static Logger logger = LogManager.getLogger(CustomerApi.class);
    private ApiClient apiClient;

    public CustomerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteCustomerCall(String customerTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tms/v2/customers/{customerTokenId}".replaceAll("\\{customerTokenId\\}", this.apiClient.escapeString(customerTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCustomerValidateBeforeCall(String customerTokenId, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerTokenId == null) {
            logger.error("Missing the required parameter 'customerTokenId' when calling deleteCustomer(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling deleteCustomer(Async)");
        }
        Call call = this.deleteCustomerCall(customerTokenId, profileId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteCustomer(String customerTokenId, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'deleteCustomer' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        this.deleteCustomerWithHttpInfo(customerTokenId, profileId);
    }

    public ApiResponse<Void> deleteCustomerWithHttpInfo(String customerTokenId, String profileId) throws ApiException {
        Call call = this.deleteCustomerValidateBeforeCall(customerTokenId, profileId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCustomerAsync(String customerTokenId, String profileId, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCustomerValidateBeforeCall(customerTokenId, profileId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getCustomerCall(String customerTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tms/v2/customers/{customerTokenId}".replaceAll("\\{customerTokenId\\}", this.apiClient.escapeString(customerTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomerValidateBeforeCall(String customerTokenId, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerTokenId == null) {
            logger.error("Missing the required parameter 'customerTokenId' when calling getCustomer(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling getCustomer(Async)");
        }
        Call call = this.getCustomerCall(customerTokenId, profileId, progressListener, progressRequestListener);
        return call;
    }

    public TmsV2CustomersResponse getCustomer(String customerTokenId, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'getCustomer' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<TmsV2CustomersResponse> resp = this.getCustomerWithHttpInfo(customerTokenId, profileId);
        logger.info("CALL TO METHOD 'getCustomer' ENDED");
        return resp.getData();
    }

    public ApiResponse<TmsV2CustomersResponse> getCustomerWithHttpInfo(String customerTokenId, String profileId) throws ApiException {
        Call call = this.getCustomerValidateBeforeCall(customerTokenId, profileId, null, null);
        Type localVarReturnType = new TypeToken<TmsV2CustomersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomerAsync(String customerTokenId, String profileId, final ApiCallback<TmsV2CustomersResponse> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomerValidateBeforeCall(customerTokenId, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TmsV2CustomersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchCustomerCall(String customerTokenId, PatchCustomerRequest patchCustomerRequest, String profileId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PatchCustomerRequest localVarPostBody = patchCustomerRequest;
        String localVarPath = "/tms/v2/customers/{customerTokenId}".replaceAll("\\{customerTokenId\\}", this.apiClient.escapeString(customerTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("if-match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchCustomerValidateBeforeCall(String customerTokenId, PatchCustomerRequest patchCustomerRequest, String profileId, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerTokenId == null) {
            logger.error("Missing the required parameter 'customerTokenId' when calling patchCustomer(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling patchCustomer(Async)");
        }
        if (patchCustomerRequest == null) {
            logger.error("Missing the required parameter 'patchCustomerRequest' when calling patchCustomer(Async)");
            throw new ApiException("Missing the required parameter 'patchCustomerRequest' when calling patchCustomer(Async)");
        }
        Call call = this.patchCustomerCall(customerTokenId, patchCustomerRequest, profileId, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public TmsV2CustomersResponse patchCustomer(String customerTokenId, PatchCustomerRequest patchCustomerRequest, String profileId, String ifMatch) throws ApiException {
        logger.info("CALL TO METHOD 'patchCustomer' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<TmsV2CustomersResponse> resp = this.patchCustomerWithHttpInfo(customerTokenId, patchCustomerRequest, profileId, ifMatch);
        logger.info("CALL TO METHOD 'patchCustomer' ENDED");
        return resp.getData();
    }

    public ApiResponse<TmsV2CustomersResponse> patchCustomerWithHttpInfo(String customerTokenId, PatchCustomerRequest patchCustomerRequest, String profileId, String ifMatch) throws ApiException {
        Call call = this.patchCustomerValidateBeforeCall(customerTokenId, patchCustomerRequest, profileId, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<TmsV2CustomersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchCustomerAsync(String customerTokenId, PatchCustomerRequest patchCustomerRequest, String profileId, String ifMatch, final ApiCallback<TmsV2CustomersResponse> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchCustomerValidateBeforeCall(customerTokenId, patchCustomerRequest, profileId, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TmsV2CustomersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postCustomerCall(PostCustomerRequest postCustomerRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PostCustomerRequest localVarPostBody = postCustomerRequest;
        String localVarPath = "/tms/v2/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postCustomerValidateBeforeCall(PostCustomerRequest postCustomerRequest, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (postCustomerRequest == null) {
            logger.error("Missing the required parameter 'postCustomerRequest' when calling postCustomer(Async)");
            throw new ApiException("Missing the required parameter 'postCustomerRequest' when calling postCustomer(Async)");
        }
        Call call = this.postCustomerCall(postCustomerRequest, profileId, progressListener, progressRequestListener);
        return call;
    }

    public TmsV2CustomersResponse postCustomer(PostCustomerRequest postCustomerRequest, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'postCustomer' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<TmsV2CustomersResponse> resp = this.postCustomerWithHttpInfo(postCustomerRequest, profileId);
        logger.info("CALL TO METHOD 'postCustomer' ENDED");
        return resp.getData();
    }

    public ApiResponse<TmsV2CustomersResponse> postCustomerWithHttpInfo(PostCustomerRequest postCustomerRequest, String profileId) throws ApiException {
        Call call = this.postCustomerValidateBeforeCall(postCustomerRequest, profileId, null, null);
        Type localVarReturnType = new TypeToken<TmsV2CustomersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postCustomerAsync(PostCustomerRequest postCustomerRequest, String profileId, final ApiCallback<TmsV2CustomersResponse> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postCustomerValidateBeforeCall(postCustomerRequest, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TmsV2CustomersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

