/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;
import java.io.InputStream;


import Model.InlineResponse400;
import Model.PatchCustomerShippingAddressRequest;
import Model.PostCustomerShippingAddressRequest;
import Model.ShippingAddressListForCustomer;
import Model.Tmsv2customersEmbeddedDefaultShippingAddress;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomerShippingAddressApi {
    private static Logger logger = LogManager.getLogger(CustomerShippingAddressApi.class);
    
    private ApiClient apiClient;

    public CustomerShippingAddressApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomerShippingAddressApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deleteCustomerShippingAddress
     * @param customerTokenId The TokenId of a customer. (required)
     * @param shippingAddressTokenId The TokenId of an shipping address. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call deleteCustomerShippingAddressCall(String customerTokenId, String shippingAddressTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tms/v2/customers/{customerTokenId}/shipping-addresses/{shippingAddressTokenId}"
            .replaceAll("\\{" + "customerTokenId" + "\\}", apiClient.escapeString(customerTokenId.toString()))
            .replaceAll("\\{" + "shippingAddressTokenId" + "\\}", apiClient.escapeString(shippingAddressTokenId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteCustomerShippingAddressValidateBeforeCall(String customerTokenId, String shippingAddressTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'customerTokenId' is set
        if (customerTokenId == null) {
        	logger.error("Missing the required parameter 'customerTokenId' when calling deleteCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling deleteCustomerShippingAddress(Async)");
        }
        
        // verify the required parameter 'shippingAddressTokenId' is set
        if (shippingAddressTokenId == null) {
        	logger.error("Missing the required parameter 'shippingAddressTokenId' when calling deleteCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'shippingAddressTokenId' when calling deleteCustomerShippingAddress(Async)");
        }
        
        
        okhttp3.Call call = deleteCustomerShippingAddressCall(customerTokenId, shippingAddressTokenId, profileId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Delete a Customer Shipping Address
     * 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param shippingAddressTokenId The TokenId of an shipping address. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteCustomerShippingAddress(String customerTokenId, String shippingAddressTokenId, String profileId) throws ApiException {
    	logger.info("CALL TO METHOD 'deleteCustomerShippingAddress' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        deleteCustomerShippingAddressWithHttpInfo(customerTokenId, shippingAddressTokenId, profileId);
    }

    /**
     * Delete a Customer Shipping Address
     * 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param shippingAddressTokenId The TokenId of an shipping address. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteCustomerShippingAddressWithHttpInfo(String customerTokenId, String shippingAddressTokenId, String profileId) throws ApiException {
        okhttp3.Call call = deleteCustomerShippingAddressValidateBeforeCall(customerTokenId, shippingAddressTokenId, profileId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a Customer Shipping Address (asynchronously)
     * 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param shippingAddressTokenId The TokenId of an shipping address. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call deleteCustomerShippingAddressAsync(String customerTokenId, String shippingAddressTokenId, String profileId, final ApiCallback<Void> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = deleteCustomerShippingAddressValidateBeforeCall(customerTokenId, shippingAddressTokenId, profileId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for getCustomerShippingAddress
     * @param customerTokenId The TokenId of a customer. (required)
     * @param shippingAddressTokenId The TokenId of an shipping address. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call getCustomerShippingAddressCall(String customerTokenId, String shippingAddressTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tms/v2/customers/{customerTokenId}/shipping-addresses/{shippingAddressTokenId}"
            .replaceAll("\\{" + "customerTokenId" + "\\}", apiClient.escapeString(customerTokenId.toString()))
            .replaceAll("\\{" + "shippingAddressTokenId" + "\\}", apiClient.escapeString(shippingAddressTokenId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCustomerShippingAddressValidateBeforeCall(String customerTokenId, String shippingAddressTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'customerTokenId' is set
        if (customerTokenId == null) {
        	logger.error("Missing the required parameter 'customerTokenId' when calling getCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling getCustomerShippingAddress(Async)");
        }
        
        // verify the required parameter 'shippingAddressTokenId' is set
        if (shippingAddressTokenId == null) {
        	logger.error("Missing the required parameter 'shippingAddressTokenId' when calling getCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'shippingAddressTokenId' when calling getCustomerShippingAddress(Async)");
        }
        
        
        okhttp3.Call call = getCustomerShippingAddressCall(customerTokenId, shippingAddressTokenId, profileId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Retrieve a Customer Shipping Address
     * 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param shippingAddressTokenId The TokenId of an shipping address. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return Tmsv2customersEmbeddedDefaultShippingAddress
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Tmsv2customersEmbeddedDefaultShippingAddress getCustomerShippingAddress(String customerTokenId, String shippingAddressTokenId, String profileId) throws ApiException {
    	logger.info("CALL TO METHOD 'getCustomerShippingAddress' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultShippingAddress> resp = getCustomerShippingAddressWithHttpInfo(customerTokenId, shippingAddressTokenId, profileId);
        logger.info("CALL TO METHOD 'getCustomerShippingAddress' ENDED");
        return resp.getData();
    }

    /**
     * Retrieve a Customer Shipping Address
     * 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param shippingAddressTokenId The TokenId of an shipping address. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return ApiResponse&lt;Tmsv2customersEmbeddedDefaultShippingAddress&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Tmsv2customersEmbeddedDefaultShippingAddress> getCustomerShippingAddressWithHttpInfo(String customerTokenId, String shippingAddressTokenId, String profileId) throws ApiException {
        okhttp3.Call call = getCustomerShippingAddressValidateBeforeCall(customerTokenId, shippingAddressTokenId, profileId, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultShippingAddress>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Retrieve a Customer Shipping Address (asynchronously)
     * 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param shippingAddressTokenId The TokenId of an shipping address. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call getCustomerShippingAddressAsync(String customerTokenId, String shippingAddressTokenId, String profileId, final ApiCallback<Tmsv2customersEmbeddedDefaultShippingAddress> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = getCustomerShippingAddressValidateBeforeCall(customerTokenId, shippingAddressTokenId, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultShippingAddress>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getCustomerShippingAddressesList
     * @param customerTokenId The TokenId of a customer. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param offset Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0. (optional, default to 0)
     * @param limit The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100. (optional, default to 20)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call getCustomerShippingAddressesListCall(String customerTokenId, String profileId, Long offset, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/tms/v2/customers/{customerTokenId}/shipping-addresses"
            .replaceAll("\\{" + "customerTokenId" + "\\}", apiClient.escapeString(customerTokenId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCustomerShippingAddressesListValidateBeforeCall(String customerTokenId, String profileId, Long offset, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'customerTokenId' is set
        if (customerTokenId == null) {
        	logger.error("Missing the required parameter 'customerTokenId' when calling getCustomerShippingAddressesList(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling getCustomerShippingAddressesList(Async)");
        }
        
        
        okhttp3.Call call = getCustomerShippingAddressesListCall(customerTokenId, profileId, offset, limit, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * List Shipping Addresses for a Customer
     * 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param offset Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0. (optional, default to 0)
     * @param limit The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100. (optional, default to 20)
     * @return ShippingAddressListForCustomer
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ShippingAddressListForCustomer getCustomerShippingAddressesList(String customerTokenId, String profileId, Long offset, Long limit) throws ApiException {
    	logger.info("CALL TO METHOD 'getCustomerShippingAddressesList' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<ShippingAddressListForCustomer> resp = getCustomerShippingAddressesListWithHttpInfo(customerTokenId, profileId, offset, limit);
        logger.info("CALL TO METHOD 'getCustomerShippingAddressesList' ENDED");
        return resp.getData();
    }

    /**
     * List Shipping Addresses for a Customer
     * 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param offset Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0. (optional, default to 0)
     * @param limit The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100. (optional, default to 20)
     * @return ApiResponse&lt;ShippingAddressListForCustomer&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ShippingAddressListForCustomer> getCustomerShippingAddressesListWithHttpInfo(String customerTokenId, String profileId, Long offset, Long limit) throws ApiException {
        okhttp3.Call call = getCustomerShippingAddressesListValidateBeforeCall(customerTokenId, profileId, offset, limit, null, null);
        Type localVarReturnType = new TypeToken<ShippingAddressListForCustomer>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List Shipping Addresses for a Customer (asynchronously)
     * 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param offset Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0. (optional, default to 0)
     * @param limit The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100. (optional, default to 20)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call getCustomerShippingAddressesListAsync(String customerTokenId, String profileId, Long offset, Long limit, final ApiCallback<ShippingAddressListForCustomer> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = getCustomerShippingAddressesListValidateBeforeCall(customerTokenId, profileId, offset, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ShippingAddressListForCustomer>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for patchCustomersShippingAddress
     * @param customerTokenId The TokenId of a customer. (required)
     * @param shippingAddressTokenId The TokenId of an shipping address. (required)
     * @param patchCustomerShippingAddressRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call patchCustomersShippingAddressCall(String customerTokenId, String shippingAddressTokenId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = patchCustomerShippingAddressRequest;
        
        // create path and map variables
        String localVarPath = "/tms/v2/customers/{customerTokenId}/shipping-addresses/{shippingAddressTokenId}"
            .replaceAll("\\{" + "customerTokenId" + "\\}", apiClient.escapeString(customerTokenId.toString()))
            .replaceAll("\\{" + "shippingAddressTokenId" + "\\}", apiClient.escapeString(shippingAddressTokenId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));
        if (ifMatch != null)
        localVarHeaderParams.put("if-match", apiClient.parameterToString(ifMatch));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call patchCustomersShippingAddressValidateBeforeCall(String customerTokenId, String shippingAddressTokenId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'customerTokenId' is set
        if (customerTokenId == null) {
        	logger.error("Missing the required parameter 'customerTokenId' when calling patchCustomersShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling patchCustomersShippingAddress(Async)");
        }
        
        // verify the required parameter 'shippingAddressTokenId' is set
        if (shippingAddressTokenId == null) {
        	logger.error("Missing the required parameter 'shippingAddressTokenId' when calling patchCustomersShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'shippingAddressTokenId' when calling patchCustomersShippingAddress(Async)");
        }
        
        // verify the required parameter 'patchCustomerShippingAddressRequest' is set
        if (patchCustomerShippingAddressRequest == null) {
        	logger.error("Missing the required parameter 'patchCustomerShippingAddressRequest' when calling patchCustomersShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'patchCustomerShippingAddressRequest' when calling patchCustomersShippingAddress(Async)");
        }
        
        
        okhttp3.Call call = patchCustomersShippingAddressCall(customerTokenId, shippingAddressTokenId, patchCustomerShippingAddressRequest, profileId, ifMatch, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Update a Customer Shipping Address
     * 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param shippingAddressTokenId The TokenId of an shipping address. (required)
     * @param patchCustomerShippingAddressRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @return Tmsv2customersEmbeddedDefaultShippingAddress
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Tmsv2customersEmbeddedDefaultShippingAddress patchCustomersShippingAddress(String customerTokenId, String shippingAddressTokenId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch) throws ApiException {
    	logger.info("CALL TO METHOD 'patchCustomersShippingAddress' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultShippingAddress> resp = patchCustomersShippingAddressWithHttpInfo(customerTokenId, shippingAddressTokenId, patchCustomerShippingAddressRequest, profileId, ifMatch);
        logger.info("CALL TO METHOD 'patchCustomersShippingAddress' ENDED");
        return resp.getData();
    }

    /**
     * Update a Customer Shipping Address
     * 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param shippingAddressTokenId The TokenId of an shipping address. (required)
     * @param patchCustomerShippingAddressRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @return ApiResponse&lt;Tmsv2customersEmbeddedDefaultShippingAddress&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Tmsv2customersEmbeddedDefaultShippingAddress> patchCustomersShippingAddressWithHttpInfo(String customerTokenId, String shippingAddressTokenId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch) throws ApiException {
        okhttp3.Call call = patchCustomersShippingAddressValidateBeforeCall(customerTokenId, shippingAddressTokenId, patchCustomerShippingAddressRequest, profileId, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultShippingAddress>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update a Customer Shipping Address (asynchronously)
     * 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param shippingAddressTokenId The TokenId of an shipping address. (required)
     * @param patchCustomerShippingAddressRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call patchCustomersShippingAddressAsync(String customerTokenId, String shippingAddressTokenId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch, final ApiCallback<Tmsv2customersEmbeddedDefaultShippingAddress> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = patchCustomersShippingAddressValidateBeforeCall(customerTokenId, shippingAddressTokenId, patchCustomerShippingAddressRequest, profileId, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultShippingAddress>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postCustomerShippingAddress
     * @param customerTokenId The TokenId of a customer. (required)
     * @param postCustomerShippingAddressRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call postCustomerShippingAddressCall(String customerTokenId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = postCustomerShippingAddressRequest;
        
        // create path and map variables
        String localVarPath = "/tms/v2/customers/{customerTokenId}/shipping-addresses"
            .replaceAll("\\{" + "customerTokenId" + "\\}", apiClient.escapeString(customerTokenId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null)
        localVarHeaderParams.put("profile-id", apiClient.parameterToString(profileId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call postCustomerShippingAddressValidateBeforeCall(String customerTokenId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'customerTokenId' is set
        if (customerTokenId == null) {
        	logger.error("Missing the required parameter 'customerTokenId' when calling postCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling postCustomerShippingAddress(Async)");
        }
        
        // verify the required parameter 'postCustomerShippingAddressRequest' is set
        if (postCustomerShippingAddressRequest == null) {
        	logger.error("Missing the required parameter 'postCustomerShippingAddressRequest' when calling postCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'postCustomerShippingAddressRequest' when calling postCustomerShippingAddress(Async)");
        }
        
        
        okhttp3.Call call = postCustomerShippingAddressCall(customerTokenId, postCustomerShippingAddressRequest, profileId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Create a Customer Shipping Address
     * Include an existing TMS Customer token id in the request URI. * A Customer token can be created by calling: **POST *_/tms/v2/customers*** 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param postCustomerShippingAddressRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return Tmsv2customersEmbeddedDefaultShippingAddress
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Tmsv2customersEmbeddedDefaultShippingAddress postCustomerShippingAddress(String customerTokenId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId) throws ApiException {
    	logger.info("CALL TO METHOD 'postCustomerShippingAddress' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultShippingAddress> resp = postCustomerShippingAddressWithHttpInfo(customerTokenId, postCustomerShippingAddressRequest, profileId);
        logger.info("CALL TO METHOD 'postCustomerShippingAddress' ENDED");
        return resp.getData();
    }

    /**
     * Create a Customer Shipping Address
     * Include an existing TMS Customer token id in the request URI. * A Customer token can be created by calling: **POST *_/tms/v2/customers*** 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param postCustomerShippingAddressRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @return ApiResponse&lt;Tmsv2customersEmbeddedDefaultShippingAddress&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Tmsv2customersEmbeddedDefaultShippingAddress> postCustomerShippingAddressWithHttpInfo(String customerTokenId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId) throws ApiException {
        okhttp3.Call call = postCustomerShippingAddressValidateBeforeCall(customerTokenId, postCustomerShippingAddressRequest, profileId, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultShippingAddress>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a Customer Shipping Address (asynchronously)
     * Include an existing TMS Customer token id in the request URI. * A Customer token can be created by calling: **POST *_/tms/v2/customers*** 
     * @param customerTokenId The TokenId of a customer. (required)
     * @param postCustomerShippingAddressRequest  (required)
     * @param profileId The id of a profile containing user specific TMS configuration. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call postCustomerShippingAddressAsync(String customerTokenId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId, final ApiCallback<Tmsv2customersEmbeddedDefaultShippingAddress> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = postCustomerShippingAddressValidateBeforeCall(customerTokenId, postCustomerShippingAddressRequest, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultShippingAddress>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
