/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.payloaddigest;

import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.GlobalLabelParameters;
import com.cybersource.authsdk.util.Utility;
import java.security.MessageDigest;
import java.util.Base64;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class PayloadDigest {
    private String bluePrint = null;
    private String messageBody = null;
    private MerchantConfig merchantConfig = null;
    private Logger logger;
    private String sha256 = GlobalLabelParameters.SHA_256;

    public PayloadDigest(MerchantConfig merchantConfig) {
        this.merchantConfig = merchantConfig;
    }

    private String digestGeneration() {
        String messageBody = this.payloadGeneration();
        byte[] digestBytes = null;
        try {
            MessageDigest digestString = MessageDigest.getInstance(this.sha256);
            digestBytes = digestString.digest(messageBody.getBytes("UTF-8"));
        }
        catch (Exception e) {
            Utility.log(this.logger, "Digest generation failed", "", Level.FATAL);
            Utility.log(this.logger, e);
            return null;
        }
        this.bluePrint = Base64.getEncoder().encodeToString(digestBytes);
        this.bluePrint = this.sha256 + "=" + this.bluePrint;
        return this.bluePrint;
    }

    private String payloadGeneration() {
        this.messageBody = this.merchantConfig.getRequestData();
        return this.messageBody;
    }

    public String getPayLoad() {
        this.payloadGeneration();
        return this.messageBody;
    }

    public String getDigest() {
        this.digestGeneration();
        return this.bluePrint;
    }

    public String getMessageBody() {
        return this.messageBody;
    }
}

