/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.jwtsecurity;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyStoreUtil {
    private static Logger logger = LogManager.getLogger(KeyStoreUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey getPrivateKey(String keyStorePath, String keystorePassword, String privateKeyPassword, String keyAlias) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(keyStorePath);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, keystorePassword.toCharArray());
            Key key = keystore.getKey(keyAlias, privateKeyPassword.toCharArray());
            if (key instanceof PrivateKey) {
                PrivateKey privateKey = (PrivateKey)key;
                return privateKey;
            }
            PrivateKey privateKey = null;
            return privateKey;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            logger.error("Couldn't retrieve private key from keystore : {}\n{}", (Object)keyStorePath, (Object)e);
            PrivateKey privateKey = null;
            return privateKey;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                logger.error("Error while closing file input stream : {}\n{}", (Object)keyStorePath, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getX509Certificate(String keyStorePath, String keystorePassword, String alias) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(keyStorePath);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, keystorePassword.toCharArray());
            X509Certificate x509Certificate = (X509Certificate)keystore.getCertificate(alias);
            return x509Certificate;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.error("Couldn't retrieve public key from keystore : {}\n{}", (Object)keyStorePath, (Object)e);
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                logger.error("Error while closing file input stream : {}\n{}", (Object)keyStorePath, (Object)e);
            }
        }
    }
}

