/*
 * Decompiled with CFR 0.152.
 */
package com.cuelinks;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.Layout;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.view.MotionEvent;
import android.widget.TextView;
import com.cuelinks.CuelinksListener;
import com.cuelinks.CuelinksUtil;

public class CuelinksMovementMethod
extends LinkMovementMethod {
    @SuppressLint(value={"StaticFieldLeak"})
    private static CuelinksMovementMethod linkMovementMethod;
    private Context context;
    private CuelinksListener mCuelinksListener;
    private String[] mSubId;

    public static MovementMethod getInstance(Context context) {
        return CuelinksMovementMethod.getInstance(context, new String[]{null});
    }

    public static MovementMethod getInstance(Context c, String ... subId) {
        return CuelinksMovementMethod.getInstance(c, null, subId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MovementMethod getInstance(Context c, CuelinksListener listener, String ... subId) {
        Class<CuelinksMovementMethod> clazz = CuelinksMovementMethod.class;
        synchronized (CuelinksMovementMethod.class) {
            if (linkMovementMethod == null) {
                linkMovementMethod = new CuelinksMovementMethod();
            }
            CuelinksMovementMethod.linkMovementMethod.context = c;
            CuelinksMovementMethod.linkMovementMethod.mCuelinksListener = listener;
            CuelinksMovementMethod.linkMovementMethod.mSubId = subId;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return linkMovementMethod;
        }
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        int action = event.getAction();
        if (action == 1) {
            int line;
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            Layout layout = widget.getLayout();
            int off = layout.getOffsetForHorizontal(line = layout.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX()));
            URLSpan[] link = (URLSpan[])buffer.getSpans(off, off, URLSpan.class);
            if (link.length != 0) {
                String url = link[0].getURL();
                if (!url.startsWith("tel") && !url.startsWith("mailto")) {
                    url = CuelinksUtil.getAffiliatedUrl(url, this.mSubId);
                    if (this.mCuelinksListener == null) {
                        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                        if (this.context != null) {
                            intent.putExtra("com.android.browser.application_id", this.context.getPackageName());
                            this.context.startActivity(intent);
                        }
                    } else {
                        this.mCuelinksListener.openUrl(url, this.context);
                    }
                } else if (this.mCuelinksListener != null) {
                    this.mCuelinksListener.openUrl(url, this.context);
                }
                return true;
            }
        }
        return super.onTouchEvent(widget, buffer, event);
    }
}

