/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.client.service;

import com.ctrip.framework.apollo.openapi.client.service.AbstractOpenApiService;
import com.ctrip.framework.apollo.openapi.client.url.OpenApiPathBuilder;
import com.ctrip.framework.apollo.openapi.dto.OpenAppDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenCreateAppDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenEnvClusterDTO;
import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class AppOpenApiService
extends AbstractOpenApiService
implements com.ctrip.framework.apollo.openapi.api.AppOpenApiService {
    private static final Type OPEN_ENV_CLUSTER_DTO_LIST_TYPE = new TypeToken<List<OpenEnvClusterDTO>>(){}.getType();
    private static final Type OPEN_APP_DTO_LIST_TYPE = new TypeToken<List<OpenAppDTO>>(){}.getType();

    public AppOpenApiService(CloseableHttpClient client, String baseUrl, Gson gson) {
        super(client, baseUrl, gson);
    }

    @Override
    public void createApp(OpenCreateAppDTO req) {
        OpenAppDTO app = req.getApp();
        this.checkNotNull(app, "App");
        this.checkNotEmpty(app.getAppId(), "App id");
        this.checkNotEmpty(app.getName(), "App name");
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().customResource("apps");
        try (CloseableHttpResponse response = this.post(pathBuilder, req);){
            this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), Void.TYPE);
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Create app: %s for appId: %s failed", app.getName(), app.getAppId()), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<OpenEnvClusterDTO> getEnvClusterInfo(String appId) {
        this.checkNotEmpty(appId, "App id");
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().appsPathVal(appId).customResource("envclusters");
        try (CloseableHttpResponse response = this.get(pathBuilder);){
            List list = (List)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OPEN_ENV_CLUSTER_DTO_LIST_TYPE);
            return list;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Load env cluster information for appId: %s failed", appId), ex);
        }
    }

    @Override
    public List<OpenAppDTO> getAllApps() {
        return this.getAppsInfo(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<OpenAppDTO> getAppsInfo(List<String> appIds) {
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().customResource("apps");
        if (appIds != null && !appIds.isEmpty()) {
            String param = Joiner.on((String)",").join(appIds);
            pathBuilder.addParam("appIds", param);
        }
        try (CloseableHttpResponse response = this.get(pathBuilder);){
            List list = (List)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OPEN_APP_DTO_LIST_TYPE);
            return list;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Load app information for appIds: %s failed", appIds), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<OpenAppDTO> getAuthorizedApps() {
        OpenApiPathBuilder pathBuilder = OpenApiPathBuilder.newBuilder().customResource("apps/authorized");
        try (CloseableHttpResponse response = this.get(pathBuilder);){
            List list = (List)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OPEN_APP_DTO_LIST_TYPE);
            return list;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Load authorized apps failed", ex);
        }
    }
}

