/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time;

import com.cronutils.mapper.WeekDay;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.constraint.FieldConstraintsBuilder;
import com.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.QuestionMark;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.model.time.NearestValue;
import com.cronutils.model.time.TimeNode;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.FieldValueGeneratorFactory;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.cronutils.utils.Preconditions;
import com.cronutils.utils.Predicates;
import com.cronutils.utils.VisibleForTesting;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SingleExecutionTime
implements ExecutionTime {
    private static final int MAX_ITERATIONS = 100000;
    private static final LocalTime MAX_SECONDS = LocalTime.MAX.truncatedTo(ChronoUnit.SECONDS);
    private final CronDefinition cronDefinition;
    private final FieldValueGenerator yearsValueGenerator;
    private final CronField daysOfWeekCronField;
    private final CronField daysOfMonthCronField;
    private final CronField daysOfYearCronField;
    private final TimeNode months;
    private final TimeNode hours;
    private final TimeNode minutes;
    private final TimeNode seconds;

    @VisibleForTesting
    SingleExecutionTime(CronDefinition cronDefinition, CronField yearsValueCronField, CronField daysOfWeekCronField, CronField daysOfMonthCronField, CronField daysOfYearCronField, TimeNode months, TimeNode hours, TimeNode minutes, TimeNode seconds) {
        this.cronDefinition = Preconditions.checkNotNull(cronDefinition);
        FieldValueGenerator alwaysGenerator = FieldValueGeneratorFactory.forCronField(new CronField(CronFieldName.YEAR, Always.always(), FieldConstraintsBuilder.instance().createConstraintsInstance()));
        if (cronDefinition.containsFieldDefinition(CronFieldName.YEAR)) {
            if (!cronDefinition.getFieldDefinition(CronFieldName.YEAR).isOptional()) {
                Preconditions.checkNotNull(yearsValueCronField);
            }
            this.yearsValueGenerator = yearsValueCronField == null ? alwaysGenerator : FieldValueGeneratorFactory.createYearValueGeneratorInstance(yearsValueCronField);
        } else {
            this.yearsValueGenerator = alwaysGenerator;
        }
        this.daysOfWeekCronField = Preconditions.checkNotNull(daysOfWeekCronField);
        this.daysOfMonthCronField = Preconditions.checkNotNull(daysOfMonthCronField);
        this.daysOfYearCronField = daysOfYearCronField;
        this.months = Preconditions.checkNotNull(months);
        this.hours = Preconditions.checkNotNull(hours);
        this.minutes = Preconditions.checkNotNull(minutes);
        this.seconds = Preconditions.checkNotNull(seconds);
    }

    @Override
    public Optional<ZonedDateTime> nextExecution(ZonedDateTime date) {
        Preconditions.checkNotNull(date);
        try {
            ZonedDateTime nextMatch = this.nextClosestMatch(date);
            if (nextMatch.equals(date)) {
                nextMatch = this.nextClosestMatch(date.plusSeconds(1L));
            }
            return Optional.of(nextMatch);
        }
        catch (NoSuchValueException e) {
            return Optional.empty();
        }
    }

    private ZonedDateTime nextClosestMatch(ZonedDateTime date) throws NoSuchValueException {
        ExecutionTimeResult result = new ExecutionTimeResult(date, false);
        for (int i = 0; i < 100000; ++i) {
            if ((result = this.potentialNextClosestMatch(result.getTime())).isMatch()) {
                return result.getTime();
            }
            if (result.getTime().getYear() - date.getYear() <= 100) continue;
            throw new NoSuchValueException();
        }
        throw new NoSuchValueException();
    }

    private ExecutionTimeResult potentialNextClosestMatch(ZonedDateTime date) throws NoSuchValueException {
        List year = this.yearsValueGenerator.generateCandidates(date.getYear(), date.getYear()).stream().filter(d -> d >= date.getYear()).collect(Collectors.toList());
        int lowestMonth = this.months.getValues().get(0);
        int lowestHour = this.hours.getValues().get(0);
        int lowestMinute = this.minutes.getValues().get(0);
        int lowestSecond = this.seconds.getValues().get(0);
        if (year.isEmpty()) {
            return this.getNextPotentialYear(date, lowestMonth, lowestHour, lowestMinute, lowestSecond);
        }
        if (!this.months.getValues().contains(date.getMonthValue())) {
            return this.getNextPotentialMonth(date, lowestHour, lowestMinute, lowestSecond);
        }
        Optional<TimeNode> optionalDays = this.generateDays(this.cronDefinition, date);
        if (!optionalDays.isPresent()) {
            return new ExecutionTimeResult(this.toBeginOfNextMonth(date), false);
        }
        TimeNode node = optionalDays.get();
        if (!node.getValues().contains(date.getDayOfMonth())) {
            return this.getNextPotentialDayOfMonth(date, lowestHour, lowestMinute, lowestSecond, node);
        }
        if (!this.hours.getValues().contains(date.getHour())) {
            return this.getNextPotentialHour(date);
        }
        if (!this.minutes.getValues().contains(date.getMinute())) {
            return this.getNextPotentialMinute(date);
        }
        if (!this.seconds.getValues().contains(date.getSecond())) {
            return this.getNextPotentialSecond(date);
        }
        return new ExecutionTimeResult(date, true);
    }

    private ExecutionTimeResult getNextPotentialYear(ZonedDateTime date, int lowestMonth, int lowestHour, int lowestMinute, int lowestSecond) throws NoSuchValueException {
        int newYear = this.yearsValueGenerator.generateNextValue(date.getYear());
        Optional<TimeNode> optionalDays = this.generateDays(this.cronDefinition, ZonedDateTime.of(LocalDate.of(newYear, lowestMonth, 1), LocalTime.MIN, date.getZone()));
        if (optionalDays.isPresent()) {
            List<Integer> days = optionalDays.get().getValues();
            return new ExecutionTimeResult(ZonedDateTime.of(LocalDate.of(newYear, lowestMonth, (int)days.get(0)), LocalTime.of(lowestHour, lowestMinute, lowestSecond), date.getZone()), false);
        }
        return new ExecutionTimeResult(this.toBeginOfNextMonth(date), false);
    }

    private ExecutionTimeResult getNextPotentialMonth(ZonedDateTime date, int lowestHour, int lowestMinute, int lowestSecond) {
        NearestValue nearestValue = this.months.getNextValue(date.getMonthValue(), 0);
        int nextMonths = nearestValue.getValue();
        if (nearestValue.getShifts() > 0) {
            return new ExecutionTimeResult(date.truncatedTo(ChronoUnit.DAYS).withMonth(1).withDayOfMonth(1).plusYears(nearestValue.getShifts()), false);
        }
        Optional<TimeNode> optionalDays = this.generateDays(this.cronDefinition, ZonedDateTime.of(LocalDateTime.of(date.getYear(), nextMonths, 1, 0, 0), date.getZone()));
        if (optionalDays.isPresent()) {
            List<Integer> days = optionalDays.get().getValues();
            return new ExecutionTimeResult(date.truncatedTo(ChronoUnit.SECONDS).withMonth(nextMonths).withDayOfMonth(days.get(0)).with(LocalTime.of(lowestHour, lowestMinute, lowestSecond)), false);
        }
        return new ExecutionTimeResult(this.toBeginOfNextMonth(date), false);
    }

    private ExecutionTimeResult getNextPotentialDayOfMonth(ZonedDateTime date, int lowestHour, int lowestMinute, int lowestSecond, TimeNode node) {
        NearestValue nearestValue = node.getNextValue(date.getDayOfMonth(), 0);
        if (nearestValue.getShifts() > 0) {
            return new ExecutionTimeResult(date.truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1).plusMonths(nearestValue.getShifts()), false);
        }
        return new ExecutionTimeResult(date.truncatedTo(ChronoUnit.SECONDS).withDayOfMonth(nearestValue.getValue()).with(LocalTime.of(lowestHour, lowestMinute, lowestSecond)), false);
    }

    private ExecutionTimeResult getNextPotentialHour(ZonedDateTime date) throws NoSuchValueException {
        return SingleExecutionTime.getNextPotentialValue(date, this.hours, ChronoField.HOUR_OF_DAY);
    }

    private ExecutionTimeResult getNextPotentialMinute(ZonedDateTime date) throws NoSuchValueException {
        return SingleExecutionTime.getNextPotentialValue(date, this.minutes, ChronoField.MINUTE_OF_HOUR);
    }

    private ExecutionTimeResult getNextPotentialSecond(ZonedDateTime date) throws NoSuchValueException {
        return SingleExecutionTime.getNextPotentialValue(date, this.seconds, ChronoField.SECOND_OF_MINUTE);
    }

    private static ExecutionTimeResult getNextPotentialValue(ZonedDateTime date, TimeNode node, TemporalField field) throws NoSuchValueException {
        HashSet<Integer> values = new HashSet<Integer>(node.values);
        TemporalUnit unit = field.getBaseUnit();
        long maximum = field.range().getMaximum();
        long minimum = field.range().getMinimum();
        long range = maximum - minimum;
        ZonedDateTime newDate = date;
        for (long i = 0L; i < 2L * range; ++i) {
            if (!values.contains((newDate = newDate.plus(1L, unit)).get(field))) continue;
            newDate = newDate.truncatedTo(unit);
            return new ExecutionTimeResult(newDate, false);
        }
        throw new NoSuchValueException();
    }

    private ZonedDateTime toBeginOfNextMonth(ZonedDateTime datetime) {
        return datetime.truncatedTo(ChronoUnit.DAYS).plusMonths(1L).withDayOfMonth(1);
    }

    private ZonedDateTime previousClosestMatch(ZonedDateTime date) throws NoSuchValueException {
        ExecutionTimeResult result = new ExecutionTimeResult(date, false);
        for (int i = 0; i < 100000; ++i) {
            if (!(result = this.potentialPreviousClosestMatch(result.getTime())).isMatch()) continue;
            return result.getTime();
        }
        throw new NoSuchValueException();
    }

    private ExecutionTimeResult potentialPreviousClosestMatch(ZonedDateTime date) throws NoSuchValueException {
        List<Integer> year = this.yearsValueGenerator.generateCandidates(date.getYear(), date.getYear());
        Optional<TimeNode> optionalDays = this.generateDays(this.cronDefinition, date);
        if (!optionalDays.isPresent()) {
            return new ExecutionTimeResult(this.toEndOfPreviousMonth(date), false);
        }
        TimeNode days = optionalDays.get();
        int highestMonth = this.months.getValues().get(this.months.getValues().size() - 1);
        int highestDay = days.getValues().get(days.getValues().size() - 1);
        int highestHour = this.hours.getValues().get(this.hours.getValues().size() - 1);
        int highestMinute = this.minutes.getValues().get(this.minutes.getValues().size() - 1);
        int highestSecond = this.seconds.getValues().get(this.seconds.getValues().size() - 1);
        if (year.isEmpty()) {
            return this.getPreviousPotentialYear(date, days, highestMonth, highestDay, highestHour, highestMinute, highestSecond);
        }
        if (!this.months.getValues().contains(date.getMonthValue())) {
            return this.getPreviousPotentialMonth(date, highestDay, highestHour, highestMinute, highestSecond);
        }
        if (!days.getValues().contains(date.getDayOfMonth())) {
            return this.getPreviousPotentialDayOfMonth(date, days, highestHour, highestMinute, highestSecond);
        }
        if (!this.hours.getValues().contains(date.getHour())) {
            return this.getPreviousPotentialHour(date);
        }
        if (!this.minutes.getValues().contains(date.getMinute())) {
            return this.getPreviousPotentialMinute(date);
        }
        if (!this.seconds.getValues().contains(date.getSecond())) {
            return this.getPreviousPotentialSecond(date);
        }
        return new ExecutionTimeResult(date.truncatedTo(ChronoUnit.SECONDS), true);
    }

    private ExecutionTimeResult getPreviousPotentialYear(ZonedDateTime date, TimeNode days, int highestMonth, int highestDay, int highestHour, int highestMinute, int highestSecond) throws NoSuchValueException {
        int highestDayOfMonth;
        int previousYear = this.yearsValueGenerator.generatePreviousValue(date.getYear());
        if (highestDay > 28 && highestDay > (highestDayOfMonth = LocalDate.of(previousYear, highestMonth, 1).lengthOfMonth())) {
            NearestValue nearestValue = days.getPreviousValue(highestDay, 1);
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDate.of(previousYear, highestMonth, 1), MAX_SECONDS, date.getZone()).minusMonths(nearestValue.getShifts()).with(TemporalAdjusters.lastDayOfMonth());
                return new ExecutionTimeResult(newDate, false);
            }
            highestDay = nearestValue.getValue();
        }
        return new ExecutionTimeResult(ZonedDateTime.of(LocalDate.of(previousYear, highestMonth, highestDay), LocalTime.of(highestHour, highestMinute, highestSecond), date.getZone()), false);
    }

    private ExecutionTimeResult getPreviousPotentialMonth(ZonedDateTime date, int highestDay, int highestHour, int highestMinute, int highestSecond) {
        NearestValue nearestValue = this.months.getPreviousValue(date.getMonthValue(), 0);
        int previousMonths = nearestValue.getValue();
        if (nearestValue.getShifts() > 0) {
            ZonedDateTime newDate = ZonedDateTime.of(LocalDate.of(date.getYear(), 12, 31), MAX_SECONDS, date.getZone()).minusYears(nearestValue.getShifts());
            return new ExecutionTimeResult(newDate, false);
        }
        ZonedDateTime newDate = ZonedDateTime.of(date.getYear(), date.getMonthValue(), 1, 0, 0, 0, 0, date.getZone()).minusNanos(1L);
        return new ExecutionTimeResult(newDate, false);
    }

    private ExecutionTimeResult getPreviousPotentialDayOfMonth(ZonedDateTime date, TimeNode days, int highestHour, int highestMinute, int highestSecond) {
        NearestValue nearestValue = days.getPreviousValue(date.getDayOfMonth(), 0);
        if (nearestValue.getShifts() > 0) {
            ZonedDateTime newDate = ZonedDateTime.of(LocalDate.of(date.getYear(), date.getMonthValue(), 1), MAX_SECONDS, date.getZone()).minusMonths(nearestValue.getShifts()).with(TemporalAdjusters.lastDayOfMonth());
            return new ExecutionTimeResult(newDate, false);
        }
        return new ExecutionTimeResult(date.withDayOfMonth(nearestValue.getValue()).with(LocalTime.of(highestHour, highestMinute, highestSecond)).truncatedTo(ChronoUnit.SECONDS), false);
    }

    private ExecutionTimeResult getPreviousPotentialHour(ZonedDateTime date) throws NoSuchValueException {
        return SingleExecutionTime.getPreviousPotentialValue(date, this.hours, ChronoField.HOUR_OF_DAY);
    }

    private ExecutionTimeResult getPreviousPotentialMinute(ZonedDateTime date) throws NoSuchValueException {
        return SingleExecutionTime.getPreviousPotentialValue(date, this.minutes, ChronoField.MINUTE_OF_HOUR);
    }

    private ExecutionTimeResult getPreviousPotentialSecond(ZonedDateTime date) throws NoSuchValueException {
        return SingleExecutionTime.getPreviousPotentialValue(date, this.seconds, ChronoField.SECOND_OF_MINUTE);
    }

    private static ExecutionTimeResult getPreviousPotentialValue(ZonedDateTime date, TimeNode node, TemporalField field) throws NoSuchValueException {
        HashSet<Integer> values = new HashSet<Integer>(node.values);
        TemporalUnit unit = field.getBaseUnit();
        long maximum = field.range().getMaximum();
        long minimum = field.range().getMinimum();
        long range = maximum - minimum;
        ZonedDateTime newDate = date;
        for (long i = 0L; i < 2L * range; ++i) {
            if (!values.contains((newDate = newDate.minus(1L, unit)).get(field))) continue;
            newDate = newDate.truncatedTo(unit).plus(1L, unit).minusSeconds(1L);
            return new ExecutionTimeResult(newDate, false);
        }
        throw new NoSuchValueException();
    }

    private ZonedDateTime toEndOfPreviousMonth(ZonedDateTime datetime) {
        ZonedDateTime previousMonth = datetime.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
        int highestHour = this.hours.getValues().get(this.hours.getValues().size() - 1);
        int highestMinute = this.minutes.getValues().get(this.minutes.getValues().size() - 1);
        int highestSecond = this.seconds.getValues().get(this.seconds.getValues().size() - 1);
        return ZonedDateTime.of(previousMonth.getYear(), previousMonth.getMonth().getValue(), previousMonth.getDayOfMonth(), highestHour, highestMinute, highestSecond, 0, previousMonth.getZone());
    }

    private Optional<TimeNode> generateDays(CronDefinition cronDefinition, ZonedDateTime date) {
        if (this.isGenerateDaysAsDoY(cronDefinition)) {
            return this.generateDayCandidatesUsingDoY(date);
        }
        if (cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK) != null && cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_MONTH) != null) {
            return this.generateDaysDoWAndDoMSupported(cronDefinition, date);
        }
        if (cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK) == null) {
            return Optional.of(this.generateDayCandidatesUsingDoM(date));
        }
        return Optional.of(this.generateDayCandidatesUsingDoW(date, ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()));
    }

    private boolean isGenerateDaysAsDoY(CronDefinition cronDefinition) {
        if (!cronDefinition.containsFieldDefinition(CronFieldName.DAY_OF_YEAR)) {
            return false;
        }
        if (!cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_YEAR).getConstraints().getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK)) {
            return true;
        }
        return !(this.daysOfYearCronField.getExpression() instanceof QuestionMark);
    }

    private Optional<TimeNode> generateDayCandidatesUsingDoY(ZonedDateTime reference) {
        int year = reference.getYear();
        int month = reference.getMonthValue();
        LocalDate date = LocalDate.of(year, 1, 1);
        int lengthOfYear = date.lengthOfYear();
        List<Integer> candidates = FieldValueGeneratorFactory.createDayOfYearValueGeneratorInstance(this.daysOfYearCronField, year).generateCandidates(1, lengthOfYear);
        int low = LocalDate.of(year, month, 1).getDayOfYear();
        int high = month == 12 ? LocalDate.of(year, 12, 31).getDayOfYear() + 1 : LocalDate.of(year, month + 1, 1).getDayOfYear();
        List collectedCandidates = candidates.stream().filter(dayOfYear -> dayOfYear >= low && dayOfYear < high).map(dayOfYear -> LocalDate.ofYearDay(reference.getYear(), dayOfYear).getDayOfMonth()).collect(Collectors.toList());
        return Optional.of(collectedCandidates).filter(Predicates.not(List::isEmpty)).map(TimeNode::new);
    }

    private Optional<TimeNode> generateDaysDoWAndDoMSupported(CronDefinition cronDefinition, ZonedDateTime date) {
        boolean questionMarkSupported = cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK).getConstraints().getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK);
        if (questionMarkSupported) {
            List<Integer> candidates = this.generateDayCandidatesQuestionMarkSupportedUsingDoWAndDoM(date.getYear(), date.getMonthValue(), ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue());
            return Optional.of(candidates).filter(Predicates.not(List::isEmpty)).map(TimeNode::new);
        }
        List<Integer> candidates = this.generateDayCandidatesQuestionMarkNotSupportedUsingDoWAndDoM(date.getYear(), date.getMonthValue(), ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue());
        return Optional.of(candidates).filter(Predicates.not(List::isEmpty)).map(TimeNode::new);
    }

    @Override
    public Optional<Duration> timeToNextExecution(ZonedDateTime date) {
        Optional<ZonedDateTime> next = this.nextExecution(date);
        return next.map(zonedDateTime -> Duration.between(date, zonedDateTime));
    }

    @Override
    public Optional<ZonedDateTime> lastExecution(ZonedDateTime date) {
        Preconditions.checkNotNull(date);
        try {
            ZonedDateTime previousMatch = this.previousClosestMatch(date);
            if (previousMatch.equals(date)) {
                previousMatch = this.previousClosestMatch(date.minusSeconds(1L));
            }
            return Optional.of(previousMatch);
        }
        catch (NoSuchValueException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Duration> timeFromLastExecution(ZonedDateTime date) {
        return this.lastExecution(date).map(zonedDateTime -> Duration.between(zonedDateTime, date));
    }

    @Override
    public boolean isMatch(ZonedDateTime date) {
        boolean isSecondGranularity = this.cronDefinition.containsFieldDefinition(CronFieldName.SECOND);
        date = isSecondGranularity ? date.truncatedTo(ChronoUnit.SECONDS) : date.truncatedTo(ChronoUnit.MINUTES);
        Optional<ZonedDateTime> last = this.lastExecution(date);
        if (last.isPresent()) {
            Optional<ZonedDateTime> next = this.nextExecution(last.get());
            if (next.isPresent()) {
                return next.get().equals(date);
            }
            boolean everythingInRange = false;
            try {
                everythingInRange = this.dateValuesInExpectedRanges(this.nextClosestMatch(date), date);
            }
            catch (NoSuchValueException noSuchValueException) {
                // empty catch block
            }
            try {
                everythingInRange = this.dateValuesInExpectedRanges(this.previousClosestMatch(date), date);
            }
            catch (NoSuchValueException noSuchValueException) {
                // empty catch block
            }
            return everythingInRange;
        }
        return false;
    }

    private boolean dateValuesInExpectedRanges(ZonedDateTime validCronDate, ZonedDateTime date) {
        boolean everythingInRange = true;
        if (this.cronDefinition.getFieldDefinition(CronFieldName.YEAR) != null) {
            boolean bl = everythingInRange = validCronDate.getYear() == date.getYear();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.MONTH) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getMonthValue() == date.getMonthValue();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_MONTH) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getDayOfMonth() == date.getDayOfMonth();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getDayOfWeek().getValue() == date.getDayOfWeek().getValue();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.HOUR) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getHour() == date.getHour();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.MINUTE) != null) {
            boolean bl = everythingInRange = everythingInRange && validCronDate.getMinute() == date.getMinute();
        }
        if (this.cronDefinition.getFieldDefinition(CronFieldName.SECOND) != null) {
            everythingInRange = everythingInRange && validCronDate.getSecond() == date.getSecond();
        }
        return everythingInRange;
    }

    private List<Integer> generateDayCandidatesQuestionMarkNotSupportedUsingDoWAndDoM(int year, int month, WeekDay mondayDoWValue) {
        LocalDate date = LocalDate.of(year, month, 1);
        int lengthOfMonth = date.lengthOfMonth();
        if (this.daysOfMonthCronField.getExpression() instanceof Always && this.daysOfWeekCronField.getExpression() instanceof Always) {
            return FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth).stream().distinct().sorted().collect(Collectors.toList());
        }
        if (this.daysOfMonthCronField.getExpression() instanceof Always) {
            return FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth).stream().distinct().sorted().collect(Collectors.toList());
        }
        if (this.daysOfWeekCronField.getExpression() instanceof Always) {
            return FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth).stream().distinct().sorted().collect(Collectors.toList());
        }
        List<Integer> dayOfWeekCandidates = FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth);
        List<Integer> dayOfMonthCandidates = FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth);
        if (this.cronDefinition.isMatchDayOfWeekAndDayOfMonth()) {
            HashSet<Integer> intersection = new HashSet<Integer>(dayOfWeekCandidates);
            return dayOfMonthCandidates.stream().filter(intersection::contains).distinct().sorted().collect(Collectors.toList());
        }
        return Stream.concat(dayOfWeekCandidates.stream(), dayOfMonthCandidates.stream()).distinct().sorted().collect(Collectors.toList());
    }

    private List<Integer> generateDayCandidatesQuestionMarkSupportedUsingDoWAndDoM(int year, int month, WeekDay mondayDoWValue) {
        LocalDate date = LocalDate.of(year, month, 1);
        int lengthOfMonth = date.lengthOfMonth();
        if (this.daysOfMonthCronField.getExpression() instanceof Always && this.daysOfWeekCronField.getExpression() instanceof Always) {
            return FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth).stream().distinct().sorted().collect(Collectors.toList());
        }
        if (this.daysOfMonthCronField.getExpression() instanceof QuestionMark) {
            return FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth).stream().distinct().sorted().collect(Collectors.toList());
        }
        if (this.daysOfWeekCronField.getExpression() instanceof QuestionMark) {
            return FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth).stream().distinct().sorted().collect(Collectors.toList());
        }
        return Stream.concat(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth).stream(), FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth).stream()).distinct().sorted().collect(Collectors.toList());
    }

    private TimeNode generateDayCandidatesUsingDoM(ZonedDateTime reference) {
        LocalDate date = LocalDate.of(reference.getYear(), reference.getMonthValue(), 1);
        int lengthOfMonth = date.lengthOfMonth();
        List<Integer> candidates = FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, reference.getYear(), reference.getMonthValue()).generateCandidates(1, lengthOfMonth).stream().distinct().sorted().collect(Collectors.toList());
        return new TimeNode(candidates);
    }

    private TimeNode generateDayCandidatesUsingDoW(ZonedDateTime reference, WeekDay mondayDoWValue) {
        LocalDate date = LocalDate.of(reference.getYear(), reference.getMonthValue(), 1);
        int lengthOfMonth = date.lengthOfMonth();
        List<Integer> candidates = FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, reference.getYear(), reference.getMonthValue(), mondayDoWValue).generateCandidates(1, lengthOfMonth).stream().distinct().sorted().collect(Collectors.toList());
        return new TimeNode(candidates);
    }

    private static final class ExecutionTimeResult {
        private final ZonedDateTime time;
        private final boolean isMatch;

        private ExecutionTimeResult(ZonedDateTime time, boolean isMatch) {
            this.time = time;
            this.isMatch = isMatch;
        }

        public ZonedDateTime getTime() {
            return this.time;
        }

        public boolean isMatch() {
            return this.isMatch;
        }

        public String toString() {
            return "ExecutionTimeResult{time=" + this.time + ", isMatch=" + this.isMatch + '}';
        }
    }
}

