/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.mapper.WeekDay;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.expression.And;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.FieldValueGeneratorFactory;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.cronutils.utils.Preconditions;
import java.util.ArrayList;
import java.util.List;

class AndDayOfWeekValueGenerator
extends FieldValueGenerator {
    private int year;
    private int month;
    private WeekDay mondayDoWValue;

    public AndDayOfWeekValueGenerator(CronField cronField, int year, int month, WeekDay mondayDoWValue) {
        super(cronField);
        Preconditions.checkArgument(CronFieldName.DAY_OF_WEEK.equals((Object)cronField.getField()), "CronField does not belong to day of week");
        this.year = year;
        this.month = month;
        this.mondayDoWValue = mondayDoWValue;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        And and = (And)this.cronField.getExpression();
        for (FieldExpression expression : and.getExpressions()) {
            CronField cronField = new CronField(CronFieldName.DAY_OF_WEEK, expression, this.cronField.getConstraints());
            List<Integer> candidatesList = FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(cronField, this.year, this.month, this.mondayDoWValue).generateCandidates(start, end);
            if (candidatesList == null) continue;
            values.addAll(candidatesList);
        }
        return values;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof And;
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        return 0;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        return 0;
    }

    @Override
    public boolean isMatch(int value) {
        return false;
    }
}

