/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.definition;

import com.cronutils.model.definition.CronConstraint;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.definition.FieldDefinition;
import com.cronutils.utils.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CronDefinition
implements Serializable {
    private Map<CronFieldName, FieldDefinition> fieldDefinitions;
    private Set<CronConstraint> cronConstraints;
    private boolean strictRanges;
    private boolean matchDayOfWeekAndDayOfMonth;

    public CronDefinition(List<FieldDefinition> fieldDefinitions, Set<CronConstraint> cronConstraints, boolean strictRanges, boolean matchDayOfWeekAndDayOfMonth) {
        Preconditions.checkNotNull(fieldDefinitions, "Field definitions must not be null");
        Preconditions.checkNotNull(cronConstraints, "Cron validations must not be null");
        Preconditions.checkNotNullNorEmpty(fieldDefinitions, (Object)"Field definitions must not be empty");
        Preconditions.checkArgument(!fieldDefinitions.get(0).isOptional(), "The first field must not be optional");
        this.fieldDefinitions = new HashMap<CronFieldName, FieldDefinition>();
        for (FieldDefinition field : fieldDefinitions) {
            this.fieldDefinitions.put(field.getFieldName(), field);
        }
        this.cronConstraints = Collections.unmodifiableSet(cronConstraints);
        this.strictRanges = strictRanges;
        this.matchDayOfWeekAndDayOfMonth = matchDayOfWeekAndDayOfMonth;
    }

    public boolean isStrictRanges() {
        return this.strictRanges;
    }

    public boolean isMatchDayOfWeekAndDayOfMonth() {
        return this.matchDayOfWeekAndDayOfMonth;
    }

    public Set<FieldDefinition> getFieldDefinitions() {
        return new HashSet<FieldDefinition>(this.fieldDefinitions.values());
    }

    public Map<CronFieldName, FieldDefinition> retrieveFieldDefinitionsAsMap() {
        return Collections.unmodifiableMap(this.fieldDefinitions);
    }

    public FieldDefinition getFieldDefinition(CronFieldName cronFieldName) {
        return this.fieldDefinitions.get((Object)cronFieldName);
    }

    public boolean containsFieldDefinition(CronFieldName cronFieldName) {
        return this.fieldDefinitions.containsKey((Object)cronFieldName);
    }

    public Set<CronConstraint> getCronConstraints() {
        return this.cronConstraints;
    }
}

