/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.model.field.CronField;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import java.util.ArrayList;
import java.util.List;

class BetweenFieldValueGenerator
extends FieldValueGenerator {
    public BetweenFieldValueGenerator(CronField cronField) {
        super(cronField);
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        Between between = (Between)this.cronField.getExpression();
        int candidate = reference;
        while (++candidate < this.map(between.getFrom())) {
        }
        if (candidate > this.map(between.getTo())) {
            throw new NoSuchValueException();
        }
        return candidate;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        Between between = (Between)this.cronField.getExpression();
        int candidate = reference;
        while (--candidate > this.map(between.getTo())) {
        }
        if (candidate < this.map(between.getFrom())) {
            throw new NoSuchValueException();
        }
        return candidate;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        Between between = (Between)this.cronField.getExpression();
        int expressionStart = this.map(between.getFrom());
        int expressionEnd = this.map(between.getTo());
        int rangestart = start;
        int rangeend = end;
        if (start <= expressionEnd && expressionStart <= end) {
            if (expressionEnd < end) {
                rangeend = expressionEnd;
            }
            if (this.map(between.getFrom()) > start) {
                rangestart = expressionStart;
            }
            try {
                if (rangestart != start) {
                    values.add(rangestart);
                }
                int reference = this.generateNextValue(rangestart);
                while (reference < rangeend) {
                    values.add(reference);
                    reference = this.generateNextValue(reference);
                }
                if (rangeend != end) {
                    values.add(reference);
                }
            }
            catch (NoSuchValueException noSuchValueException) {
                // empty catch block
            }
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        Between between = (Between)this.cronField.getExpression();
        return value >= this.map(between.getFrom()) && value <= this.map(between.getTo());
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof Between;
    }

    private int map(FieldValue fieldValue) {
        if (fieldValue instanceof IntegerFieldValue) {
            return ((IntegerFieldValue)fieldValue).getValue();
        }
        throw new RuntimeException("Non integer values at intervals are not fully supported yet.");
    }
}

