/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.descriptor;

import com.cronutils.Function;
import com.cronutils.descriptor.DescriptionStrategy;
import com.cronutils.descriptor.TimeDescriptionStrategy$$Lambda$1;
import com.cronutils.descriptor.TimeDescriptionStrategy$$Lambda$2;
import com.cronutils.descriptor.TimeDescriptionStrategy$$Lambda$3;
import com.cronutils.descriptor.TimeDescriptionStrategy$$Lambda$4;
import com.cronutils.descriptor.TimeDescriptionStrategy$$Lambda$5;
import com.cronutils.descriptor.TimeDescriptionStrategy$$Lambda$6;
import com.cronutils.descriptor.TimeDescriptionStrategy$$Lambda$7;
import com.cronutils.descriptor.TimeDescriptionStrategy$$Lambda$8;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.utils.Preconditions;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;

class TimeDescriptionStrategy
extends DescriptionStrategy {
    private FieldExpression hours;
    private FieldExpression minutes;
    private FieldExpression seconds;
    private Set<Function<TimeFields, String>> descriptions;
    private int defaultSeconds = 0;

    TimeDescriptionStrategy(ResourceBundle bundle, FieldExpression hours, FieldExpression minutes, FieldExpression seconds) {
        super(bundle);
        this.hours = this.ensureInstance(hours, new Always());
        this.minutes = this.ensureInstance(minutes, new Always());
        this.seconds = this.ensureInstance(seconds, new On(new IntegerFieldValue(this.defaultSeconds)));
        this.descriptions = new HashSet<Function<TimeFields, String>>();
        this.registerFunctions();
    }

    private FieldExpression ensureInstance(FieldExpression expression, FieldExpression defaultExpression) {
        Preconditions.checkNotNull(defaultExpression, "Default expression must not be null");
        if (expression != null) {
            return expression;
        }
        return defaultExpression;
    }

    @Override
    public String describe() {
        TimeFields fields = new TimeFields(this.hours, this.minutes, this.seconds);
        for (Function<TimeFields, String> function : this.descriptions) {
            if ("".equals(function.apply(fields))) continue;
            return function.apply(fields);
        }
        String secondsDesc = "";
        String minutesDesc = "";
        String hoursDesc = this.addTimeExpressions(this.describe(this.hours), this.bundle.getString("hour"), this.bundle.getString("hours"));
        if (!(this.seconds instanceof On) || !this.isDefault((On)this.seconds)) {
            secondsDesc = this.addTimeExpressions(this.describe(this.seconds), this.bundle.getString("second"), this.bundle.getString("seconds"));
        }
        if (!(this.minutes instanceof On) || !this.isDefault((On)this.minutes)) {
            minutesDesc = this.addTimeExpressions(this.describe(this.minutes), this.bundle.getString("minute"), this.bundle.getString("minutes"));
        }
        return String.format("%s %s %s", secondsDesc, minutesDesc, hoursDesc);
    }

    private String addTimeExpressions(String description, String singular, String plural) {
        return description.replaceAll("%s", singular).replaceAll("%p", plural);
    }

    private void registerFunctions() {
        this.descriptions.add(TimeDescriptionStrategy$$Lambda$1.lambdaFactory$(this));
        this.descriptions.add(TimeDescriptionStrategy$$Lambda$2.lambdaFactory$(this));
        this.descriptions.add(TimeDescriptionStrategy$$Lambda$3.lambdaFactory$(this));
        this.descriptions.add(TimeDescriptionStrategy$$Lambda$4.lambdaFactory$(this));
        this.descriptions.add(TimeDescriptionStrategy$$Lambda$5.lambdaFactory$(this));
        this.descriptions.add(TimeDescriptionStrategy$$Lambda$6.lambdaFactory$(this));
        this.descriptions.add(TimeDescriptionStrategy$$Lambda$7.lambdaFactory$(this));
        this.descriptions.add(TimeDescriptionStrategy$$Lambda$8.lambdaFactory$(this));
    }

    private boolean isDefault(On on) {
        return on.getTime().getValue() == this.defaultSeconds;
    }

    static /* synthetic */ String lambda$registerFunctions$7(TimeDescriptionStrategy this_, TimeFields timeFields) {
        if (timeFields.hours instanceof Every && timeFields.minutes instanceof On && timeFields.seconds instanceof On) {
            if (((On)timeFields.minutes).getTime().getValue() == 0 && ((On)timeFields.seconds).getTime().getValue() == 0) {
                return String.format("%s %s", this_.bundle.getString("every"), this_.bundle.getString("hour"));
            }
            String result = String.format("%s %s %s %s %s %s ", this_.bundle.getString("every"), ((Every)this_.hours).getPeriod().getValue(), this_.bundle.getString("hours"), this_.bundle.getString("at"), this_.bundle.getString("minute"), ((On)this_.minutes).getTime().getValue());
            if (this_.isDefault((On)timeFields.seconds)) {
                return result;
            }
            return String.format("%s %s %s", this_.bundle.getString("and"), this_.bundle.getString("second"), ((On)this_.seconds).getTime().getValue());
        }
        return "";
    }

    static /* synthetic */ String lambda$registerFunctions$6(TimeDescriptionStrategy this_, TimeFields timeFields) {
        if (timeFields.hours instanceof Always && timeFields.minutes instanceof Every && timeFields.seconds instanceof On) {
            Every minute = (Every)timeFields.minutes;
            String desc = minute.getPeriod().getValue() == 1 && this_.isDefault((On)timeFields.seconds) ? String.format("%s %s", this_.bundle.getString("every"), this_.bundle.getString("minute")) : String.format("%s %s %s ", this_.bundle.getString("every"), minute.getPeriod().getValue(), this_.bundle.getString("minutes"));
            if (minute.getExpression() instanceof Between) {
                desc = String.format("%s %s", desc, this_.describe(minute.getExpression()));
            }
            return desc;
        }
        return "";
    }

    static /* synthetic */ String lambda$registerFunctions$5(TimeDescriptionStrategy this_, TimeFields timeFields) {
        if (timeFields.hours instanceof On && timeFields.minutes instanceof Between) {
            if (timeFields.seconds instanceof On) {
                return String.format("%s %s %s %02d:%02d %s %02d:%02d", this_.bundle.getString("every"), this_.bundle.getString("minute"), this_.bundle.getString("between"), ((On)timeFields.hours).getTime().getValue(), ((Between)timeFields.minutes).getFrom().getValue(), this_.bundle.getString("and"), ((On)timeFields.hours).getTime().getValue(), ((Between)timeFields.minutes).getTo().getValue());
            }
            if (timeFields.seconds instanceof Always) {
                return String.format("%s %s %s %02d:%02d %s %02d:%02d", this_.bundle.getString("every"), this_.bundle.getString("second"), this_.bundle.getString("between"), ((On)timeFields.hours).getTime().getValue(), ((Between)timeFields.minutes).getFrom().getValue(), this_.bundle.getString("and"), ((On)timeFields.hours).getTime().getValue(), ((Between)timeFields.minutes).getTo().getValue());
            }
        }
        return "";
    }

    static /* synthetic */ String lambda$registerFunctions$4(TimeDescriptionStrategy this_, TimeFields timeFields) {
        if (timeFields.hours instanceof On && timeFields.minutes instanceof Always && timeFields.seconds instanceof Always) {
            return String.format("%s %02d:00", this_.bundle.getString("at"), ((On)this_.hours).getTime().getValue());
        }
        return "";
    }

    static /* synthetic */ String lambda$registerFunctions$3(TimeDescriptionStrategy this_, TimeFields timeFields) {
        if (timeFields.hours instanceof On && timeFields.minutes instanceof On && timeFields.seconds instanceof On) {
            if (this_.isDefault((On)timeFields.seconds)) {
                return String.format("%s %02d:%02d", this_.bundle.getString("at"), ((On)this_.hours).getTime().getValue(), ((On)this_.minutes).getTime().getValue());
            }
            return String.format("%s %02d:%02d:%02d", this_.bundle.getString("at"), ((On)this_.hours).getTime().getValue(), ((On)this_.minutes).getTime().getValue(), ((On)this_.seconds).getTime().getValue());
        }
        return "";
    }

    static /* synthetic */ String lambda$registerFunctions$2(TimeDescriptionStrategy this_, TimeFields timeFields) {
        if (timeFields.hours instanceof On && timeFields.minutes instanceof On && timeFields.seconds instanceof Always) {
            return String.format("%s %s %s %02d:%02d", this_.bundle.getString("every"), this_.bundle.getString("second"), this_.bundle.getString("at"), ((On)this_.hours).getTime().getValue(), ((On)this_.minutes).getTime().getValue());
        }
        return "";
    }

    static /* synthetic */ String lambda$registerFunctions$1(TimeDescriptionStrategy this_, TimeFields timeFields) {
        if (timeFields.hours instanceof Always && timeFields.minutes instanceof On && timeFields.seconds instanceof On) {
            if (this_.isDefault((On)timeFields.seconds)) {
                if (this_.isDefault((On)timeFields.minutes)) {
                    return String.format("%s %s ", this_.bundle.getString("every"), this_.bundle.getString("hour"));
                }
                return String.format("%s %s %s %s %s", this_.bundle.getString("every"), this_.bundle.getString("hour"), this_.bundle.getString("at"), this_.bundle.getString("minute"), ((On)timeFields.minutes).getTime().getValue());
            }
            return String.format("%s %s %s %s %s %s %s %s", this_.bundle.getString("every"), this_.bundle.getString("hour"), this_.bundle.getString("at"), this_.bundle.getString("minute"), ((On)timeFields.minutes).getTime().getValue(), this_.bundle.getString("and"), this_.bundle.getString("second"), ((On)timeFields.seconds).getTime().getValue());
        }
        return "";
    }

    static /* synthetic */ String lambda$registerFunctions$0(TimeDescriptionStrategy this_, TimeFields timeFields) {
        if (timeFields.hours instanceof Always && timeFields.minutes instanceof Always) {
            if (timeFields.seconds instanceof Always) {
                return String.format("%s %s ", this_.bundle.getString("every"), this_.bundle.getString("second"));
            }
            if (timeFields.seconds instanceof On) {
                if (this_.isDefault((On)timeFields.seconds)) {
                    return String.format("%s %s ", this_.bundle.getString("every"), this_.bundle.getString("minute"));
                }
                return String.format("%s %s %s %s %02d", this_.bundle.getString("every"), this_.bundle.getString("minute"), this_.bundle.getString("at"), this_.bundle.getString("second"), ((On)timeFields.seconds).getTime().getValue());
            }
        }
        return "";
    }

    class TimeFields {
        public FieldExpression seconds;
        public FieldExpression minutes;
        public FieldExpression hours;

        public TimeFields(FieldExpression hours, FieldExpression minutes, FieldExpression seconds) {
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
        }
    }
}

