/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.builder;

import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.visitor.ValidationFieldExpressionVisitor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Map;

public class CronBuilder {
    private final Map<CronFieldName, CronField> fields = Maps.newHashMap();
    private CronDefinition definition;

    private CronBuilder(CronDefinition definition) {
        this.definition = definition;
    }

    public static CronBuilder cron(CronDefinition definition) {
        return new CronBuilder(definition);
    }

    public CronBuilder withYear(FieldExpression expression) {
        return this.addField(CronFieldName.YEAR, expression);
    }

    public CronBuilder withDoM(FieldExpression expression) {
        return this.addField(CronFieldName.DAY_OF_MONTH, expression);
    }

    public CronBuilder withMonth(FieldExpression expression) {
        return this.addField(CronFieldName.MONTH, expression);
    }

    public CronBuilder withDoW(FieldExpression expression) {
        return this.addField(CronFieldName.DAY_OF_WEEK, expression);
    }

    public CronBuilder withHour(FieldExpression expression) {
        return this.addField(CronFieldName.HOUR, expression);
    }

    public CronBuilder withMinute(FieldExpression expression) {
        return this.addField(CronFieldName.MINUTE, expression);
    }

    public CronBuilder withSecond(FieldExpression expression) {
        return this.addField(CronFieldName.SECOND, expression);
    }

    public Cron instance() {
        return new Cron(this.definition, Lists.newArrayList(this.fields.values())).validate();
    }

    @VisibleForTesting
    CronBuilder addField(CronFieldName name, FieldExpression expression) {
        Preconditions.checkState((this.definition != null ? 1 : 0) != 0, (Object)"CronBuilder not initialized.");
        FieldConstraints constraints = this.definition.getFieldDefinition(name).getConstraints();
        expression.accept(new ValidationFieldExpressionVisitor(constraints, this.definition.isStrictRanges()));
        this.fields.put(name, new CronField(name, expression, constraints));
        return this;
    }
}

