/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

class EveryFieldValueGenerator
extends FieldValueGenerator {
    public EveryFieldValueGenerator(FieldExpression expression) {
        super(expression);
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        int remainder;
        if (reference >= this.expression.getConstraints().getEndRange()) {
            throw new NoSuchValueException();
        }
        Every every = (Every)this.expression;
        int referenceWithoutOffset = reference - this.offset();
        int period = every.getTime().getValue();
        int next = reference + (period - (remainder = referenceWithoutOffset % period));
        if (next < this.expression.getConstraints().getStartRange()) {
            return this.expression.getConstraints().getStartRange();
        }
        if (next > this.expression.getConstraints().getEndRange()) {
            throw new NoSuchValueException();
        }
        return next;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        Every every = (Every)this.expression;
        int period = every.getTime().getValue();
        int remainder = reference % period;
        if (remainder == 0) {
            return reference - period;
        }
        return reference - remainder;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList values = Lists.newArrayList();
        try {
            int reference = this.generateNextValue(start);
            while (reference < end) {
                values.add(reference);
                reference = this.generateNextValue(reference);
            }
        }
        catch (NoSuchValueException e) {
            e.printStackTrace();
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        Every every = (Every)this.expression;
        int start = every.getConstraints().getStartRange();
        return (value - start) % every.getTime().getValue() == 0;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof Every;
    }

    @VisibleForTesting
    int offset() {
        return this.expression.getConstraints().getStartRange();
    }
}

