/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field.expression;

import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.expression.And;
import com.cronutils.model.field.expression.visitor.FieldExpressionVisitor;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.model.field.value.SpecialCharFieldValue;
import org.apache.commons.lang3.Validate;

public abstract class FieldExpression {
    protected FieldConstraints constraints;

    public FieldExpression(FieldConstraints constraints) {
        Validate.notNull((Object)constraints, (String)"FieldConstraints cannot be null", (Object[])new Object[0]);
        this.constraints = constraints;
    }

    public And and(FieldExpression exp) {
        return new And().and(this).and(exp);
    }

    public FieldConstraints getConstraints() {
        return this.constraints;
    }

    protected FieldValue validate(FieldValue fieldValue) {
        if (fieldValue instanceof IntegerFieldValue) {
            this.getConstraints().validateInRange(this.getConstraints().intToInt(((IntegerFieldValue)fieldValue).getValue()));
        } else {
            this.getConstraints().isSpecialCharAllowed(((SpecialCharFieldValue)fieldValue).getValue());
        }
        return fieldValue;
    }

    public abstract String asString();

    public final FieldExpression accept(FieldExpressionVisitor visitor) {
        Validate.notNull((Object)visitor, (String)"FieldExpressionVisitor must not be null", (Object[])new Object[0]);
        return visitor.visit(this);
    }
}

