/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.mapper.WeekDay;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.constraint.FieldConstraintsBuilder;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.cronutils.model.time.generator.OnDayOfWeekValueGenerator;
import com.cronutils.parser.field.CronParserField;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

class BetweenDayOfWeekValueGenerator
extends FieldValueGenerator {
    private int year;
    private int month;
    private WeekDay mondayDoWValue;

    public BetweenDayOfWeekValueGenerator(CronField cronField, int year, int month, WeekDay mondayDoWValue) {
        super(cronField.getExpression());
        Validate.isTrue((boolean)CronFieldName.DAY_OF_WEEK.equals((Object)cronField.getField()), (String)"CronField does not belong to day of week", (Object[])new Object[0]);
        this.year = year;
        this.month = month;
        this.mondayDoWValue = mondayDoWValue;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        Integer i;
        ArrayList values = Lists.newArrayList();
        Between between = (Between)this.expression;
        int startDayOfWeek = 0;
        int endDayOfWeek = 0;
        Object obj = between.getFrom().getValue();
        if (obj instanceof Integer) {
            i = (Integer)obj;
            startDayOfWeek = i;
        }
        if ((obj = between.getTo().getValue()) instanceof Integer) {
            i = (Integer)obj;
            endDayOfWeek = i;
        }
        for (int i2 = startDayOfWeek; i2 <= endDayOfWeek; ++i2) {
            FieldConstraintsBuilder fcb = FieldConstraintsBuilder.instance().forField(CronFieldName.DAY_OF_WEEK);
            CronParserField parser = new CronParserField(CronFieldName.DAY_OF_WEEK, fcb.createConstraintsInstance());
            CronField cronField = parser.parse(Integer.toString(i2));
            OnDayOfWeekValueGenerator odow = new OnDayOfWeekValueGenerator(cronField, this.year, this.month, this.mondayDoWValue);
            List<Integer> candidatesList = odow.generateCandidates(start, end);
            if (candidatesList == null) continue;
            values.addAll(candidatesList);
        }
        return values;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof Between;
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        return 0;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        return 0;
    }

    @Override
    public boolean isMatch(int value) {
        return false;
    }
}

