/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.mapper.WeekDay;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.expression.And;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.FieldValueGeneratorFactory;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

class AndDayOfWeekValueGenerator
extends FieldValueGenerator {
    private int year;
    private int month;
    private WeekDay mondayDoWValue;

    public AndDayOfWeekValueGenerator(CronField cronField, int year, int month, WeekDay mondayDoWValue) {
        super(cronField.getExpression());
        Validate.isTrue((boolean)CronFieldName.DAY_OF_WEEK.equals((Object)cronField.getField()), (String)"CronField does not belong to day of week", (Object[])new Object[0]);
        this.year = year;
        this.month = month;
        this.mondayDoWValue = mondayDoWValue;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList values = Lists.newArrayList();
        And and = (And)this.expression;
        for (FieldExpression expression : and.getExpressions()) {
            CronField cronField = new CronField(CronFieldName.DAY_OF_WEEK, expression);
            List<Integer> candidatesList = FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(cronField, this.year, this.month, this.mondayDoWValue).generateCandidates(start, end);
            if (candidatesList == null) continue;
            values.addAll(candidatesList);
        }
        return values;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof And;
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        return 0;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        return 0;
    }

    @Override
    public boolean isMatch(int value) {
        return false;
    }
}

