/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events;

import com.criteo.events.CRTOLog;
import com.criteo.events.Event;
import com.criteo.events.product.BasketProduct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

public class BasketViewEvent
extends Event {
    private CopyOnWriteArrayList<BasketProduct> basketProductList = new CopyOnWriteArrayList();
    private AtomicReference<Currency> currency = new AtomicReference();

    public BasketViewEvent(Iterable<BasketProduct> basketProducts) {
        this.setBasketProductList(basketProducts);
    }

    public BasketViewEvent(BasketProduct ... basketProducts) {
        this.setBasketProductList(new ArrayList<BasketProduct>(Arrays.asList(basketProducts)));
    }

    public BasketViewEvent(Currency currency, Iterable<BasketProduct> basketProducts, GregorianCalendar startDate, GregorianCalendar endDate) {
        this.setBasketProductList(basketProducts);
        this.setCurrency(currency);
        this.setStartDate(startDate);
        this.setEndDate(endDate);
    }

    public BasketViewEvent(BasketViewEvent event) {
        super(event);
        this.setBasketProductList(event.basketProductList);
        this.setCurrency(event.currency.get());
    }

    public void addBasketProduct(BasketProduct basketProduct) {
        if (basketProduct == null) {
            CRTOLog.e("Argument basketProduct must not be null");
            return;
        }
        this.basketProductList.add(basketProduct);
    }

    private CopyOnWriteArrayList<BasketProduct> makeBasketProducts(Iterable<BasketProduct> basketProductIterable) {
        CopyOnWriteArrayList<BasketProduct> basketProducts = new CopyOnWriteArrayList<BasketProduct>();
        for (BasketProduct product : basketProductIterable) {
            basketProducts.add(new BasketProduct(product.getProductId(), product.getPrice(), product.getQuantity()));
        }
        return basketProducts;
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            CRTOLog.e("Argument currency must not be null");
            return;
        }
        this.currency.set(currency);
    }

    public Currency getCurrency() {
        return this.currency.get();
    }

    public CopyOnWriteArrayList<BasketProduct> getBasketProductList() {
        return this.basketProductList;
    }

    public void setBasketProductList(Iterable<BasketProduct> basketProductList) {
        if (basketProductList == null) {
            CRTOLog.e("Argument basketProductList must not be null");
            return;
        }
        this.basketProductList = this.makeBasketProducts(basketProductList);
    }

    @Override
    public GregorianCalendar getStartDate() {
        return super.getStartDate();
    }

    @Override
    public GregorianCalendar getEndDate() {
        return super.getEndDate();
    }

    @Override
    public void setStartDate(GregorianCalendar startDate) {
        super.setStartDate(startDate);
    }

    @Override
    public void setEndDate(GregorianCalendar endDate) {
        super.setEndDate(endDate);
    }
}

