/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events;

import com.criteo.events.AppLaunchEvent;
import com.criteo.events.BasketViewEvent;
import com.criteo.events.CRTOLog;
import com.criteo.events.DataEvent;
import com.criteo.events.DeeplinkEvent;
import com.criteo.events.DeviceInfo;
import com.criteo.events.Event;
import com.criteo.events.EventService;
import com.criteo.events.ExtraData;
import com.criteo.events.HomeViewEvent;
import com.criteo.events.ProductListViewEvent;
import com.criteo.events.ProductViewEvent;
import com.criteo.events.TransactionConfirmationEvent;
import com.criteo.events.product.BasketProduct;
import com.criteo.events.product.Product;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class JSONSerializer {
    JSONSerializer() {
    }

    static JSONObject serializeToJSON(AppLaunchEvent event) {
        try {
            JSONObject serializedEvent = new JSONObject();
            serializedEvent.put("event", (Object)"appLaunch");
            if (event.getGoogleReferrer() != null) {
                serializedEvent.put("referrer", (Object)event.getGoogleReferrer());
            }
            serializedEvent.put("first_launch", event.isFirstLaunch());
            serializedEvent.put("timestamp", (Object)JSONSerializer.getFormattedDate(event.getTimestamp()));
            serializedEvent = JSONSerializer.addExtraData(event, serializedEvent);
            return serializedEvent;
        }
        catch (JSONException e) {
            CRTOLog.e("Error in JSON serialisation", e);
            return null;
        }
    }

    static JSONObject serializeToJSON(BasketViewEvent event) {
        try {
            JSONObject serializedEvent = new JSONObject();
            serializedEvent.put("event", (Object)"viewBasket");
            if (event.getBasketProductList() != null && !event.getBasketProductList().isEmpty()) {
                JSONArray basketProduct = new JSONArray();
                for (BasketProduct item : event.getBasketProductList()) {
                    JSONObject jsonItem = new JSONObject();
                    jsonItem.put("id", (Object)item.getProductId());
                    jsonItem.put("price", item.getPrice());
                    jsonItem.put("quantity", item.getQuantity());
                    basketProduct.put((Object)jsonItem);
                }
                serializedEvent.put("product", (Object)basketProduct);
            }
            if (event.getCurrency() != null) {
                serializedEvent.put("currency", (Object)event.getCurrency().getCurrencyCode());
            }
            serializedEvent.put("timestamp", (Object)JSONSerializer.getFormattedDate(event.getTimestamp()));
            serializedEvent = JSONSerializer.addExtraData(event, serializedEvent);
            return serializedEvent;
        }
        catch (JSONException e) {
            CRTOLog.e("Error in JSON serialisation", e);
            return null;
        }
    }

    static JSONObject serializeToJSON(HomeViewEvent event) {
        try {
            JSONObject serializedEvent = new JSONObject();
            serializedEvent.put("event", (Object)"viewHome");
            serializedEvent.put("timestamp", (Object)JSONSerializer.getFormattedDate(event.getTimestamp()));
            serializedEvent = JSONSerializer.addExtraData(event, serializedEvent);
            return serializedEvent;
        }
        catch (JSONException e) {
            CRTOLog.e("Error in JSON serialisation", e);
            return null;
        }
    }

    static JSONObject serializeToJSON(ProductListViewEvent event) {
        try {
            JSONObject serializedEvent = new JSONObject();
            serializedEvent.put("event", (Object)"viewListing");
            if (event.getCurrency() != null) {
                serializedEvent.put("currency", (Object)event.getCurrency().getCurrencyCode());
            }
            if (event.getProductList() != null && !event.getProductList().isEmpty()) {
                JSONArray productList = new JSONArray();
                for (Product product : event.getProductList()) {
                    JSONObject jsonProduct = new JSONObject();
                    jsonProduct.put("id", (Object)product.getProductId());
                    jsonProduct.put("price", product.getPrice());
                    productList.put((Object)jsonProduct);
                }
                serializedEvent.put("product", (Object)productList);
            }
            serializedEvent.put("timestamp", (Object)JSONSerializer.getFormattedDate(event.getTimestamp()));
            serializedEvent = JSONSerializer.addExtraData(event, serializedEvent);
            return serializedEvent;
        }
        catch (JSONException e) {
            CRTOLog.e("Error in JSON serialisation", e);
            return null;
        }
    }

    static JSONObject serializeToJSON(ProductViewEvent event) {
        try {
            JSONObject serializedEvent = new JSONObject();
            serializedEvent.put("event", (Object)"viewProduct");
            if (event.getCurrency() != null) {
                serializedEvent.put("currency", (Object)event.getCurrency().getCurrencyCode());
            }
            if (event.getProduct() != null) {
                JSONObject product = new JSONObject();
                product.put("id", (Object)event.getProduct().getProductId());
                product.put("price", event.getProduct().getPrice());
                serializedEvent.put("product", (Object)product);
            }
            serializedEvent.put("timestamp", (Object)JSONSerializer.getFormattedDate(event.getTimestamp()));
            serializedEvent = JSONSerializer.addExtraData(event, serializedEvent);
            return serializedEvent;
        }
        catch (JSONException e) {
            CRTOLog.e("Error in JSON serialisation", e);
            return null;
        }
    }

    static JSONObject serializeToJSON(TransactionConfirmationEvent event) {
        try {
            JSONObject serializedEvent = new JSONObject();
            serializedEvent.put("event", (Object)"trackTransaction");
            if (event.getCurrency() != null) {
                serializedEvent.put("currency", (Object)event.getCurrency().getCurrencyCode());
            }
            if (event.getTransactionId() != null) {
                serializedEvent.put("id", (Object)event.getTransactionId());
            }
            if (event.getBasketProductList() != null && !event.getBasketProductList().isEmpty()) {
                JSONArray basketProducts = new JSONArray();
                for (BasketProduct item : event.getBasketProductList()) {
                    JSONObject jsonItem = new JSONObject();
                    jsonItem.put("id", (Object)item.getProductId());
                    jsonItem.put("price", item.getPrice());
                    jsonItem.put("quantity", item.getQuantity());
                    basketProducts.put((Object)jsonItem);
                }
                serializedEvent.put("product", (Object)basketProducts);
            }
            serializedEvent.put("timestamp", (Object)JSONSerializer.getFormattedDate(event.getTimestamp()));
            serializedEvent = JSONSerializer.addExtraData(event, serializedEvent);
            return serializedEvent;
        }
        catch (JSONException e) {
            CRTOLog.e("Error in JSON serialisation", e);
            return null;
        }
    }

    static JSONObject serializeToJSON(DataEvent event) {
        try {
            JSONObject serializedEvent = new JSONObject();
            serializedEvent.put("event", (Object)"setData");
            serializedEvent.put("timestamp", (Object)JSONSerializer.getFormattedDate(event.getTimestamp()));
            serializedEvent = JSONSerializer.addExtraData(event, serializedEvent);
            return serializedEvent;
        }
        catch (JSONException e) {
            CRTOLog.e("Error in JSON serialisation", e);
            return null;
        }
    }

    static JSONObject serializeToJSON(DeeplinkEvent event) {
        try {
            JSONObject serializedEvent = new JSONObject();
            serializedEvent.put("event", (Object)"appDeeplink");
            serializedEvent.put("timestamp", (Object)JSONSerializer.getFormattedDate(event.getTimestamp()));
            serializedEvent.put("deeplink_uri", (Object)event.getDeeplinkUrl());
            serializedEvent = JSONSerializer.addExtraData(event, serializedEvent);
            return serializedEvent;
        }
        catch (JSONException e) {
            CRTOLog.e("Error in JSON serialisation", e);
            return null;
        }
    }

    private static String getFormattedDate(Date date) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        df.setTimeZone(tz);
        return df.format(date);
    }

    private static String getFormattedDate(GregorianCalendar date) {
        String year = String.format("%04d", date.get(1));
        String month = String.format("%02d", date.get(2) + 1);
        String day = String.format("%02d", date.get(5));
        return String.format("%s-%s-%sT00:00:00Z", year, month, day);
    }

    private static JSONObject addExtraData(Event event, JSONObject serializedEvent) throws JSONException {
        for (Map.Entry<String, ExtraData> dataEntry : event.getExtraDataMap().entrySet()) {
            JSONObject extraData = new JSONObject();
            if (dataEntry.getValue().getType() == ExtraData.ExtraDataType.Date) {
                extraData.put("value", (Object)JSONSerializer.getFormattedDate((GregorianCalendar)dataEntry.getValue().getValue()));
            } else {
                extraData.put("value", dataEntry.getValue().getValue());
            }
            String type = null;
            switch (dataEntry.getValue().getType()) {
                case Float: {
                    type = "float";
                    break;
                }
                case Int: {
                    type = "integer";
                    break;
                }
                case String: {
                    type = "string";
                    break;
                }
                case Date: {
                    type = "date";
                }
            }
            extraData.put("type", (Object)type);
            serializedEvent.put(dataEntry.getKey(), (Object)extraData);
        }
        return serializedEvent;
    }

    static JSONObject commonPayload(EventService eventService) throws JSONException {
        JSONObject payload = new JSONObject();
        JSONObject account = new JSONObject();
        account.put("app_name", (Object)eventService.getAccountName());
        account.put("country_code", (Object)eventService.getCountry());
        account.put("language_code", (Object)eventService.getLanguage());
        JSONObject id = new JSONObject();
        id.put("gaid", (Object)DeviceInfo.getAdvertisingId());
        id.put("limit_ad_tracking", DeviceInfo.getLimitAdTrackingEnabled());
        JSONObject appInfo = new JSONObject();
        appInfo.put("app_id", (Object)DeviceInfo.getBundleName());
        appInfo.put("app_name", (Object)DeviceInfo.getBundleName());
        appInfo.put("app_version", (Object)DeviceInfo.getAppVersion());
        appInfo.put("sdk_version", (Object)DeviceInfo.getSDKVersion());
        appInfo.put("app_language", (Object)DeviceInfo.getLanguage());
        appInfo.put("app_country", (Object)DeviceInfo.getCountry());
        JSONObject deviceInfo = new JSONObject();
        deviceInfo.put("platform", (Object)"android");
        deviceInfo.put("os_name", (Object)"android");
        deviceInfo.put("os_version", (Object)DeviceInfo.getAndroidVersion());
        deviceInfo.put("device_model", (Object)DeviceInfo.getModel());
        deviceInfo.put("device_manufacturer", (Object)DeviceInfo.getManufacturer());
        JSONArray alternateIds = new JSONArray();
        if (eventService.getEmail() != null) {
            JSONObject email = new JSONObject();
            email.put("value", (Object)eventService.getEmail());
            email.put("type", (Object)"email");
            email.put("hash_method", (Object)"md5");
            alternateIds.put((Object)email);
        }
        payload.put("account", (Object)account);
        payload.put("id", (Object)id);
        payload.put("device_info", (Object)deviceInfo);
        payload.put("app_info", (Object)appInfo);
        payload.put("alternate_ids", (Object)alternateIds);
        payload.put("version", (Object)"sdk_1.0.0");
        if (eventService.getCustomerId() != null) {
            payload.put("customer_id", (Object)eventService.getCustomerId());
        }
        return payload;
    }

    static void setPayloadEvent(JSONObject payload, JSONObject serializedEvent) throws JSONException {
        JSONArray events = new JSONArray();
        events.put((Object)serializedEvent);
        payload.put("events", (Object)events);
    }
}

