/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events;

import com.criteo.events.CRTOLog;
import com.criteo.events.SendPolicy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

class EventPoster {
    private URL url;
    private final SendPolicy sendPolicy;

    public EventPoster(URL url, SendPolicy sendPolicy) {
        this.url = url;
        this.sendPolicy = sendPolicy;
    }

    public EventPoster() {
        this.url = EventPoster.buildEventEndpoint();
        this.sendPolicy = new SendPolicy();
    }

    public URL getUrl() {
        return this.url;
    }

    public SendPolicy getSendPolicy() {
        return this.sendPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PostResult post(String payload) {
        boolean retry = false;
        StringBuilder response = new StringBuilder();
        int responseCode = -1;
        try {
            InputStream is;
            HttpURLConnection urlConnection = this.createHTTPConnection(this.url, payload.length());
            this.sendPayload(urlConnection, payload);
            responseCode = urlConnection.getResponseCode();
            if (responseCode != 200 && responseCode == 307) {
                this.url = new URL(urlConnection.getHeaderField("Location"));
                return PostResult.REDIRECT;
            }
            try {
                is = urlConnection.getInputStream();
            }
            catch (IOException e) {
                is = urlConnection.getErrorStream();
            }
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(is));
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                    response.append('\r');
                }
            }
            catch (IOException e) {
                CRTOLog.e("Error reading server response in background thread", e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException e) {
            CRTOLog.e("Network error while posting event in background thread", e);
            retry = true;
        }
        catch (SecurityException e) {
            CRTOLog.e("Security error while sending payload in background thread", e);
        }
        catch (Exception e) {
            CRTOLog.e("Exception while sending payload in background thread", e);
        }
        String responseBody = response.toString();
        if (!responseBody.isEmpty() && responseBody.contains("errors")) {
            CRTOLog.w("Response code : " + responseCode + " Body: " + responseBody);
        }
        return retry ? PostResult.RETRY_LATER : PostResult.DONE;
    }

    private static URL buildEventEndpoint() {
        try {
            return new URL(String.format("%s/m/event", EventPoster.resolveHost()));
        }
        catch (Exception e) {
            CRTOLog.e("Error creating Criteo url", e);
            return null;
        }
    }

    private static String resolveHost() {
        String result = "https://widget.criteo.com";
        String environmentOverride = System.getenv("CRITEO_WIDGET_BASEURL");
        if (environmentOverride != null) {
            result = environmentOverride + ":8050";
        }
        return result;
    }

    private HttpURLConnection createHTTPConnection(URL url, int length) throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setReadTimeout(60000);
        urlConnection.setConnectTimeout(60000);
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        urlConnection.setInstanceFollowRedirects(true);
        urlConnection.setFixedLengthStreamingMode(length);
        return urlConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPayload(HttpURLConnection urlConnection, String payload) throws IOException {
        try (BufferedWriter writer = null;){
            writer = new BufferedWriter(new OutputStreamWriter(urlConnection.getOutputStream(), "UTF-8"));
            writer.write(payload);
            writer.flush();
        }
    }

    static enum PostResult {
        DONE,
        RETRY_LATER,
        REDIRECT;

    }
}

