/*
 * Decompiled with CFR 0.152.
 */
package com.creativewidgetworks.expressionparser;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ParserException
extends Exception {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com/creativewidgetworks/expressionparser/parser");
    private int errorAtRow;
    private int errorAtCol;

    public ParserException(String msg) {
        super(msg);
        this.initialize(0, 0);
    }

    public ParserException(String msg, Throwable th) {
        super(msg, th);
        this.initialize(0, 0);
    }

    public ParserException(String msg, int row, int column) {
        super(msg);
        this.initialize(row, column);
    }

    public ParserException(String msg, Throwable th, int row, int column) {
        super(msg, th);
        this.initialize(row, column);
    }

    private void initialize(int row, int column) {
        this.errorAtRow = row;
        this.errorAtCol = column;
    }

    public int getErrorRow() {
        return this.errorAtRow;
    }

    public int getErrorColumn() {
        return this.errorAtCol;
    }

    public static String formatMessage(String message, Object ... parameters) {
        String formattedMessage = message;
        if (message != null) {
            if (bundle != null) {
                try {
                    formattedMessage = bundle.getString(message);
                }
                catch (MissingResourceException mre) {
                    // empty catch block
                }
            }
            if (parameters != null) {
                try {
                    if (!formattedMessage.contains("{")) {
                        throw new IllegalArgumentException();
                    }
                    formattedMessage = MessageFormat.format(formattedMessage, parameters);
                }
                catch (IllegalArgumentException iae) {
                    StringBuilder sb = new StringBuilder();
                    for (Object parameter : parameters) {
                        sb.append(";");
                        sb.append(parameter);
                    }
                    formattedMessage = formattedMessage + sb.toString();
                }
            }
        }
        return formattedMessage;
    }
}

