/*
 * Decompiled with CFR 0.152.
 */
package com.ceelites.devutils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.text.TextUtils;
import android.util.Pair;
import android.widget.ImageView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConstantMethods {
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isOnline(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        boolean connectedOrConnecting = false;
        try {
            connectedOrConnecting = cm.getActiveNetworkInfo().isConnectedOrConnecting();
        }
        catch (Exception e) {
            e.printStackTrace();
            connectedOrConnecting = false;
        }
        return connectedOrConnecting;
    }

    public static boolean isIntentAvailable(Context context, Intent intent) {
        PackageManager mgr = context.getPackageManager();
        List list = mgr.queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }

    public static int getNumber(String string) {
        int number = 0;
        if (!ConstantMethods.isEmptyString(string) && TextUtils.isDigitsOnly((CharSequence)string)) {
            number = Integer.parseInt(string);
        }
        return number;
    }

    public static boolean isEmptyString(@Nullable CharSequence string) {
        return TextUtils.isEmpty((CharSequence)string) || string.toString().equalsIgnoreCase("null");
    }

    public static String extractBundle(@NonNull Bundle bundle) {
        StringBuilder keyvals = new StringBuilder();
        for (String s : bundle.keySet()) {
            keyvals.append(s).append(": ").append(bundle.getString(s)).append("\n");
        }
        return keyvals.toString();
    }

    public static ArrayList<Pair<String, String>> extractBundleArrayList(@NonNull Bundle bundle) {
        ArrayList<Pair<String, String>> keyValPairs = new ArrayList<Pair<String, String>>();
        for (String s : bundle.keySet()) {
            keyValPairs.add((Pair<String, String>)Pair.create((Object)s, (Object)bundle.getString(s)));
        }
        return keyValPairs;
    }

    public static boolean isArrayListEmpty(ArrayList arrayList) {
        return arrayList == null || arrayList.isEmpty();
    }

    public static void applyTintingToImageView(Resources res, ImageView imageView, @ColorRes int color) {
        Drawable drawable = imageView.getDrawable();
        imageView.setImageDrawable(ConstantMethods.applyTinting(res, drawable, color));
    }

    public static Drawable applyTinting(Resources res, Drawable drawable, @ColorRes int colorRes) {
        int color = res.getColor(colorRes);
        drawable.mutate();
        Drawable drawableToTint = DrawableCompat.wrap((Drawable)drawable);
        DrawableCompat.setTint((Drawable)drawableToTint, (int)color);
        return drawableToTint;
    }

    public static Drawable getTintedDrawable(Resources res, @DrawableRes Drawable drawable, @ColorRes int color) {
        return ConstantMethods.applyTinting(res, drawable, color);
    }

    public static void applyTintingToImageView(ImageView imageView, @ColorInt int color) {
        Drawable drawable = imageView.getDrawable();
        imageView.setImageDrawable(ConstantMethods.applyTinting(drawable, color));
    }

    public static Drawable applyTinting(Drawable drawable, @ColorInt int color) {
        drawable.mutate();
        Drawable drawableToTint = DrawableCompat.wrap((Drawable)drawable);
        DrawableCompat.setTint((Drawable)drawableToTint, (int)color);
        return drawableToTint;
    }

    public static Drawable getTintedDrawable(@DrawableRes Drawable drawable, @ColorInt int color) {
        return ConstantMethods.applyTinting(drawable, color);
    }

    public static String addToCommaSeparatedString(String commaSeparatedString, String stringToAdd, boolean allowDuplicates) {
        String joinedStrings;
        if (ConstantMethods.isEmptyString(commaSeparatedString)) {
            joinedStrings = stringToAdd;
        } else {
            String[] commaSeparatedStrings = ConstantMethods.failSafeSplit(commaSeparatedString, ",");
            ArrayList commaSeparatedStringArray = (ArrayList)Arrays.asList(commaSeparatedStrings);
            if (!allowDuplicates) {
                boolean isExists = false;
                for (String string : commaSeparatedStrings) {
                    if (!string.equalsIgnoreCase(stringToAdd)) continue;
                    isExists = true;
                    break;
                }
                if (!isExists) {
                    commaSeparatedStringArray.add(stringToAdd);
                }
            } else {
                commaSeparatedStringArray.add(stringToAdd);
            }
            joinedStrings = TextUtils.join((CharSequence)",", (Iterable)commaSeparatedStringArray);
        }
        return joinedStrings;
    }

    public static String[] failSafeSplit(String stringToSplit, String delimiter) {
        if (stringToSplit.contains(delimiter)) {
            return TextUtils.split((String)stringToSplit, (String)delimiter);
        }
        return new String[]{stringToSplit};
    }
}

