/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service;

import com.coze.openapi.client.common.BaseResponse;
import com.coze.openapi.client.exception.CozeApiException;
import com.coze.openapi.service.utils.Utils;
import java.io.IOException;
import java.lang.reflect.Type;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okio.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;

public class APIResponseCallAdapter<R>
implements CallAdapter<R, Call<R>> {
    private static final Logger logger = LoggerFactory.getLogger(APIResponseCallAdapter.class);
    private final Type responseType;

    public APIResponseCallAdapter(Type responseType) {
        this.responseType = responseType;
    }

    public Type responseType() {
        return this.responseType;
    }

    public Call<R> adapt(final Call<R> call) {
        return new Call<R>(){

            public Response<R> execute() throws IOException {
                BaseResponse baseResponse;
                Response response = call.execute();
                if (!response.isSuccessful()) {
                    logger.warn("HTTP error: " + response.code() + " " + response.message());
                    String errStr = "http exception";
                    try {
                        ResponseBody errorBody = response.errorBody();
                        if (errorBody != null) {
                            errStr = errorBody.string();
                            BaseResponse baseResponse2 = Utils.fromJson(errStr, BaseResponse.class);
                            throw new CozeApiException(baseResponse2.getCode(), baseResponse2.getMsg(), Utils.getLogID(response));
                        }
                        throw new CozeApiException(response.code(), "http exception", Utils.getLogID(response));
                    }
                    catch (Exception e) {
                        throw new CozeApiException(response.code(), errStr, Utils.getLogID(response));
                    }
                }
                Object body = response.body();
                if (body instanceof BaseResponse && (baseResponse = (BaseResponse)body).getCode() != 0) {
                    logger.warn("API error: " + baseResponse.getCode() + " " + baseResponse.getMsg());
                    throw new CozeApiException(baseResponse.getCode(), baseResponse.getMsg(), Utils.getLogID(response));
                }
                return response;
            }

            public void enqueue(final Callback<R> callback) {
                call.enqueue(new Callback<R>(){

                    public void onResponse(Call<R> call, Response<R> response) {
                        try {
                            callback.onResponse(call, this.execute());
                        }
                        catch (Exception e) {
                            this.onFailure(call, e);
                        }
                    }

                    public void onFailure(Call<R> call, Throwable t) {
                        callback.onFailure(call, t);
                    }
                });
            }

            public boolean isExecuted() {
                return call.isExecuted();
            }

            public void cancel() {
                call.cancel();
            }

            public boolean isCanceled() {
                return call.isCanceled();
            }

            public Call<R> clone() {
                return APIResponseCallAdapter.this.adapt(call.clone());
            }

            public Request request() {
                return call.request();
            }

            public Timeout timeout() {
                return call.timeout();
            }
        };
    }
}

