/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.auth;

import com.coze.openapi.client.auth.GetJWTAccessTokenReq;
import com.coze.openapi.client.auth.OAuthToken;
import com.coze.openapi.client.auth.model.SessionContext;
import com.coze.openapi.client.auth.scope.Scope;
import com.coze.openapi.service.auth.Auth;
import com.coze.openapi.service.auth.JWTOAuthClient;
import java.util.Objects;
import lombok.NonNull;

public class JWTOAuth
extends Auth {
    private Integer ttl;
    private String sessionName;
    private Scope scope;
    private String enterpriseID;
    private Long accountID;
    private SessionContext sessionContext;
    @NonNull
    private JWTOAuthClient jwtClient;

    public JWTOAuth(JWTOAuthClient client) {
        Objects.requireNonNull(client, "client must not be null");
        this.jwtClient = client;
        this.ttl = client.getTtl();
    }

    protected boolean needRefresh() {
        return this.accessToken == null || System.currentTimeMillis() / 1000L > this.refreshAt;
    }

    @Override
    public String token() {
        if (!this.needRefresh()) {
            return this.accessToken;
        }
        GetJWTAccessTokenReq req = GetJWTAccessTokenReq.builder().enterpriseID(this.enterpriseID).scope(this.scope).ttl(this.ttl).sessionName(this.sessionName).sessionContext(this.sessionContext).accountID(this.accountID).build();
        OAuthToken resp = this.jwtClient.getAccessToken(req);
        this.accessToken = resp.getAccessToken();
        this.expiresIn = resp.getExpiresIn().intValue();
        this.refreshAt = this.expiresIn - this.getRefreshBefore();
        return this.accessToken;
    }

    private long getRefreshBefore() {
        if (this.ttl == null) {
            return 0L;
        }
        if (this.ttl >= 600) {
            return 30L;
        }
        if (this.ttl >= 60) {
            return 10L;
        }
        if (this.ttl >= 30) {
            return 5L;
        }
        return 0L;
    }

    public static OAuthJWTBuilder builder() {
        return new OAuthJWTBuilder();
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getEnterpriseID() {
        return this.enterpriseID;
    }

    public Long getAccountID() {
        return this.accountID;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @NonNull
    public JWTOAuthClient getJwtClient() {
        return this.jwtClient;
    }

    private void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    private void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    private void setScope(Scope scope) {
        this.scope = scope;
    }

    private void setEnterpriseID(String enterpriseID) {
        this.enterpriseID = enterpriseID;
    }

    private void setAccountID(Long accountID) {
        this.accountID = accountID;
    }

    private void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    private void setJwtClient(@NonNull JWTOAuthClient jwtClient) {
        if (jwtClient == null) {
            throw new NullPointerException("jwtClient is marked non-null but is null");
        }
        this.jwtClient = jwtClient;
    }

    public JWTOAuth(Integer ttl, String sessionName, Scope scope, String enterpriseID, Long accountID, SessionContext sessionContext, @NonNull JWTOAuthClient jwtClient) {
        if (jwtClient == null) {
            throw new NullPointerException("jwtClient is marked non-null but is null");
        }
        this.ttl = ttl;
        this.sessionName = sessionName;
        this.scope = scope;
        this.enterpriseID = enterpriseID;
        this.accountID = accountID;
        this.sessionContext = sessionContext;
        this.jwtClient = jwtClient;
    }

    public JWTOAuth() {
    }

    public static class OAuthJWTBuilder {
        private Integer ttl;
        private String sessionName;
        private Scope scope;
        private String enterpriseID;
        private Long accountID;
        private SessionContext sessionContext;
        private JWTOAuthClient jwtClient;

        public JWTOAuth build() {
            JWTOAuth jwt = new JWTOAuth();
            if (this.jwtClient == null) {
                throw new IllegalStateException("jwtClient is required");
            }
            jwt.setJwtClient(this.jwtClient);
            if (this.ttl != null) {
                jwt.ttl = this.ttl;
            } else {
                jwt.setTtl(this.jwtClient.getTtl());
            }
            jwt.setSessionName(this.sessionName);
            jwt.setSessionContext(this.sessionContext);
            jwt.setAccountID(this.accountID);
            jwt.setEnterpriseID(this.enterpriseID);
            jwt.setScope(this.scope);
            return jwt;
        }

        OAuthJWTBuilder() {
        }

        public OAuthJWTBuilder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public OAuthJWTBuilder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public OAuthJWTBuilder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public OAuthJWTBuilder enterpriseID(String enterpriseID) {
            this.enterpriseID = enterpriseID;
            return this;
        }

        public OAuthJWTBuilder accountID(Long accountID) {
            this.accountID = accountID;
            return this;
        }

        public OAuthJWTBuilder sessionContext(SessionContext sessionContext) {
            this.sessionContext = sessionContext;
            return this;
        }

        public OAuthJWTBuilder jwtClient(@NonNull JWTOAuthClient jwtClient) {
            if (jwtClient == null) {
                throw new NullPointerException("jwtClient is marked non-null but is null");
            }
            this.jwtClient = jwtClient;
            return this;
        }

        public String toString() {
            return "JWTOAuth.OAuthJWTBuilder(ttl=" + this.ttl + ", sessionName=" + this.sessionName + ", scope=" + this.scope + ", enterpriseID=" + this.enterpriseID + ", accountID=" + this.accountID + ", sessionContext=" + this.sessionContext + ", jwtClient=" + this.jwtClient + ")";
        }
    }
}

