/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.dataset.document.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class DocumentChunkStrategy {
    @JsonProperty(value="chunk_type")
    private Integer chunkType;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="remove_extra_spaces")
    private Boolean removeExtraSpaces;
    @JsonProperty(value="remove_urls_emails")
    private Boolean removeUrlsEmails;
    @JsonProperty(value="separator")
    private String separator;

    public static DocumentChunkStrategy buildAuto() {
        return DocumentChunkStrategy.builder().chunkType(0).build();
    }

    public static DocumentChunkStrategy buildCustom(int maxTokens, String separator, boolean removeExtraSpaces, boolean removeUrlsEmails) {
        return DocumentChunkStrategy.builder().chunkType(1).maxTokens(maxTokens).separator(separator).removeExtraSpaces(removeExtraSpaces).removeUrlsEmails(removeUrlsEmails).build();
    }

    public static DocumentChunkStrategyBuilder builder() {
        return new DocumentChunkStrategyBuilder();
    }

    public Integer getChunkType() {
        return this.chunkType;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Boolean getRemoveExtraSpaces() {
        return this.removeExtraSpaces;
    }

    public Boolean getRemoveUrlsEmails() {
        return this.removeUrlsEmails;
    }

    public String getSeparator() {
        return this.separator;
    }

    @JsonProperty(value="chunk_type")
    private void setChunkType(Integer chunkType) {
        this.chunkType = chunkType;
    }

    @JsonProperty(value="max_tokens")
    private void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="remove_extra_spaces")
    private void setRemoveExtraSpaces(Boolean removeExtraSpaces) {
        this.removeExtraSpaces = removeExtraSpaces;
    }

    @JsonProperty(value="remove_urls_emails")
    private void setRemoveUrlsEmails(Boolean removeUrlsEmails) {
        this.removeUrlsEmails = removeUrlsEmails;
    }

    @JsonProperty(value="separator")
    private void setSeparator(String separator) {
        this.separator = separator;
    }

    public DocumentChunkStrategy() {
    }

    public DocumentChunkStrategy(Integer chunkType, Integer maxTokens, Boolean removeExtraSpaces, Boolean removeUrlsEmails, String separator) {
        this.chunkType = chunkType;
        this.maxTokens = maxTokens;
        this.removeExtraSpaces = removeExtraSpaces;
        this.removeUrlsEmails = removeUrlsEmails;
        this.separator = separator;
    }

    public static class DocumentChunkStrategyBuilder {
        private Integer chunkType;
        private Integer maxTokens;
        private Boolean removeExtraSpaces;
        private Boolean removeUrlsEmails;
        private String separator;

        public DocumentChunkStrategy build() {
            if (this.chunkType == null) {
                throw new IllegalStateException("chunkType is required");
            }
            if (this.chunkType == 1 && (this.maxTokens == null || this.separator == null || this.removeExtraSpaces == null || this.removeUrlsEmails == null)) {
                throw new IllegalStateException("All fields must be non-null when chunk_type is 1");
            }
            DocumentChunkStrategy strategy = new DocumentChunkStrategy();
            strategy.setChunkType(this.chunkType);
            strategy.setMaxTokens(this.maxTokens);
            strategy.setRemoveExtraSpaces(this.removeExtraSpaces);
            strategy.setRemoveUrlsEmails(this.removeUrlsEmails);
            strategy.setSeparator(this.separator);
            return strategy;
        }

        DocumentChunkStrategyBuilder() {
        }

        @JsonProperty(value="chunk_type")
        public DocumentChunkStrategyBuilder chunkType(Integer chunkType) {
            this.chunkType = chunkType;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public DocumentChunkStrategyBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @JsonProperty(value="remove_extra_spaces")
        public DocumentChunkStrategyBuilder removeExtraSpaces(Boolean removeExtraSpaces) {
            this.removeExtraSpaces = removeExtraSpaces;
            return this;
        }

        @JsonProperty(value="remove_urls_emails")
        public DocumentChunkStrategyBuilder removeUrlsEmails(Boolean removeUrlsEmails) {
            this.removeUrlsEmails = removeUrlsEmails;
            return this;
        }

        @JsonProperty(value="separator")
        public DocumentChunkStrategyBuilder separator(String separator) {
            this.separator = separator;
            return this;
        }

        public String toString() {
            return "DocumentChunkStrategy.DocumentChunkStrategyBuilder(chunkType=" + this.chunkType + ", maxTokens=" + this.maxTokens + ", removeExtraSpaces=" + this.removeExtraSpaces + ", removeUrlsEmails=" + this.removeUrlsEmails + ", separator=" + this.separator + ")";
        }
    }
}

