/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.workflow;

import com.coze.openapi.api.WorkflowRunAPI;
import com.coze.openapi.api.WorkflowRunHistoryAPI;
import com.coze.openapi.client.workflows.run.ResumeRunReq;
import com.coze.openapi.client.workflows.run.RunWorkflowReq;
import com.coze.openapi.client.workflows.run.RunWorkflowResp;
import com.coze.openapi.client.workflows.run.model.WorkflowEvent;
import com.coze.openapi.service.service.workflow.EventCallback;
import com.coze.openapi.service.service.workflow.WorkflowRunHistoryService;
import com.coze.openapi.service.utils.Utils;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;

public class WorkflowRunService {
    private final WorkflowRunAPI workflowRunAPI;
    private final WorkflowRunHistoryService historyService;

    public WorkflowRunService(WorkflowRunAPI runAPI, WorkflowRunHistoryAPI historyService) {
        this.workflowRunAPI = runAPI;
        this.historyService = new WorkflowRunHistoryService(historyService);
    }

    public RunWorkflowResp create(RunWorkflowReq req) {
        return Utils.execute(this.workflowRunAPI.run(req, req));
    }

    public Flowable<WorkflowEvent> stream(RunWorkflowReq req) {
        return WorkflowRunService.stream(this.workflowRunAPI.stream(req, req));
    }

    public Flowable<WorkflowEvent> resume(ResumeRunReq req) {
        return WorkflowRunService.stream(this.workflowRunAPI.resume(req, req));
    }

    public static Flowable<WorkflowEvent> stream(Call<ResponseBody> apiCall) {
        return Flowable.create(emitter -> apiCall.enqueue((Callback)new EventCallback((FlowableEmitter<WorkflowEvent>)emitter)), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public WorkflowRunHistoryService histories() {
        return this.historyService;
    }
}

