/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.dataset.document.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Base64;

public class DocumentSourceInfo {
    @JsonProperty(value="file_base64")
    private String fileBase64;
    @JsonProperty(value="file_type")
    private String fileType;
    @JsonProperty(value="web_url")
    private String webUrl;
    @JsonProperty(value="document_source")
    private Integer documentSource;

    public static DocumentSourceInfo buildLocalFile(String content, String fileType) {
        String encodedContent = Base64.getEncoder().encodeToString(content.getBytes());
        DocumentSourceInfo info = new DocumentSourceInfo();
        info.setFileBase64(encodedContent);
        info.setFileType(fileType);
        return info;
    }

    public static DocumentSourceInfo buildWebPage(String url) {
        DocumentSourceInfo info = new DocumentSourceInfo();
        info.setWebUrl(url);
        info.setDocumentSource(1);
        return info;
    }

    @JsonProperty(value="file_base64")
    private void setFileBase64(String fileBase64) {
        this.fileBase64 = fileBase64;
    }

    @JsonProperty(value="file_type")
    private void setFileType(String fileType) {
        this.fileType = fileType;
    }

    @JsonProperty(value="web_url")
    private void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    @JsonProperty(value="document_source")
    private void setDocumentSource(Integer documentSource) {
        this.documentSource = documentSource;
    }

    public String getFileBase64() {
        return this.fileBase64;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public Integer getDocumentSource() {
        return this.documentSource;
    }
}

